/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.container;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PlaceBlockNearbyTask;
import com.player2.playerengine.tasks.movement.GetCloseToBlockTask;
import com.player2.playerengine.tasks.resources.CollectRecipeCataloguedResourcesTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class CraftInTableTask
extends ResourceTask {
    private final RecipeTarget[] targets;
    private BlockPos craftingTablePos = null;
    private final TimerGame craftTimer = new TimerGame(2.0);
    private boolean isCrafting = false;

    public CraftInTableTask(RecipeTarget[] targets) {
        super(CraftInTableTask.extractItemTargets(targets));
        this.targets = targets;
    }

    public CraftInTableTask(RecipeTarget target) {
        this(new RecipeTarget[]{target});
    }

    private static ItemTarget[] extractItemTargets(RecipeTarget[] recipeTargets) {
        return (ItemTarget[])Arrays.stream(recipeTargets).map(t -> new ItemTarget(t.getOutputItem(), t.getTargetCount())).toArray(ItemTarget[]::new);
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController controller) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController controller) {
        controller.getBehaviour().push();
        for (RecipeTarget target : this.targets) {
            for (ItemTarget ingredient : target.getRecipe().getSlots()) {
                if (ingredient == null || ingredient.isEmpty()) continue;
                controller.getBehaviour().addProtectedItems(ingredient.getMatches());
            }
        }
    }

    @Override
    protected Task onResourceTick(PlayerEngineController controller) {
        boolean allDone = Arrays.stream(this.targets).allMatch(targetx -> controller.getItemStorage().getItemCount(targetx.getOutputItem()) >= targetx.getTargetCount());
        if (allDone) {
            return null;
        }
        if (!StorageHelper.hasRecipeMaterialsOrTarget(controller, this.targets)) {
            this.setDebugState("Collecting ingredients");
            return new CollectRecipeCataloguedResourcesTask(false, this.targets);
        }
        if (this.craftingTablePos == null || !controller.getWorld().m_8055_(this.craftingTablePos).m_60713_(Blocks.f_50091_)) {
            Optional<BlockPos> nearestTable = controller.getBlockScanner().getNearestBlock(Blocks.f_50091_);
            if (nearestTable.isPresent()) {
                this.craftingTablePos = nearestTable.get();
                this.setDebugState("Found crafting table: " + this.craftingTablePos.m_123344_());
            } else {
                this.craftingTablePos = null;
                this.setDebugState("Crafting table not found.");
            }
        }
        if (this.craftingTablePos == null) {
            if (controller.getItemStorage().hasItem(Items.f_41960_)) {
                this.setDebugState("Placing crafting table.");
                return new PlaceBlockNearbyTask(Blocks.f_50091_);
            }
            this.setDebugState("Obtaining crafting table.");
            return TaskCatalogue.getItemTask(Items.f_41960_, 1);
        }
        if (!this.craftingTablePos.m_123314_(new Vec3i((int)controller.getEntity().m_20182_().f_82479_, (int)controller.getEntity().m_20182_().f_82480_, (int)controller.getEntity().m_20182_().f_82481_), 3.5)) {
            this.setDebugState("Going to crafting table at: " + this.craftingTablePos.m_123344_());
            return new GetCloseToBlockTask(this.craftingTablePos);
        }
        this.setDebugState("Crafting...");
        if (!this.isCrafting) {
            this.craftTimer.reset();
            this.isCrafting = true;
        }
        if (!this.craftTimer.elapsed()) {
            return null;
        }
        for (RecipeTarget target : this.targets) {
            int currentAmount = controller.getItemStorage().getItemCount(target.getOutputItem());
            if (currentAmount >= target.getTargetCount()) continue;
            int craftsNeeded = (int)Math.ceil((double)(target.getTargetCount() - currentAmount) / (double)target.getRecipe().outputCount());
            for (int i = 0; i < craftsNeeded; ++i) {
                if (!StorageHelper.hasRecipeMaterialsOrTarget(controller, new RecipeTarget(target.getOutputItem(), target.getRecipe().outputCount(), target.getRecipe()))) {
                    Debug.logWarning("Not enough ingredients to craft, even though the check passed. Aborting.");
                    return new CollectRecipeCataloguedResourcesTask(false, this.targets);
                }
                LivingEntityInventory inventory = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
                for (ItemTarget ingredient : target.getRecipe().getSlots()) {
                    if (ingredient == null || ingredient.isEmpty()) continue;
                    inventory.remove(stack -> ingredient.matches(stack.m_41720_()), ingredient.getTargetCount(), inventory);
                }
                ItemStack result = new ItemStack((ItemLike)target.getOutputItem(), target.getRecipe().outputCount());
                inventory.insertStack(result);
                controller.getItemStorage().registerSlotAction();
            }
        }
        controller.getEntity().m_6674_(InteractionHand.MAIN_HAND);
        return null;
    }

    @Override
    protected void onResourceStop(PlayerEngineController controller, Task interruptTask) {
        controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (other instanceof CraftInTableTask) {
            CraftInTableTask task = (CraftInTableTask)other;
            bl = Arrays.equals(task.targets, this.targets);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Craft on table: " + Arrays.toString(Arrays.stream(this.targets).map(t -> t.getOutputItem().m_41466_().getString()).toArray());
    }

    public RecipeTarget[] getRecipeTargets() {
        return this.targets;
    }
}

