/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.container;

import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.slot.EnsureFreeInventorySlotTask;
import com.player2.playerengine.util.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;

public class LootContainerTask
extends Task {
    private final BlockPos containerPos;
    private final List<Item> targets;
    private final Predicate<ItemStack> check;
    private boolean finished = false;

    public LootContainerTask(BlockPos chestPos, List<Item> items, Predicate<ItemStack> pred) {
        this.containerPos = chestPos;
        this.targets = items;
        this.check = pred;
    }

    public LootContainerTask(BlockPos chestPos, List<Item> items) {
        this(chestPos, items, itemStack -> true);
    }

    @Override
    protected void onStart() {
        this.controller.getBehaviour().push();
        this.controller.getBehaviour().addProtectedItems(this.targets.toArray(new Item[0]));
    }

    @Override
    protected Task onTick() {
        if (this.finished) {
            return null;
        }
        if (!this.containerPos.m_123314_(new Vec3i((int)this.controller.getEntity().m_20182_().f_82479_, (int)this.controller.getEntity().m_20182_().f_82480_, (int)this.controller.getEntity().m_20182_().f_82481_), 4.5)) {
            this.setDebugState("Going to container");
            return new GetToBlockTask(this.containerPos);
        }
        BlockEntity blockEntity = this.controller.getWorld().m_7702_(this.containerPos);
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity container;
            RandomizableContainerBlockEntity containerInventory = container = (RandomizableContainerBlockEntity)blockEntity;
            LivingEntityInventory playerInventory = ((IInventoryProvider)this.controller.getEntity()).getLivingInventory();
            this.controller.getItemStorage().containers.WritableCache(this.controller, this.containerPos);
            boolean somethingToLoot = false;
            this.setDebugState("Looting items: " + String.valueOf(this.targets));
            for (int i = 0; i < containerInventory.m_6643_(); ++i) {
                ItemStack stack = containerInventory.m_8020_(i);
                if (stack.m_41619_() || !this.targets.contains(stack.m_41720_()) || !this.check.test(stack)) continue;
                somethingToLoot = true;
                if (!playerInventory.insertStack(new ItemStack((ItemLike)stack.m_41720_()))) {
                    this.setDebugState("Inventory is full, ensuring space.");
                    return new EnsureFreeInventorySlotTask();
                }
                if (playerInventory.insertStack(stack.m_41777_())) {
                    containerInventory.m_6836_(i, ItemStack.f_41583_);
                    container.m_6596_();
                    this.controller.getItemStorage().registerSlotAction();
                    return null;
                }
                Debug.logWarning("Failed to insert stack even after checking for space.");
            }
            if (!somethingToLoot) {
                this.setDebugState("Container empty or has no desired items.");
                this.finished = true;
            }
            return null;
        }
        Debug.logWarning("Block at " + String.valueOf(this.containerPos) + " is not a lootable container. Stopping.");
        this.finished = true;
        return null;
    }

    @Override
    public boolean isFinished() {
        return this.finished || !this.controller.getChunkTracker().isChunkLoaded(this.containerPos) || !(this.controller.getWorld().m_7702_(this.containerPos) instanceof RandomizableContainerBlockEntity);
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof LootContainerTask)) {
            bl = false;
        } else {
            LootContainerTask task = (LootContainerTask)other;
            bl = Objects.equals(task.containerPos, this.containerPos) && new ArrayList<Item>(task.targets).equals(new ArrayList<Item>(this.targets));
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Looting container at " + this.containerPos.m_123344_();
    }
}

