/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.entity;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.chains.MobDefenseChain;
import com.player2.playerengine.mixins.LivingEntityMixin;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.entity.AbstractDoToEntityTask;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.slots.PlayerSlot;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;

public abstract class AbstractKillEntityTask
extends AbstractDoToEntityTask {
    private static final double OTHER_FORCE_FIELD_RANGE = 2.0;
    private static final double CONSIDER_COMBAT_RANGE = 10.0;

    protected AbstractKillEntityTask() {
        this(10.0, 2.0);
    }

    protected AbstractKillEntityTask(double combatGuardLowerRange, double combatGuardLowerFieldRadius) {
        super(combatGuardLowerRange, combatGuardLowerFieldRadius);
    }

    protected AbstractKillEntityTask(double maintainDistance, double combatGuardLowerRange, double combatGuardLowerFieldRadius) {
        super(maintainDistance, combatGuardLowerRange, combatGuardLowerFieldRadius);
    }

    public static Item bestWeapon(PlayerEngineController mod) {
        TieredItem toolItem1 = null;
        List<ItemStack> invStacks = mod.getItemStorage().getItemStacksPlayerInventory(true);
        TieredItem toolItem2 = MobDefenseChain.getBestWeapon(mod);
        if (toolItem2 != null) {
            return toolItem2;
        }
        Item item = StorageHelper.getItemStackInSlot(PlayerSlot.getEquipSlot(mod.getInventory())).m_41720_();
        float bestDamage = Float.NEGATIVE_INFINITY;
        if (item instanceof TieredItem) {
            TieredItem handToolItem = (TieredItem)item;
            bestDamage = handToolItem.m_43314_().m_6631_();
        }
        for (ItemStack invStack : invStacks) {
            TieredItem toolItem;
            float itemDamage;
            Item item2 = invStack.m_41720_();
            if (!(item2 instanceof TieredItem) || !((itemDamage = (toolItem = (TieredItem)item2).m_43314_().m_6631_()) > bestDamage)) continue;
            toolItem1 = toolItem;
            bestDamage = itemDamage;
        }
        return toolItem1;
    }

    public static boolean equipWeapon(PlayerEngineController mod) {
        Item bestWeapon = AbstractKillEntityTask.bestWeapon(mod);
        Item equipedWeapon = StorageHelper.getItemStackInSlot(PlayerSlot.getEquipSlot(mod.getInventory())).m_41720_();
        if (bestWeapon != null && bestWeapon != equipedWeapon) {
            mod.getSlotHandler().forceEquipItem(bestWeapon);
            return true;
        }
        return false;
    }

    @Override
    protected Task onEntityInteract(PlayerEngineController mod, Entity entity) {
        float hitProg;
        if (!AbstractKillEntityTask.equipWeapon(mod) && (hitProg = this.getAttackCooldownProgress(mod.getPlayer(), 0.0f)) >= 1.0f && (mod.getPlayer().m_20096_() || mod.getPlayer().m_20184_().m_7098_() < 0.0 || mod.getPlayer().m_20069_())) {
            LookHelper.lookAt(mod, entity.m_146892_());
            mod.getControllerExtras().attack(entity);
        }
        return null;
    }

    public float getAttackCooldownProgressPerTick(LivingEntity entity) {
        return 5.0f;
    }

    public float getAttackCooldownProgress(LivingEntity entity, float baseTime) {
        return Mth.m_14036_((float)(((float)((LivingEntityMixin)entity).getLastAttackedTicks() + baseTime) / this.getAttackCooldownProgressPerTick(entity)), (float)0.0f, (float)1.0f);
    }
}

