/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToChunkTask;
import com.player2.playerengine.util.Debug;
import dev.architectury.event.events.common.ChunkEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;

abstract class ChunkSearchTask
extends Task {
    private final BlockPos startPoint;
    private final Object searchMutex = new Object();
    private final Set<ChunkPos> consideredAlready = new HashSet<ChunkPos>();
    private final Set<ChunkPos> searchedAlready = new HashSet<ChunkPos>();
    private final ArrayList<ChunkPos> searchLater = new ArrayList();
    private final ArrayList<ChunkPos> justLoaded = new ArrayList();
    private boolean first = true;
    private boolean finished = false;

    public ChunkSearchTask(BlockPos startPoint) {
        this.startPoint = startPoint;
    }

    public ChunkSearchTask(ChunkPos chunkPos) {
        this(chunkPos.m_45615_().m_7918_(1, 1, 1));
    }

    public Set<ChunkPos> getSearchedChunks() {
        return this.searchedAlready;
    }

    public boolean finished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onStart() {
        if (this.first) {
            this.finished = false;
            this.first = false;
            ChunkPos startPos = this.controller.getWorld().m_46865_(this.startPoint).m_7697_();
            Object object = this.searchMutex;
            synchronized (object) {
                this.searchChunkOrQueueSearch(this.controller, startPos);
            }
        }
        ChunkEvent.LOAD_DATA.register((chunk, level, data) -> {
            if (chunk != null) {
                Object object = this.searchMutex;
                synchronized (object) {
                    if (!this.searchedAlready.contains(chunk.m_7697_())) {
                        this.justLoaded.add(chunk.m_7697_());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Task onTick() {
        Object object = this.searchMutex;
        synchronized (object) {
            if (!this.justLoaded.isEmpty()) {
                for (ChunkPos justLoaded : this.justLoaded) {
                    if (!this.searchLater.contains(justLoaded) || !this.trySearchChunk(this.controller, justLoaded)) continue;
                    this.searchLater.remove(justLoaded);
                }
            }
            this.justLoaded.clear();
        }
        ChunkPos closest = this.getBestChunk(this.controller, this.searchLater);
        if (closest == null) {
            this.finished = true;
            Debug.logWarning("Failed to find any chunks to go to. If we finish, that means we scanned all possible chunks.");
            return null;
        }
        return new GetToChunkTask(closest);
    }

    protected ChunkPos getBestChunk(PlayerEngineController mod, List<ChunkPos> chunks) {
        double lowestScore = Double.POSITIVE_INFINITY;
        ChunkPos bestChunk = null;
        if (!chunks.isEmpty()) {
            for (ChunkPos toSearch : chunks) {
                double distanceToCenterSq;
                double pz;
                double cx = (double)(toSearch.m_45604_() + toSearch.m_45608_() + 1) / 2.0;
                double cz = (double)(toSearch.m_45605_() + toSearch.m_45609_() + 1) / 2.0;
                double px = mod.getPlayer().m_20185_();
                double distanceSq = (cx - px) * (cx - px) + (cz - (pz = mod.getPlayer().m_20189_())) * (cz - pz);
                double score = distanceSq + (distanceToCenterSq = new Vec3((double)this.startPoint.m_123341_() - cx, 0.0, (double)this.startPoint.m_123343_() - cz).m_82556_()) * 0.8;
                if (!(score < lowestScore)) continue;
                lowestScore = score;
                bestChunk = toSearch;
            }
        }
        return bestChunk;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    public boolean isFinished() {
        return this.searchLater.size() == 0;
    }

    @Override
    protected boolean isEqual(Task other) {
        if (other instanceof ChunkSearchTask) {
            ChunkSearchTask task = (ChunkSearchTask)other;
            return !task.startPoint.equals((Object)this.startPoint) ? false : this.isChunkSearchEqual(task);
        }
        return false;
    }

    private void searchChunkOrQueueSearch(PlayerEngineController mod, ChunkPos pos) {
        if (!this.consideredAlready.contains(pos)) {
            this.consideredAlready.add(pos);
            if (!this.trySearchChunk(mod, pos) && !this.searchedAlready.contains(pos)) {
                this.searchLater.add(pos);
            }
        }
    }

    private boolean trySearchChunk(PlayerEngineController mod, ChunkPos pos) {
        if (this.searchedAlready.contains(pos)) {
            return true;
        }
        if (mod.getChunkTracker().isChunkLoaded(pos)) {
            this.searchedAlready.add(pos);
            if (this.isChunkPartOfSearchSpace(mod, pos)) {
                this.searchChunkOrQueueSearch(mod, new ChunkPos(pos.f_45578_ + 1, pos.f_45579_));
                this.searchChunkOrQueueSearch(mod, new ChunkPos(pos.f_45578_ - 1, pos.f_45579_));
                this.searchChunkOrQueueSearch(mod, new ChunkPos(pos.f_45578_, pos.f_45579_ + 1));
                this.searchChunkOrQueueSearch(mod, new ChunkPos(pos.f_45578_, pos.f_45579_ - 1));
            }
            return true;
        }
        return false;
    }

    protected abstract boolean isChunkPartOfSearchSpace(PlayerEngineController var1, ChunkPos var2);

    protected abstract boolean isChunkSearchEqual(ChunkSearchTask var1);
}

