/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.multiversion.FoodComponentWrapper;
import com.player2.playerengine.multiversion.item.ItemVer;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.CustomBaritoneGoalTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EscapeFromLavaTask
extends CustomBaritoneGoalTask {
    private final float strength;
    private int ticks = 0;
    private final Predicate<BlockPos> avoidPlacingRiskyBlock;

    public EscapeFromLavaTask(PlayerEngineController mod, float strength) {
        this.strength = strength;
        this.avoidPlacingRiskyBlock = blockPos -> mod.getPlayer().m_20191_().m_82381_(new AABB(blockPos)) && (mod.getWorld().m_8055_(mod.getPlayer().m_20183_().m_7495_()).m_60734_() == Blocks.f_49991_ || mod.getPlayer().m_20077_());
    }

    public EscapeFromLavaTask(PlayerEngineController mod) {
        this(mod, 100.0f);
    }

    @Override
    protected void onStart() {
        PlayerEngineController mod = this.controller;
        mod.getBehaviour().push();
        mod.getBaritone().getExploreProcess().onLostControl();
        mod.getBaritone().getCustomGoalProcess().onLostControl();
        mod.getBehaviour().allowSwimThroughLava(true);
        mod.getBehaviour().setBlockPlacePenalty(0.0);
        mod.getBehaviour().setBlockBreakAdditionalPenalty(0.0);
        this.checker = new MovementProgressChecker(Integer.MAX_VALUE);
        mod.getExtraBaritoneSettings().avoidBlockPlace(this.avoidPlacingRiskyBlock);
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        mod.getInputControls().hold(Input.JUMP);
        mod.getInputControls().hold(Input.SPRINT);
        Optional<Item> food = this.calculateFood(mod);
        if (food.isPresent() && mod.getBaritone().getEntityContext().hungerManager().getFoodLevel() < 20) {
            if (mod.getPlayer().m_21254_()) {
                mod.log("want to eat, trying to stop shielding...");
                mod.getInputControls().release(Input.CLICK_RIGHT);
            } else {
                mod.getSlotHandler().forceEquipItem(new ItemTarget(food.get()), true);
                mod.getInputControls().hold(Input.CLICK_RIGHT);
            }
        }
        if (mod.getPlayer().m_20077_() || mod.getWorld().m_8055_(mod.getPlayer().m_20183_().m_7495_()).m_60734_() == Blocks.f_49991_) {
            this.setDebugState("run away from lava");
            BlockPos steppingPos = mod.getPlayer().m_20097_();
            if (!(mod.getWorld().m_8055_(steppingPos.m_122029_()).m_60734_().equals(Blocks.f_49991_) && mod.getWorld().m_8055_(steppingPos.m_122024_()).m_60734_().equals(Blocks.f_49991_) && mod.getWorld().m_8055_(steppingPos.m_122019_()).m_60734_().equals(Blocks.f_49991_) && mod.getWorld().m_8055_(steppingPos.m_122012_()).m_60734_().equals(Blocks.f_49991_) && mod.getWorld().m_8055_(steppingPos.m_122029_().m_122012_()).m_60734_().equals(Blocks.f_49991_) && mod.getWorld().m_8055_(steppingPos.m_122029_().m_122019_()).m_60734_().equals(Blocks.f_49991_) && mod.getWorld().m_8055_(steppingPos.m_122024_().m_122012_()).m_60734_().equals(Blocks.f_49991_) && mod.getWorld().m_8055_(steppingPos.m_122024_().m_122019_()).m_60734_().equals(Blocks.f_49991_))) {
                return super.onTick();
            }
            if (mod.getPlayer().m_21254_()) {
                mod.log("want to place block, trying to stop shielding...");
                mod.getInputControls().release(Input.CLICK_RIGHT);
            }
            for (float pitch = 25.0f; pitch < 90.0f; pitch += 1.0f) {
                for (float yaw = -180.0f; yaw < 180.0f; yaw += 1.0f) {
                    Direction facing;
                    BlockHitResult blockHitResult;
                    BlockPos pos;
                    HitResult result = this.raycast(mod, 4.0, pitch, yaw);
                    if (result.m_6662_() != HitResult.Type.BLOCK || (pos = (blockHitResult = (BlockHitResult)result).m_82425_()).m_123342_() > mod.getPlayer().m_20097_().m_123342_() || (facing = blockHitResult.m_82434_()) == Direction.UP) continue;
                    LookHelper.lookAt(this.controller, new Rotation(yaw, pitch));
                    if (mod.getItemStorage().hasItem(Items.f_42048_)) {
                        mod.getSlotHandler().forceEquipItem(Items.f_42048_);
                    } else {
                        mod.getSlotHandler().forceEquipItem(mod.getBaritoneSettings().acceptableThrowawayItems.get().toArray(new Item[0]));
                    }
                    mod.log(String.valueOf(pos));
                    mod.log(String.valueOf(facing));
                    mod.getInputControls().tryPress(Input.CLICK_RIGHT);
                    return null;
                }
            }
        }
        return super.onTick();
    }

    private Optional<Item> calculateFood(PlayerEngineController mod) {
        Item bestFood = null;
        double bestFoodScore = Double.NEGATIVE_INFINITY;
        LivingEntity player = mod.getPlayer();
        float hunger = player != null ? (float)mod.getBaritone().getEntityContext().hungerManager().getFoodLevel() : 20.0f;
        float saturation = player != null ? mod.getBaritone().getEntityContext().hungerManager().getSaturationLevel() : 20.0f;
        for (ItemStack stack : mod.getItemStorage().getItemStacksPlayerInventory(true)) {
            float score;
            if (!ItemVer.isFood(stack) || stack.m_41720_() == Items.f_42591_ || !((double)(score = EscapeFromLavaTask.getScore(stack, hunger, saturation)) > bestFoodScore)) continue;
            bestFoodScore = score;
            bestFood = stack.m_41720_();
        }
        return Optional.ofNullable(bestFood);
    }

    private static float getScore(ItemStack stack, float hunger, float saturation) {
        FoodComponentWrapper food = ItemVer.getFoodComponent(stack.m_41720_());
        assert (food != null);
        float hungerIfEaten = Math.min(hunger + (float)food.getHunger(), 20.0f);
        float saturationIfEaten = Math.min(hungerIfEaten, saturation + food.getSaturationModifier());
        float gainedSaturation = saturationIfEaten - saturation;
        float hungerNotFilled = 20.0f - hungerIfEaten;
        float saturationGoodScore = gainedSaturation * 10.0f;
        float hungerNotFilledPenalty = hungerNotFilled * 2.0f;
        float score = saturationGoodScore - hungerNotFilledPenalty;
        if (stack.m_41720_() == Items.f_42583_) {
            score = 0.0f;
        }
        return score;
    }

    public HitResult raycast(PlayerEngineController mod, double maxDistance, float pitch, float yaw) {
        Vec3 cameraPos = mod.getPlayer().m_20299_(0.0f);
        Vec3 rotationVector = this.getRotationVector(pitch, yaw);
        Vec3 vec3d3 = cameraPos.m_82520_(rotationVector.f_82479_ * maxDistance, rotationVector.f_82480_ * maxDistance, rotationVector.f_82481_ * maxDistance);
        return mod.getPlayer().m_9236_().m_45547_(new ClipContext(cameraPos, vec3d3, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)mod.getPlayer()));
    }

    protected final Vec3 getRotationVector(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = Mth.m_14089_((float)g);
        float i = Mth.m_14031_((float)g);
        float j = Mth.m_14089_((float)f);
        float k = Mth.m_14031_((float)f);
        return new Vec3((double)(i * j), (double)(-k), (double)(h * j));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onStop(Task interruptTask) {
        PlayerEngineController mod = this.controller;
        mod.getBehaviour().pop();
        mod.getInputControls().release(Input.JUMP);
        mod.getInputControls().release(Input.SPRINT);
        mod.getInputControls().release(Input.CLICK_RIGHT);
        Object object = mod.getExtraBaritoneSettings().getPlaceMutex();
        synchronized (object) {
            mod.getExtraBaritoneSettings().getPlaceAvoiders().remove(this.avoidPlacingRiskyBlock);
        }
    }

    @Override
    protected Goal newGoal(PlayerEngineController mod) {
        return new EscapeFromLavaGoal();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof EscapeFromLavaTask;
    }

    @Override
    public boolean isFinished() {
        LivingEntity player = this.controller.getPlayer();
        return !player.m_20077_() && !player.m_6060_();
    }

    @Override
    protected String toDebugString() {
        return "Escaping lava";
    }

    private class EscapeFromLavaGoal
    implements Goal {
        private EscapeFromLavaGoal() {
        }

        private boolean isLava(int x, int y, int z) {
            return EscapeFromLavaTask.this.controller.getWorld() == null ? false : MovementHelper.isLava(EscapeFromLavaTask.this.controller.getWorld().m_8055_(new BlockPos(x, y, z)));
        }

        private boolean isLavaAdjacent(int x, int y, int z) {
            return this.isLava(x + 1, y, z) || this.isLava(x - 1, y, z) || this.isLava(x, y, z + 1) || this.isLava(x, y, z - 1) || this.isLava(x + 1, y, z - 1) || this.isLava(x + 1, y, z + 1) || this.isLava(x - 1, y, z - 1) || this.isLava(x - 1, y, z + 1);
        }

        private boolean isWater(int x, int y, int z) {
            return EscapeFromLavaTask.this.controller.getWorld() == null ? false : MovementHelper.isWater(EscapeFromLavaTask.this.controller.getWorld().m_8055_(new BlockPos(x, y, z)));
        }

        @Override
        public boolean isInGoal(int x, int y, int z) {
            return !this.isLava(x, y, z) && !this.isLavaAdjacent(x, y, z);
        }

        @Override
        public double heuristic(int x, int y, int z) {
            if (this.isLava(x, y, z)) {
                return EscapeFromLavaTask.this.strength;
            }
            if (this.isLavaAdjacent(x, y, z)) {
                return EscapeFromLavaTask.this.strength * 0.5f;
            }
            return this.isWater(x, y, z) ? -100.0 : 0.0;
        }
    }
}

