/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetWithinRangeOfBlockTask;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class GetCloseToBlockTask
extends Task {
    private final BlockPos toApproach;
    private int currentRange;

    public GetCloseToBlockTask(BlockPos toApproach) {
        this.toApproach = toApproach;
    }

    @Override
    protected void onStart() {
        this.currentRange = Integer.MAX_VALUE;
    }

    @Override
    protected Task onTick() {
        if (this.inRange()) {
            this.currentRange = this.getCurrentDistance() - 1;
        }
        return new GetWithinRangeOfBlockTask(this.toApproach, this.currentRange);
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    private int getCurrentDistance() {
        return (int)Math.sqrt(this.controller.getPlayer().m_20183_().m_123331_((Vec3i)this.toApproach));
    }

    private boolean inRange() {
        return this.controller.getPlayer().m_20183_().m_123331_((Vec3i)this.toApproach) <= (double)(this.currentRange * this.currentRange);
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof GetCloseToBlockTask) {
            GetCloseToBlockTask task = (GetCloseToBlockTask)other;
            bl = task.toApproach.equals((Object)this.toApproach);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Approaching " + this.toApproach.m_123344_();
    }
}

