/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.control.InputControls;
import com.player2.playerengine.multiversion.DamageSourceVer;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.ConfigHelper;
import com.player2.playerengine.util.helpers.EntityHelper;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.MathsHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class MLGBucketTask
extends Task {
    private static MLGClutchConfig config;
    private BlockPos placedPos;
    private BlockPos movingTorwards;

    private static boolean isLava(PlayerEngineController controller, BlockPos pos) {
        assert (controller.getWorld() != null);
        return controller.getWorld().m_8055_(pos).m_60734_() == Blocks.f_49991_;
    }

    private static boolean lavaWillProtect(PlayerEngineController controller, BlockPos pos) {
        assert (controller.getWorld() != null);
        BlockState state = controller.getWorld().m_8055_(pos);
        if (state.m_60734_() != Blocks.f_49991_) {
            return false;
        }
        int level = state.m_60819_().m_76186_();
        return level == 0 || level >= MLGBucketTask.config.lavaLevelOrGreaterWillCancelFallDamage;
    }

    private static boolean isWater(PlayerEngineController controller, BlockPos pos) {
        assert (controller.getWorld() != null);
        return controller.getWorld().m_8055_(pos).m_60734_() == Blocks.f_49990_;
    }

    private static boolean canTravelToInAir(PlayerEngineController controller, BlockPos pos) {
        LivingEntity clientPlayerEntity = controller.getPlayer();
        assert (clientPlayerEntity != null);
        double verticalDist = clientPlayerEntity.m_20182_().m_7098_() - (double)pos.m_123342_() - 1.0;
        double verticalVelocity = -1.0 * clientPlayerEntity.m_20184_().f_82480_;
        double grav = 0.08;
        double movementSpeedPerTick = MLGBucketTask.config.averageHorizontalMovementSpeedPerTick;
        double ticksToTravelSq = (-verticalVelocity + Math.sqrt(verticalVelocity * verticalVelocity + 2.0 * grav * verticalDist)) / grav;
        double maxMoveDistanceSq = movementSpeedPerTick * movementSpeedPerTick * ticksToTravelSq * ticksToTravelSq;
        double horizontalDistance = WorldHelper.distanceXZ(clientPlayerEntity.m_20182_(), WorldHelper.toVec3d(pos)) - 0.8;
        if (horizontalDistance < 0.0) {
            horizontalDistance = 0.0;
        }
        return maxMoveDistanceSq > horizontalDistance * horizontalDistance;
    }

    private static boolean isFallDeadly(PlayerEngineController controller, BlockPos pos) {
        LivingEntity clientPlayerEntity = controller.getPlayer();
        double damage = MLGBucketTask.calculateFallDamageToLandOn(controller, pos);
        assert (controller.getWorld() != null);
        Block b = controller.getWorld().m_8055_(pos).m_60734_();
        if (b == Blocks.f_50335_) {
            damage *= (double)0.2f;
        }
        assert (clientPlayerEntity != null);
        double resultingHealth = clientPlayerEntity.m_21223_() - (float)damage;
        return resultingHealth < (double)MLGBucketTask.config.preferLavaWhenFallDropsHealthBelowThreshold;
    }

    private static double calculateFallDamageToLandOn(PlayerEngineController controller, BlockPos pos) {
        ServerLevel world = controller.getWorld();
        LivingEntity clientPlayerEntity = controller.getPlayer();
        assert (clientPlayerEntity != null);
        double totalFallDistance = (double)clientPlayerEntity.f_19789_ + clientPlayerEntity.m_20186_() - (double)pos.m_123342_() - 1.0;
        double baseFallDamage = Mth.m_14165_((double)(totalFallDistance - 3.0));
        assert (world != null);
        return EntityHelper.calculateResultingPlayerDamage(clientPlayerEntity, DamageSourceVer.getFallDamageSource((Level)world), baseFallDamage);
    }

    private static void moveLeftRight(PlayerEngineController controller, int delta) {
        InputControls controls = controller.getInputControls();
        if (delta == 0) {
            controls.release(Input.MOVE_LEFT);
            controls.release(Input.MOVE_RIGHT);
        } else if (delta > 0) {
            controls.release(Input.MOVE_LEFT);
            controls.hold(Input.MOVE_RIGHT);
        } else {
            controls.hold(Input.MOVE_LEFT);
            controls.release(Input.MOVE_RIGHT);
        }
    }

    private static void moveForwardBack(PlayerEngineController controller, int delta) {
        InputControls controls = controller.getInputControls();
        if (delta == 0) {
            controls.release(Input.MOVE_FORWARD);
            controls.release(Input.MOVE_BACK);
        } else if (delta > 0) {
            controls.hold(Input.MOVE_FORWARD);
            controls.release(Input.MOVE_BACK);
        } else {
            controls.release(Input.MOVE_FORWARD);
            controls.hold(Input.MOVE_BACK);
        }
    }

    private Task onTickInternal(PlayerEngineController mod, BlockPos oldMovingTorwards) {
        Optional<BlockPos> willLandOn = this.getBlockWeWillLandOn(mod);
        Optional<BlockPos> bestClutchPos = this.getBestConeClutchBlock(mod, oldMovingTorwards);
        if (bestClutchPos.isPresent()) {
            this.movingTorwards = bestClutchPos.get().m_122032_();
            if (!this.movingTorwards.equals((Object)oldMovingTorwards)) {
                if (oldMovingTorwards == null) {
                    Debug.logMessage("(NEW clutch target: " + String.valueOf(this.movingTorwards) + ")");
                } else {
                    Debug.logMessage("(changed clutch target: " + String.valueOf(this.movingTorwards) + ")");
                }
            }
        } else if (oldMovingTorwards != null) {
            Debug.logMessage("(LOST clutch position!)");
        }
        if (willLandOn.isPresent()) {
            this.handleJumpForLand(mod, willLandOn.get());
            return this.placeMLGBucketTask(mod, willLandOn.get());
        }
        this.setDebugState("Wait for it...");
        mod.getInputControls().release(Input.JUMP);
        return null;
    }

    private Task placeMLGBucketTask(PlayerEngineController mod, BlockPos toPlaceOn) {
        if (!this.hasClutchItem(mod)) {
            this.setDebugState("No clutch item");
            return null;
        }
        if (!WorldHelper.isSolidBlock(this.controller, toPlaceOn)) {
            toPlaceOn = toPlaceOn.m_7495_();
        }
        BlockPos willLandIn = toPlaceOn.m_7494_();
        BlockState willLandInState = mod.getWorld().m_8055_(willLandIn);
        if (willLandInState.m_60734_() == Blocks.f_49990_) {
            this.setDebugState("Waiting to fall into water");
            mod.getBaritone().getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, false);
            return null;
        }
        IEntityContext ctx = mod.getBaritone().getEntityContext();
        Optional<Rotation> reachable = RotationUtils.reachableCenter((Entity)ctx.entity(), toPlaceOn, ctx.playerController().getBlockReachDistance(), false);
        if (reachable.isPresent()) {
            boolean hasClutch;
            this.setDebugState("Performing MLG");
            LookHelper.lookAt(this.controller, reachable.get());
            boolean bl = hasClutch = !mod.getWorld().m_6042_().f_63857_() && mod.getSlotHandler().forceEquipItem(Items.f_42447_);
            if (!hasClutch && !MLGBucketTask.config.clutchItems.isEmpty()) {
                for (Item tryEquip : MLGBucketTask.config.clutchItems) {
                    if (!mod.getSlotHandler().forceEquipItem(tryEquip)) continue;
                    hasClutch = true;
                    break;
                }
            }
            BlockPos[] toCheckLook = new BlockPos[]{toPlaceOn, toPlaceOn.m_7494_(), toPlaceOn.m_6630_(2)};
            if (hasClutch && Arrays.stream(toCheckLook).anyMatch(check -> mod.getBaritone().getEntityContext().isLookingAt((BlockPos)check))) {
                Debug.logMessage("HIT: " + String.valueOf(willLandIn));
                this.placedPos = willLandIn;
                mod.getInputControls().tryPress(Input.CLICK_RIGHT);
            } else {
                this.setDebugState("NOT LOOKING CORRECTLY!");
            }
        } else {
            this.setDebugState("Waiting to reach target block...");
        }
        return null;
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        mod.getInputControls().hold(Input.SPRINT);
        BlockPos.MutableBlockPos mutable = this.movingTorwards != null ? this.movingTorwards.m_122032_() : null;
        this.movingTorwards = null;
        Task result = this.onTickInternal(mod, (BlockPos)mutable);
        this.handleForwardVelocity(mod, !Objects.equals(mutable, this.movingTorwards));
        this.handleCancellingSidewaysVelocity(mod);
        return result;
    }

    private void handleForwardVelocity(PlayerEngineController mod, boolean newForwardTarget) {
        if (!mod.getPlayer().m_20096_() && this.movingTorwards != null && !WorldHelper.inRangeXZ((Entity)mod.getPlayer(), this.movingTorwards, (double)0.05f)) {
            Rotation look = LookHelper.getLookRotation(this.controller);
            look = new Rotation(look.getYaw(), 0.0f);
            Vec3 forwardFacing = LookHelper.toVec3d(look).m_82542_(1.0, 0.0, 1.0).m_82541_();
            Vec3 delta = WorldHelper.toVec3d(this.movingTorwards).m_82546_(mod.getPlayer().m_20182_()).m_82542_(1.0, 0.0, 1.0);
            Vec3 velocity = mod.getPlayer().m_20184_().m_82542_(1.0, 0.0, 1.0);
            Vec3 pd = delta.m_82546_(velocity.m_82490_(3.0));
            double forwardStrength = pd.m_82526_(forwardFacing);
            if (newForwardTarget) {
                LookHelper.lookAt(mod, this.movingTorwards);
            }
            Debug.logInternal("F:" + forwardStrength);
            MLGBucketTask.moveForwardBack(mod, (int)Math.signum(forwardStrength));
        } else {
            MLGBucketTask.moveForwardBack(mod, 0);
        }
    }

    @Override
    protected void onStart() {
        this.controller.getBaritone().getPathingBehavior().forceCancel();
        this.placedPos = null;
        this.controller.getPlayer().m_146926_(90.0f);
    }

    private void handleJumpForLand(PlayerEngineController mod, BlockPos willLandOn) {
        BlockPos willLandIn = WorldHelper.isSolidBlock(this.controller, willLandOn) ? willLandOn.m_7494_() : willLandOn;
        BlockState s = mod.getWorld().m_8055_(willLandIn);
        if (s.m_60734_() == Blocks.f_49991_) {
            mod.getInputControls().hold(Input.JUMP);
        } else {
            AABB blockBounds;
            try {
                blockBounds = s.m_60812_((BlockGetter)mod.getWorld(), willLandIn).m_83215_();
            }
            catch (UnsupportedOperationException var7) {
                blockBounds = AABB.m_165882_((Vec3)WorldHelper.toVec3d(willLandIn), (double)1.0, (double)1.0, (double)1.0);
            }
            boolean inside = mod.getPlayer().m_20191_().m_82381_(blockBounds);
            if (inside) {
                mod.getInputControls().hold(Input.JUMP);
            } else {
                mod.getInputControls().release(Input.JUMP);
            }
        }
    }

    private Optional<BlockPos> getBlockWeWillLandOn(PlayerEngineController mod) {
        Vec3 velCheck = mod.getPlayer().m_20184_();
        velCheck.m_82542_(10.0, 0.0, 10.0);
        AABB b = mod.getPlayer().m_20191_().m_82383_(velCheck);
        Vec3 c = b.m_82399_();
        Vec3[] coords = new Vec3[]{c, new Vec3(b.f_82288_, c.f_82480_, b.f_82290_), new Vec3(b.f_82291_, c.f_82480_, b.f_82290_), new Vec3(b.f_82288_, c.f_82480_, b.f_82293_), new Vec3(b.f_82291_, c.f_82480_, b.f_82293_)};
        BlockHitResult result = null;
        double bestSqDist = Double.POSITIVE_INFINITY;
        for (Vec3 rayOrigin : coords) {
            double curDis;
            ClipContext rctx = this.castDown(rayOrigin);
            BlockHitResult hit = mod.getWorld().m_45547_(rctx);
            if (hit.m_6662_() != HitResult.Type.BLOCK || !((curDis = hit.m_82450_().m_82557_(rayOrigin)) < bestSqDist)) continue;
            result = hit;
            bestSqDist = curDis;
        }
        return result != null && result.m_6662_() == HitResult.Type.BLOCK ? Optional.ofNullable(result.m_82425_()) : Optional.empty();
    }

    private void handleCancellingSidewaysVelocity(PlayerEngineController mod) {
        if (this.movingTorwards == null) {
            MLGBucketTask.moveLeftRight(mod, 0);
        } else {
            Vec3 faceRight;
            boolean moveRight;
            Vec3 velocity = mod.getPlayer().m_20184_();
            Vec3 deltaTarget = WorldHelper.toVec3d(this.movingTorwards).m_82546_(mod.getPlayer().m_20182_());
            Rotation look = LookHelper.getLookRotation(this.controller);
            Vec3 forwardFacing = LookHelper.toVec3d(look).m_82542_(1.0, 0.0, 1.0).m_82541_();
            Vec3 rightVelocity = MathsHelper.projectOntoPlane(velocity, forwardFacing).m_82542_(1.0, 0.0, 1.0);
            Vec3 rightDelta = MathsHelper.projectOntoPlane(deltaTarget, forwardFacing).m_82542_(1.0, 0.0, 1.0);
            Vec3 pd = rightDelta.m_82546_(rightVelocity.m_82490_(2.0));
            boolean bl = moveRight = pd.m_82526_(faceRight = forwardFacing.m_82537_(new Vec3(0.0, 1.0, 0.0))) > 0.0;
            if (moveRight) {
                MLGBucketTask.moveLeftRight(mod, 1);
            } else {
                MLGBucketTask.moveLeftRight(mod, -1);
            }
        }
    }

    private Optional<BlockPos> getBestConeClutchBlock(PlayerEngineController mod, BlockPos oldClutchTarget) {
        double pitchHalfWidth = MLGBucketTask.config.epicClutchConePitchAngle;
        double dpitchStart = pitchHalfWidth / (double)MLGBucketTask.config.epicClutchConePitchResolution;
        ConeClutchContext cctx = new ConeClutchContext(mod);
        if (oldClutchTarget != null) {
            cctx.checkBlock(mod, oldClutchTarget);
        }
        for (double pitch = dpitchStart; pitch <= pitchHalfWidth; pitch += pitchHalfWidth / (double)MLGBucketTask.config.epicClutchConePitchResolution) {
            double pitchProgress = (pitch - dpitchStart) / (pitchHalfWidth - dpitchStart);
            double yawResolution = (double)MLGBucketTask.config.epicClutchConeYawDivisionStart + pitchProgress * (double)(MLGBucketTask.config.epicClutchConeYawDivisionEnd - MLGBucketTask.config.epicClutchConeYawDivisionStart);
            for (double yaw = 0.0; yaw < 360.0; yaw += 360.0 / yawResolution) {
                ClipContext rctx = this.castCone(yaw, pitch);
                cctx.checkRay(mod, rctx);
            }
        }
        Vec3 center = mod.getPlayer().m_20182_();
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                ClipContext ctx = this.castDown(center.m_82520_((double)dx, 0.0, (double)dz));
                cctx.checkRay(mod, ctx);
            }
        }
        return Optional.ofNullable(cctx.bestBlock);
    }

    private ClipContext castDown(Vec3 origin) {
        LivingEntity clientPlayerEntity = this.controller.getPlayer();
        assert (clientPlayerEntity != null);
        return new ClipContext(origin, origin.m_82520_(0.0, -1.0 * MLGBucketTask.config.castDownDistance, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)clientPlayerEntity);
    }

    private ClipContext castCone(double yaw, double pitch) {
        LivingEntity clientPlayerEntity = this.controller.getPlayer();
        assert (clientPlayerEntity != null);
        Vec3 origin = clientPlayerEntity.m_20182_();
        double dy = MLGBucketTask.config.epicClutchConeCastHeight;
        double dH = dy * Math.sin(Math.toRadians(pitch));
        double yawRad = Math.toRadians(yaw);
        double dx = dH * Math.cos(yawRad);
        double dz = dH * Math.sin(yawRad);
        Vec3 end = origin.m_82520_(dx, -1.0 * dy, dz);
        return new ClipContext(origin, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)clientPlayerEntity);
    }

    @Override
    protected void onStop(Task interruptTask) {
        IBaritone baritone = this.controller.getBaritone();
        InputControls controls = this.controller.getInputControls();
        baritone.getPathingBehavior().forceCancel();
        this.movingTorwards = null;
        baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, false);
        MLGBucketTask.moveLeftRight(this.controller, 0);
        MLGBucketTask.moveForwardBack(this.controller, 0);
        controls.release(Input.SPRINT);
        controls.release(Input.JUMP);
    }

    private boolean hasClutchItem(PlayerEngineController mod) {
        return !mod.getWorld().m_6042_().f_63857_() && mod.getItemStorage().hasItem(Items.f_42447_) ? true : MLGBucketTask.config.clutchItems.stream().anyMatch(item -> mod.getItemStorage().hasItem((Item)item));
    }

    @Override
    public boolean isFinished() {
        LivingEntity player = this.controller.getPlayer();
        return player.m_6069_() || player.m_20069_() || player.m_20096_() || player.m_6147_();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof MLGBucketTask;
    }

    @Override
    protected String toDebugString() {
        Object result = "Epic gaemer moment";
        if (this.movingTorwards != null) {
            result = (String)result + " (CLUTCH AT: " + (String)result + ")";
        }
        return result;
    }

    public BlockPos getWaterPlacedPos() {
        return this.placedPos;
    }

    static {
        ConfigHelper.loadConfig("configs/mlg_clutch_settings.json", MLGClutchConfig::new, MLGClutchConfig.class, newConfig -> {
            config = newConfig;
        });
    }

    private static class MLGClutchConfig {
        public double castDownDistance = 40.0;
        public double averageHorizontalMovementSpeedPerTick = 0.25;
        public double epicClutchConeCastHeight = 40.0;
        public double epicClutchConePitchAngle = 25.0;
        public int epicClutchConePitchResolution = 8;
        public int epicClutchConeYawDivisionStart = 6;
        public int epicClutchConeYawDivisionEnd = 20;
        public int preferLavaWhenFallDropsHealthBelowThreshold = 3;
        public int lavaLevelOrGreaterWillCancelFallDamage = 5;
        public List<Item> clutchItems = List.of(Items.f_42129_, Items.f_41908_);

        private MLGClutchConfig() {
        }
    }

    class ConeClutchContext {
        private final boolean hasClutchItem;
        public BlockPos bestBlock = null;
        private double highestY = Double.NEGATIVE_INFINITY;
        private double closestXZ = Double.POSITIVE_INFINITY;
        private boolean bestBlockIsSafe = false;
        private boolean bestBlockIsDeadlyFall = false;
        private boolean bestBlockIsLava = false;

        public ConeClutchContext(PlayerEngineController mod) {
            this.hasClutchItem = MLGBucketTask.this.hasClutchItem(mod);
        }

        public void checkBlock(PlayerEngineController mod, BlockPos check) {
            if (!Objects.equals(this.bestBlock, check)) {
                if (WorldHelper.isAir(mod.getWorld().m_8055_(check).m_60734_())) {
                    Debug.logMessage("(MLG Air block checked for landing, the block broke. We'll try another): " + String.valueOf(check));
                } else {
                    boolean isDeadlyFall;
                    boolean lava = MLGBucketTask.isLava(MLGBucketTask.this.controller, check);
                    boolean lavaWillProtect = lava && MLGBucketTask.lavaWillProtect(MLGBucketTask.this.controller, check);
                    boolean water = MLGBucketTask.isWater(MLGBucketTask.this.controller, check);
                    boolean bl = isDeadlyFall = !this.hasClutchItem && MLGBucketTask.isFallDeadly(MLGBucketTask.this.controller, check);
                    if (!this.bestBlockIsSafe || water) {
                        boolean closestSoFar;
                        double height = check.m_123342_();
                        double distSqXZ = WorldHelper.distanceXZSquared(WorldHelper.toVec3d(check), mod.getPlayer().m_20182_());
                        boolean highestSoFar = height > this.highestY;
                        boolean bl2 = closestSoFar = distSqXZ < this.closestXZ;
                        if ((this.bestBlock == null || water && !this.bestBlockIsSafe || lava && lavaWillProtect && this.bestBlockIsDeadlyFall && !this.hasClutchItem || !lava && !isDeadlyFall && (closestSoFar && this.hasClutchItem && highestSoFar || this.bestBlockIsLava)) && MLGBucketTask.canTravelToInAir(MLGBucketTask.this.controller, !lava && !water ? check : check.m_7495_())) {
                            if (highestSoFar) {
                                this.highestY = height;
                            }
                            if (closestSoFar) {
                                this.closestXZ = distSqXZ;
                            }
                            this.bestBlockIsSafe = water;
                            this.bestBlockIsDeadlyFall = isDeadlyFall;
                            this.bestBlockIsLava = lava;
                            this.bestBlock = check;
                        }
                    }
                }
            }
        }

        public void checkRay(PlayerEngineController mod, ClipContext rctx) {
            BlockHitResult hit = mod.getWorld().m_45547_(rctx);
            if (hit.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos check = hit.m_82425_();
                if (hit.m_82434_().m_122430_() <= 0) {
                    return;
                }
                this.checkBlock(mod, check);
            }
        }
    }
}

