/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.container.SmeltInFurnaceTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.SmeltTarget;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class CollectIronIngotTask
extends ResourceTask {
    private final int count;

    public CollectIronIngotTask(int count) {
        super(Items.f_42416_, count);
        this.count = count;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
        mod.getBehaviour().push();
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        return new SmeltInFurnaceTask(new SmeltTarget(new ItemTarget(Items.f_42416_, this.count), new ItemTarget(Items.f_151050_, this.count), new Item[0]));
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
        mod.getBehaviour().pop();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isEqualResource(ResourceTask other) {
        if (!(other instanceof CollectIronIngotTask)) return false;
        CollectIronIngotTask same = (CollectIronIngotTask)other;
        if (same.count != this.count) return false;
        return true;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " iron.";
    }
}

