/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.trackers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.recipemanager.RecipeManagerWrapper;
import com.player2.playerengine.multiversion.recipemanager.WrappedRecipeEntry;
import com.player2.playerengine.trackers.Tracker;
import com.player2.playerengine.trackers.TrackerManager;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.RecipeTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class CraftingRecipeTracker
extends Tracker {
    private final HashMap<Item, List<CraftingRecipe>> itemRecipeMap = new HashMap();
    private final HashMap<CraftingRecipe, ItemStack> recipeResultMap = new HashMap();
    private boolean shouldRebuild = true;

    public CraftingRecipeTracker(TrackerManager manager) {
        super(manager);
    }

    public List<CraftingRecipe> getRecipeForItem(Item item) {
        this.ensureUpdated();
        if (!this.hasRecipeForItem(item)) {
            this.mod.logWarning("trying to access recipe for unknown item: " + String.valueOf(item));
            return null;
        }
        return this.itemRecipeMap.get(item);
    }

    public CraftingRecipe getFirstRecipeForItem(Item item) {
        this.ensureUpdated();
        if (!this.hasRecipeForItem(item)) {
            this.mod.logWarning("trying to access recipe for unknown item: " + String.valueOf(item));
            return null;
        }
        return this.itemRecipeMap.get(item).get(0);
    }

    public List<RecipeTarget> getRecipeTarget(Item item, int targetCount) {
        this.ensureUpdated();
        ArrayList<RecipeTarget> targets = new ArrayList<RecipeTarget>();
        for (CraftingRecipe recipe : this.getRecipeForItem(item)) {
            targets.add(new RecipeTarget(item, targetCount, recipe));
        }
        return targets;
    }

    public RecipeTarget getFirstRecipeTarget(Item item, int targetCount) {
        this.ensureUpdated();
        return new RecipeTarget(item, targetCount, this.getFirstRecipeForItem(item));
    }

    public boolean hasRecipeForItem(Item item) {
        this.ensureUpdated();
        return this.itemRecipeMap.containsKey(item);
    }

    public ItemStack getRecipeResult(CraftingRecipe recipe) {
        this.ensureUpdated();
        if (!this.hasRecipe(recipe)) {
            this.mod.logWarning("Trying to get result for unknown recipe: " + String.valueOf(recipe));
            return null;
        }
        ItemStack result = this.recipeResultMap.get(recipe);
        return new ItemStack((ItemLike)result.m_41720_(), result.m_41613_());
    }

    public boolean hasRecipe(CraftingRecipe recipe) {
        this.ensureUpdated();
        return this.recipeResultMap.containsKey(recipe);
    }

    @Override
    protected void updateState() {
        if (this.shouldRebuild && PlayerEngineController.inGame()) {
            RecipeManagerWrapper recipeManager = RecipeManagerWrapper.of(this.mod.getWorld().m_7465_());
            for (WrappedRecipeEntry recipe : recipeManager.values()) {
                net.minecraft.world.item.crafting.CraftingRecipe craftingRecipe;
                Recipe<?> recipe1 = recipe.value();
                if (!(recipe1 instanceof CraftingRecipe) || (craftingRecipe = (net.minecraft.world.item.crafting.CraftingRecipe)recipe1) instanceof CustomRecipe) continue;
                ItemStack result = new ItemStack((ItemLike)craftingRecipe.m_8043_(null).m_41720_(), craftingRecipe.m_8043_(null).m_41613_());
                Item[][] altoclefRecipeItems = CraftingRecipeTracker.getShapedCraftingRecipe((List<Ingredient>)craftingRecipe.m_7527_());
                CraftingRecipe altoclefRecipe = CraftingRecipe.newShapedRecipe(altoclefRecipeItems, result.m_41613_());
                if (this.itemRecipeMap.containsKey(result.m_41720_())) {
                    this.itemRecipeMap.get(result.m_41720_()).add(altoclefRecipe);
                } else {
                    ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
                    recipes.add(altoclefRecipe);
                    this.itemRecipeMap.put(result.m_41720_(), recipes);
                }
                this.recipeResultMap.put(altoclefRecipe, result);
            }
            this.itemRecipeMap.replaceAll((k, v) -> Collections.unmodifiableList(v));
            this.shouldRebuild = false;
        }
    }

    private static Item[][] getShapedCraftingRecipe(List<Ingredient> ingredients) {
        Item[][] result = new Item[9][];
        int x = 0;
        for (Ingredient ingredient : ingredients) {
            ItemStack[] stacks = ingredient.m_43908_();
            Item[] items = new Item[stacks.length];
            for (int i = 0; i < stacks.length; ++i) {
                ItemStack stack = stacks[i];
                if (stack.m_41613_() > 1) {
                    throw new IllegalStateException("recipe needs more then one item on a slot... well... shit (ingredients: " + String.valueOf(ingredient) + ")");
                }
                items[i] = stack.m_41720_();
            }
            if (stacks.length != 0) {
                Item[] var10000 = new Item[]{items[0]};
                result[x] = new Item[1];
            } else {
                result[x] = null;
            }
            ++x;
        }
        return result;
    }

    @Override
    protected void reset() {
        this.shouldRebuild = true;
        this.itemRecipeMap.clear();
        this.recipeResultMap.clear();
    }

    @Override
    protected boolean isDirty() {
        return this.shouldRebuild;
    }
}

