/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.baritone;

import com.player2.playerengine.automaton.api.BaritoneAPI;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import net.minecraft.world.phys.Vec3;

public class GoalDirectionXZ
implements Goal {
    private final double originx;
    private final double originz;
    private final double dirx;
    private final double dirz;
    private final double sidePenalty;

    public GoalDirectionXZ(Vec3 origin, Vec3 offset, double sidePenalty) {
        this.originx = origin.m_7096_();
        this.originz = origin.m_7094_();
        offset = offset.m_82542_(1.0, 0.0, 1.0);
        offset = offset.m_82541_();
        this.dirx = offset.f_82479_;
        this.dirz = offset.f_82481_;
        if (this.dirx == 0.0 && this.dirz == 0.0) {
            throw new IllegalArgumentException(String.valueOf(offset));
        }
        this.sidePenalty = sidePenalty;
    }

    private static String maybeCensor(double value) {
        return BaritoneAPI.getGlobalSettings().censorCoordinates.get() != false ? "<censored>" : Double.toString(value);
    }

    @Override
    public boolean isInGoal(int x, int y, int z) {
        return false;
    }

    @Override
    public double heuristic(int x, int y, int z) {
        double dx = (double)x - this.originx;
        double dz = (double)z - this.originz;
        double correctDistance = dx * this.dirx + dz * this.dirz;
        double px = this.dirx * correctDistance;
        double pz = this.dirz * correctDistance;
        double perpendicularDistance = (dx - px) * (dx - px) + (dz - pz) * (dz - pz);
        return -correctDistance * BaritoneAPI.getGlobalSettings().costHeuristic.get() + perpendicularDistance * this.sidePenalty;
    }

    public String toString() {
        return String.format("GoalDirection{x=%s, z=%s, dx=%s, dz=%s}", GoalDirectionXZ.maybeCensor(this.originx), GoalDirectionXZ.maybeCensor(this.originz), GoalDirectionXZ.maybeCensor(this.dirx), GoalDirectionXZ.maybeCensor(this.dirz));
    }
}

