/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.utils;

import com.player2.playerengine.automaton.api.BaritoneAPI;
import com.player2.playerengine.automaton.api.Settings;
import com.player2.playerengine.automaton.api.utils.BlockUtils;
import com.player2.playerengine.automaton.api.utils.TypeUtils;
import java.awt.Color;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class SettingsUtil {
    public static List<Settings.Setting<?>> modifiedSettings(Settings settings) {
        ArrayList modified = new ArrayList();
        for (Settings.Setting<?> setting : settings.allSettings) {
            if (setting.get() == null) {
                System.err.println("NULL SETTING?" + setting.getName());
                continue;
            }
            if (setting.getName().equals("logger") || setting.get() == setting.defaultValue()) continue;
            modified.add(setting);
        }
        return modified;
    }

    public static String settingTypeToString(Settings.Setting<?> setting) {
        return setting.getType().getTypeName().replaceAll("(?:\\w+\\.)+(\\w+)", "$1");
    }

    public static <T> String settingValueToString(Settings.Setting<T> setting, T value) throws IllegalArgumentException {
        Parser io = Parser.getParser(setting.getType());
        if (io == null) {
            throw new IllegalStateException("Missing " + String.valueOf(setting.getValueClass()) + " " + setting.getName());
        }
        return io.toString(new ParserContext(setting), value);
    }

    public static <T> String settingValueToString(Settings.Setting<T> setting) throws IllegalArgumentException {
        return SettingsUtil.settingValueToString(setting, setting.get());
    }

    public static <T> String settingDefaultToString(Settings.Setting<T> setting) throws IllegalArgumentException {
        return SettingsUtil.settingValueToString(setting, setting.defaultValue());
    }

    public static String maybeCensor(int coord) {
        return BaritoneAPI.getGlobalSettings().censorCoordinates.get() != false ? "<censored>" : Integer.toString(coord);
    }

    public static String settingToString(Settings.Setting<?> setting) throws IllegalStateException {
        return setting.getName().equals("logger") ? "logger" : setting.getName() + " " + SettingsUtil.settingValueToString(setting);
    }

    public static void parseAndApply(Settings settings, String settingName, String settingValue) throws IllegalStateException, NumberFormatException {
        Settings.Setting<?> setting = settings.byLowerName.get(settingName);
        if (setting == null) {
            throw new IllegalStateException("No setting by that name");
        }
        SettingsUtil.parseAndApply(setting, settingValue);
    }

    private static <T> void parseAndApply(Settings.Setting<T> setting, String settingValue) {
        Parser ioMethod;
        Object parsed;
        Class<T> intendedType = setting.getValueClass();
        if (!intendedType.isInstance(parsed = (ioMethod = Parser.getParser(setting.getType())).parse(new ParserContext(setting), settingValue))) {
            throw new IllegalStateException(String.valueOf((Object)ioMethod) + " parser returned incorrect type, expected " + String.valueOf(intendedType) + " got " + String.valueOf(parsed) + " which is " + String.valueOf(parsed.getClass()));
        }
        setting.set(parsed);
    }

    private static enum Parser {
        DOUBLE(Double.class, Double::parseDouble),
        BOOLEAN(Boolean.class, Boolean::parseBoolean),
        INTEGER(Integer.class, Integer::parseInt),
        FLOAT(Float.class, Float::parseFloat),
        LONG(Long.class, Long::parseLong),
        STRING(String.class, String::new),
        DIRECTION(Direction.class, d -> Direction.valueOf((String)d.toUpperCase(Locale.ROOT))),
        COLOR(Color.class, str -> new Color(Integer.parseInt(str.split(",")[0]), Integer.parseInt(str.split(",")[1]), Integer.parseInt(str.split(",")[2])), color -> color.getRed() + "," + color.getGreen() + "," + color.getBlue()),
        VEC3I(Vec3i.class, str -> new Vec3i(Integer.parseInt(str.split(",")[0]), Integer.parseInt(str.split(",")[1]), Integer.parseInt(str.split(",")[2])), vec -> vec.getX() + "," + vec.getY() + "," + vec.getZ()),
        BLOCK(Block.class, str -> BlockUtils.stringToBlockRequired(str.trim()), BlockUtils::blockToString),
        ITEM(Item.class, str -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)str.trim())), item -> BuiltInRegistries.ITEM.getResourceKey(item).toString()),
        TAG{

            @Override
            public Object parse(ParserContext context, String raw) {
                Type type = ((ParameterizedType)context.getSetting().getType()).getActualTypeArguments()[0];
                ResourceLocation id = ResourceLocation.tryParse((String)raw);
                if (type == Block.class) {
                    return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id);
                }
                if (type == Item.class) {
                    return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id);
                }
                if (type == EntityType.class) {
                    return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)id);
                }
                if (type == Fluid.class) {
                    return TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)id);
                }
                throw new IllegalArgumentException();
            }

            @Override
            public String toString(ParserContext context, Object value) {
                return ((TagKey)value).location().toString();
            }

            @Override
            public boolean accepts(Type type) {
                return TagKey.class.isAssignableFrom(TypeUtils.resolveBaseClass(type));
            }
        }
        ,
        LIST{

            @Override
            public Object parse(ParserContext context, String raw) {
                Type type = ((ParameterizedType)context.getSetting().getType()).getActualTypeArguments()[0];
                Parser parser = Parser.getParser(type);
                return Stream.of(raw.split(",")).map(s -> parser.parse(context, (String)s)).collect(Collectors.toList());
            }

            @Override
            public String toString(ParserContext context, Object value) {
                Type type = ((ParameterizedType)context.getSetting().getType()).getActualTypeArguments()[0];
                Parser parser = Parser.getParser(type);
                return ((List)value).stream().map(o -> parser.toString(context, o)).collect(Collectors.joining(","));
            }

            @Override
            public boolean accepts(Type type) {
                return List.class.isAssignableFrom(TypeUtils.resolveBaseClass(type));
            }
        };

        private final Class<?> cla$$;
        private final Function<String, Object> parser;
        private final Function<Object, String> toString;

        private Parser() {
            this.cla$$ = null;
            this.parser = null;
            this.toString = null;
        }

        private <T> Parser(Class<T> cla$$, Function<String, T> parser) {
            this(cla$$, parser, Object::toString);
        }

        private <T> Parser(Class<T> cla$$, Function<String, T> parser, Function<T, String> toString) {
            this.cla$$ = cla$$;
            this.parser = parser::apply;
            this.toString = x -> (String)toString.apply(cla$$.cast(x));
        }

        public Object parse(ParserContext context, String raw) {
            Object parsed = this.parser.apply(raw);
            Objects.requireNonNull(parsed);
            return parsed;
        }

        public String toString(ParserContext context, Object value) {
            return this.toString.apply(value);
        }

        public boolean accepts(Type type) {
            return type instanceof Class && this.cla$$.isAssignableFrom((Class)type);
        }

        public static Parser getParser(Type type) {
            return Stream.of(Parser.values()).filter(parser -> parser.accepts(type)).findFirst().orElse(null);
        }
    }

    private static class ParserContext {
        private final Settings.Setting<?> setting;

        private ParserContext(Settings.Setting<?> setting) {
            this.setting = setting;
        }

        private Settings.Setting<?> getSetting() {
            return this.setting;
        }
    }
}

