/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils;

import com.player2.playerengine.automaton.api.BaritoneAPI;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BlockPlaceHelper {
    private final IEntityContext ctx;
    private int rightClickTimer;

    BlockPlaceHelper(IEntityContext playerContext) {
        this.ctx = playerContext;
    }

    public void tick(boolean rightClickRequested) {
        if (this.rightClickTimer > 0) {
            --this.rightClickTimer;
        } else {
            boolean isRowingBoat;
            HitResult mouseOver = this.ctx.objectMouseOver();
            boolean bl = isRowingBoat = this.ctx.entity().getVehicle() != null && this.ctx.entity().getVehicle() instanceof Boat;
            if (rightClickRequested && this.ctx.entity() instanceof IInventoryProvider && !isRowingBoat && mouseOver != null && mouseOver.getType() == HitResult.Type.BLOCK) {
                this.rightClickTimer = BaritoneAPI.getGlobalSettings().rightClickSpeed.get();
                LivingEntity player = this.ctx.entity();
                for (InteractionHand hand : InteractionHand.values()) {
                    InteractionResult actionResult = this.ctx.playerController().processRightClickBlock(player, (Level)this.ctx.world(), hand, (BlockHitResult)mouseOver);
                    if (actionResult.consumesAction()) {
                        if (actionResult.shouldSwing()) {
                            player.swing(hand);
                        }
                        return;
                    }
                    if (player.getItemInHand(hand).isEmpty() || !this.ctx.playerController().processRightClick(player, (Level)this.ctx.world(), hand).consumesAction()) continue;
                    return;
                }
            }
        }
    }
}

