/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.commands;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.commands.base.Arg;
import com.player2.playerengine.commands.base.ArgParser;
import com.player2.playerengine.commands.base.Command;
import com.player2.playerengine.commands.base.CommandException;
import com.player2.playerengine.commands.base.GotoTarget;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.GetToXZTask;
import com.player2.playerengine.tasks.movement.GetToYTask;
import net.minecraft.core.BlockPos;

public class GotoCommand
extends Command {
    public GotoCommand() throws CommandException {
        super("goto", "Tell bot to travel to a set of coordinates", new Arg<GotoTarget>(GotoTarget.class, "[x y z dimension]/[x z dimension]/[y dimension]/[dimension]/[x y z]/[x z]/[y]"));
    }

    public static Task getMovementTaskFor(GotoTarget target) {
        return switch (target.getType()) {
            default -> throw new MatchException(null, null);
            case GotoTarget.GotoTargetCoordType.XYZ -> new GetToBlockTask(new BlockPos(target.getX(), target.getY(), target.getZ()), target.getDimension());
            case GotoTarget.GotoTargetCoordType.XZ -> new GetToXZTask(target.getX(), target.getZ(), target.getDimension());
            case GotoTarget.GotoTargetCoordType.Y -> new GetToYTask(target.getY(), target.getDimension());
            case GotoTarget.GotoTargetCoordType.NONE -> new DefaultGoToDimensionTask(target.getDimension());
        };
    }

    @Override
    protected void call(PlayerEngineController mod, ArgParser parser) throws CommandException {
        GotoTarget target = parser.get(GotoTarget.class);
        mod.runUserTask(GotoCommand.getMovementTaskFor(target), () -> this.finish());
    }
}

