/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks;

import com.player2.playerengine.BotBehaviour;
import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.base.ITaskCanForce;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.container.PickupFromContainerTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.trackers.storage.ContainerCache;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.helpers.StlHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.ArrayUtils;

public abstract class ResourceTask
extends Task
implements ITaskCanForce {
    protected final ItemTarget[] itemTargets;
    private final PickupDroppedItemTask pickupTask;
    private Block[] mineIfPresent = null;
    private BlockPos mineLastClosest = null;
    private boolean forceDimension = false;
    private Dimension targetDimension;
    private ContainerCache currentContainer;
    protected boolean allowContainers = false;

    public ResourceTask(ItemTarget ... itemTargets) {
        this.itemTargets = itemTargets;
        this.pickupTask = new PickupDroppedItemTask(this.itemTargets, true);
    }

    public ResourceTask(Item item, int targetCount) {
        this(new ItemTarget(item, targetCount));
    }

    @Override
    public boolean isFinished() {
        return StorageHelper.itemTargetsMet(this.controller, this.itemTargets);
    }

    @Override
    public boolean shouldForce(Task interruptingCandidate) {
        if (StorageHelper.itemTargetsMet(this.controller, this.itemTargets) && !this.isFinished()) {
            ItemStack cursorStack = this.controller.getSlotHandler().getCursorStack();
            return Arrays.stream(this.itemTargets).anyMatch(target -> target.matches(cursorStack.getItem()));
        }
        return false;
    }

    @Override
    protected void onStart() {
        BotBehaviour botBehaviour = this.controller.getBehaviour();
        botBehaviour.push();
        botBehaviour.addProtectedItems(ItemTarget.getMatches(this.itemTargets));
        this.onResourceStart(this.controller);
    }

    @Override
    protected Task onTick() {
        Optional<BlockPos> closest;
        List<ContainerCache> containersWithItem;
        PlayerEngineController mod = this.controller;
        if (this.isFinished()) {
            return null;
        }
        if (!this.shouldAvoidPickingUp(mod) && mod.getEntityTracker().itemDropped(this.itemTargets)) {
            if (PickupDroppedItemTask.isIsGettingPickaxeFirst(mod)) {
                if (this.pickupTask.isCollectingPickaxeForThis()) {
                    this.setDebugState("Picking up (pickaxe first!)");
                    return this.pickupTask;
                }
                Optional<ItemEntity> closest2 = mod.getEntityTracker().getClosestItemDrop(mod.getPlayer().position(), this.itemTargets);
                if (closest2.isPresent() && !closest2.get().closerThan((Entity)mod.getPlayer(), 10.0)) {
                    return this.onResourceTick(mod);
                }
            }
            double range = this.getPickupRange(mod);
            Optional<ItemEntity> closest3 = mod.getEntityTracker().getClosestItemDrop(mod.getPlayer().position(), this.itemTargets);
            if (range < 0.0 || closest3.isPresent() && closest3.get().closerThan((Entity)mod.getPlayer(), range) || this.pickupTask.isActive() && !this.pickupTask.isFinished()) {
                this.setDebugState("Picking up");
                return this.pickupTask;
            }
        }
        if (this.currentContainer == null && this.allowContainers && !(containersWithItem = mod.getItemStorage().getContainersWithItem(Arrays.stream(this.itemTargets).reduce(new Item[0], (items, target) -> (Item[])ArrayUtils.addAll((Object[])items, (Object[])target.getMatches()), ArrayUtils::addAll))).isEmpty() && ((ContainerCache)((Object)(closest = containersWithItem.stream().min(StlHelper.compareValues(container -> BlockPosVer.getSquaredDistance(container.getBlockPos(), (Position)mod.getPlayer().position()))).get()))).getBlockPos().closerThan(new Vec3i((int)mod.getPlayer().position().x, (int)mod.getPlayer().position().y, (int)mod.getPlayer().position().z), (double)mod.getModSettings().getResourceChestLocateRange())) {
            this.currentContainer = closest;
        }
        if (this.currentContainer != null) {
            Optional<ContainerCache> container2 = mod.getItemStorage().getContainerAtPosition(this.currentContainer.getBlockPos());
            if (container2.isPresent()) {
                if (!Arrays.stream(this.itemTargets).noneMatch(target -> ((ContainerCache)container2.get()).hasItem(target.getMatches()))) {
                    this.setDebugState("Picking up from container");
                    return new PickupFromContainerTask(this.currentContainer.getBlockPos(), this.itemTargets);
                }
                this.currentContainer = null;
            } else {
                this.currentContainer = null;
            }
        }
        if (this.mineIfPresent != null) {
            ArrayList<Block> satisfiedReqs = new ArrayList<Block>(Arrays.asList(this.mineIfPresent));
            satisfiedReqs.removeIf(block -> !StorageHelper.miningRequirementMet(mod, MiningRequirement.getMinimumRequirementForBlock(block)));
            if (!satisfiedReqs.isEmpty() && mod.getBlockScanner().anyFound((Block[])satisfiedReqs.toArray(Block[]::new))) {
                closest = mod.getBlockScanner().getNearestBlock(this.mineIfPresent);
                if (closest.isPresent() && ((BlockPos)closest.get()).closerThan(new Vec3i((int)mod.getPlayer().position().x, (int)mod.getPlayer().position().y, (int)mod.getPlayer().position().z), (double)mod.getModSettings().getResourceMineRange())) {
                    this.mineLastClosest = (BlockPos)closest.get();
                }
                if (this.mineLastClosest != null && this.mineLastClosest.closerThan(new Vec3i((int)mod.getPlayer().position().x, (int)mod.getPlayer().position().y, (int)mod.getPlayer().position().z), (double)mod.getModSettings().getResourceMineRange() * 1.5 + 20.0)) {
                    return new MineAndCollectTask(this.itemTargets, this.mineIfPresent, MiningRequirement.HAND);
                }
            }
        }
        if (this.isInWrongDimension(this.controller)) {
            this.setDebugState("Traveling to correct dimension");
            return this.getToCorrectDimensionTask(this.controller);
        }
        return this.onResourceTick(this.controller);
    }

    private boolean isPickupTaskValid(PlayerEngineController controller) {
        double range = this.getPickupRange(controller);
        return range < 0.0 ? true : controller.getEntityTracker().getClosestItemDrop(controller.getEntity().position(), this.itemTargets).map(itemEntity -> itemEntity.closerThan((Entity)controller.getEntity(), range) || this.pickupTask.isActive() && !this.pickupTask.isFinished()).orElse(false);
    }

    protected double getPickupRange(PlayerEngineController controller) {
        return controller.getModSettings().getResourcePickupRange();
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
        this.onResourceStop(this.controller, interruptTask);
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof ResourceTask)) {
            bl = false;
        } else {
            ResourceTask task = (ResourceTask)other;
            bl = Arrays.equals(task.itemTargets, this.itemTargets) && this.isEqualResource(task);
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return this.toDebugStringName() + ": " + Arrays.toString(this.itemTargets);
    }

    protected boolean isInWrongDimension(PlayerEngineController controller) {
        return this.forceDimension ? WorldHelper.getCurrentDimension(controller) != this.targetDimension : false;
    }

    protected Task getToCorrectDimensionTask(PlayerEngineController controller) {
        return new DefaultGoToDimensionTask(this.targetDimension);
    }

    public ResourceTask forceDimension(Dimension dimension) {
        this.forceDimension = true;
        this.targetDimension = dimension;
        return this;
    }

    public ItemTarget[] getItemTargets() {
        return this.itemTargets;
    }

    public ResourceTask mineIfPresent(Block[] toMine) {
        this.mineIfPresent = toMine;
        return this;
    }

    protected abstract boolean shouldAvoidPickingUp(PlayerEngineController var1);

    protected abstract void onResourceStart(PlayerEngineController var1);

    protected abstract Task onResourceTick(PlayerEngineController var1);

    protected abstract void onResourceStop(PlayerEngineController var1, Task var2);

    protected abstract boolean isEqualResource(ResourceTask var1);

    protected abstract String toDebugStringName();
}

