/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction.compound;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceBlockTask;
import com.player2.playerengine.tasks.construction.PlaceStructureBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ConstructNetherPortalObsidianTask
extends Task {
    private static final Vec3i[] PORTAL_FRAME = new Vec3i[]{new Vec3i(0, 0, -1), new Vec3i(0, 1, -1), new Vec3i(0, 2, -1), new Vec3i(0, 0, 2), new Vec3i(0, 1, 2), new Vec3i(0, 2, 2), new Vec3i(0, 3, 0), new Vec3i(0, 3, 1), new Vec3i(0, -1, 0), new Vec3i(0, -1, 1)};
    private static final Vec3i[] PORTAL_INTERIOR = new Vec3i[]{new Vec3i(0, 0, 0), new Vec3i(0, 1, 0), new Vec3i(0, 2, 0), new Vec3i(0, 0, 1), new Vec3i(0, 1, 1), new Vec3i(0, 2, 1), new Vec3i(1, 0, 0), new Vec3i(1, 1, 0), new Vec3i(1, 2, 0), new Vec3i(1, 0, 1), new Vec3i(1, 1, 1), new Vec3i(1, 2, 1), new Vec3i(-1, 0, 0), new Vec3i(-1, 1, 0), new Vec3i(-1, 2, 0), new Vec3i(-1, 0, 1), new Vec3i(-1, 1, 1), new Vec3i(-1, 2, 1)};
    private static final Vec3i PORTALABLE_REGION_SIZE = new Vec3i(3, 6, 6);
    private final TimerGame areaSearchTimer = new TimerGame(5.0);
    private BlockPos origin;
    private BlockPos destroyTarget;

    private BlockPos getBuildableAreaNearby(PlayerEngineController mod) {
        BlockPos checkOrigin = mod.getPlayer().blockPosition();
        for (BlockPos toCheck : WorldHelper.scanRegion(checkOrigin, checkOrigin.offset(PORTALABLE_REGION_SIZE))) {
            boolean validToWorld;
            if (this.controller.getWorld() == null) {
                return null;
            }
            BlockState state = this.controller.getWorld().getBlockState(toCheck);
            boolean bl = validToWorld = WorldHelper.canPlace(this.controller, toCheck) || WorldHelper.canBreak(this.controller, toCheck);
            if (validToWorld && state.getBlock() != Blocks.LAVA && state.getBlock() != Blocks.WATER && state.getBlock() != Blocks.BEDROCK) continue;
            return null;
        }
        return checkOrigin;
    }

    @Override
    protected void onStart() {
        PlayerEngineController mod = this.controller;
        mod.getBehaviour().push();
        mod.getBehaviour().avoidBlockBreaking(block -> {
            if (this.origin != null) {
                for (Vec3i framePosRelative : PORTAL_FRAME) {
                    BlockPos framePos = this.origin.offset(framePosRelative);
                    if (!block.equals((Object)framePos)) continue;
                    return mod.getWorld().getBlockState(framePos).getBlock() == Blocks.OBSIDIAN;
                }
            }
            return false;
        });
        mod.getBehaviour().addProtectedItems(Items.FLINT_AND_STEEL);
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (this.origin != null && mod.getWorld().getBlockState(this.origin.above()).getBlock() == Blocks.NETHER_PORTAL) {
            this.setDebugState("Done constructing nether portal.");
            mod.getBlockScanner().addBlock(Blocks.NETHER_PORTAL, this.origin.above());
            return null;
        }
        int neededObsidian = 10;
        BlockPos placeTarget = null;
        if (this.origin != null) {
            for (Vec3i frameOffs : PORTAL_FRAME) {
                BlockPos framePos = this.origin.offset(frameOffs);
                if (!mod.getBlockScanner().isBlockAtPosition(framePos, Blocks.OBSIDIAN)) {
                    placeTarget = framePos;
                    break;
                }
                --neededObsidian;
            }
        }
        if (mod.getItemStorage().getItemCount(Items.OBSIDIAN) < neededObsidian) {
            this.setDebugState("Getting obsidian");
            return TaskCatalogue.getItemTask(Items.OBSIDIAN, neededObsidian);
        }
        if (this.origin == null) {
            if (this.areaSearchTimer.elapsed()) {
                this.areaSearchTimer.reset();
                Debug.logMessage("(Searching for area to build portal nearby...)");
                this.origin = this.getBuildableAreaNearby(mod);
            }
            this.setDebugState("Looking for portalable area...");
            return new TimeoutWanderTask();
        }
        if (!mod.getItemStorage().hasItem(Items.FLINT_AND_STEEL)) {
            this.setDebugState("Getting flint and steel");
            return TaskCatalogue.getItemTask(Items.FLINT_AND_STEEL, 1);
        }
        if (placeTarget == null) {
            if (this.destroyTarget != null && !WorldHelper.isAir(this.controller.getWorld().getBlockState(this.destroyTarget).getBlock())) {
                return new DestroyBlockTask(this.destroyTarget);
            }
            for (Vec3i middleOffs : PORTAL_INTERIOR) {
                BlockPos middlePos = this.origin.offset(middleOffs);
                if (WorldHelper.isAir(this.controller.getWorld().getBlockState(middlePos).getBlock())) continue;
                this.destroyTarget = middlePos;
                return new DestroyBlockTask(this.destroyTarget);
            }
            return new InteractWithBlockTask(new ItemTarget(Items.FLINT_AND_STEEL, 1), Direction.UP, this.origin.below(), true);
        }
        ServerLevel clientWorld = mod.getWorld();
        if (this.surroundedByAir((Level)clientWorld, placeTarget)) {
            LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
            queue.add(placeTarget);
            while (this.surroundedByAir((Level)clientWorld, placeTarget)) {
                BlockPos pos = (BlockPos)queue.removeFirst();
                if (!this.surroundedByAir((Level)clientWorld, pos)) {
                    return new PlaceStructureBlockTask(pos);
                }
                queue.add(pos.above());
                queue.add(pos.below());
                queue.add(pos.east());
                queue.add(pos.west());
                queue.add(pos.north());
                queue.add(pos.south());
            }
            mod.logWarning("Did not find any block to place obsidian on");
        }
        if (!clientWorld.getBlockState(placeTarget).isAir() && !clientWorld.getBlockState(placeTarget).getBlock().equals(Blocks.OBSIDIAN)) {
            return new DestroyBlockTask(placeTarget);
        }
        this.setDebugState("Placing frame...");
        return new PlaceBlockTask(placeTarget, Blocks.OBSIDIAN);
    }

    private boolean surroundedByAir(Level world, BlockPos pos) {
        return world.getBlockState(pos.west()).isAir() && world.getBlockState(pos.south()).isAir() && world.getBlockState(pos.east()).isAir() && world.getBlockState(pos.above()).isAir() && world.getBlockState(pos.below()).isAir() && world.getBlockState(pos.north()).isAir();
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof ConstructNetherPortalObsidianTask;
    }

    @Override
    protected String toDebugString() {
        return "Building nether portal with obsidian";
    }
}

