/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.container;

import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.slot.EnsureFreeInventorySlotTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;

public class PickupFromContainerTask
extends Task {
    private final BlockPos containerPos;
    private final ItemTarget[] targets;

    public PickupFromContainerTask(BlockPos targetContainer, ItemTarget ... targets) {
        this.containerPos = targetContainer;
        this.targets = targets;
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected Task onTick() {
        if (this.isFinished()) {
            return null;
        }
        if (!this.containerPos.closerThan(new Vec3i((int)this.controller.getEntity().position().x, (int)this.controller.getEntity().position().y, (int)this.controller.getEntity().position().z), 4.5)) {
            return new GetToBlockTask(this.containerPos);
        }
        BlockEntity blockEntity = this.controller.getWorld().getBlockEntity(this.containerPos);
        if (!(blockEntity instanceof RandomizableContainerBlockEntity)) {
            Debug.logWarning("Block at " + String.valueOf(this.containerPos) + " is not a lootable container. Stopping.");
            return null;
        }
        RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)blockEntity;
        RandomizableContainerBlockEntity containerInventory = container;
        LivingEntityInventory playerInventory = ((IInventoryProvider)this.controller.getEntity()).getLivingInventory();
        for (ItemTarget target : this.targets) {
            int needed = target.getTargetCount() - this.controller.getItemStorage().getItemCount(target);
            if (needed <= 0) continue;
            for (int i = 0; i < containerInventory.getContainerSize(); ++i) {
                ItemStack stack = containerInventory.getItem(i);
                if (!target.matches(stack.getItem())) continue;
                this.setDebugState("Looting " + String.valueOf(target));
                if (!playerInventory.insertStack(new ItemStack((ItemLike)stack.getItem()))) {
                    return new EnsureFreeInventorySlotTask();
                }
                ItemStack toMove = stack.copy();
                int moveAmount = Math.min(toMove.getCount(), needed);
                toMove.setCount(moveAmount);
                if (playerInventory.insertStack(toMove)) {
                    stack.shrink(moveAmount);
                    containerInventory.setItem(i, stack);
                    container.setChanged();
                    this.controller.getItemStorage().registerSlotAction();
                }
                return null;
            }
        }
        this.setDebugState("Waiting for items to appear in container or finishing.");
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    public boolean isFinished() {
        return Arrays.stream(this.targets).allMatch(target -> this.controller.getItemStorage().getItemCount((ItemTarget)target) >= target.getTargetCount());
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof PickupFromContainerTask)) {
            bl = false;
        } else {
            PickupFromContainerTask task = (PickupFromContainerTask)other;
            bl = Objects.equals(task.containerPos, this.containerPos) && Arrays.equals(task.targets, this.targets);
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Picking up from container at (" + this.containerPos.toShortString() + "): " + Arrays.toString(this.targets);
    }
}

