/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.container;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.container.StoreInContainerTask;
import com.player2.playerengine.tasks.movement.GetToXZTask;
import com.player2.playerengine.trackers.storage.ContainerCache;
import com.player2.playerengine.util.BlockRange;
import com.player2.playerengine.util.ItemTarget;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;

public class StoreInStashTask
extends Task {
    private final ItemTarget[] toStore;
    private final boolean getIfNotPresent;
    private final BlockRange stashRange;

    public StoreInStashTask(boolean getIfNotPresent, BlockRange stashRange, ItemTarget ... toStore) {
        this.getIfNotPresent = getIfNotPresent;
        this.stashRange = stashRange;
        this.toStore = toStore;
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected Task onTick() {
        Optional<BlockPos> closestContainer;
        ItemTarget[] itemsToStore = this.getItemsToStore(this.controller);
        if (itemsToStore.length == 0) {
            return null;
        }
        if (this.getIfNotPresent) {
            for (ItemTarget target : this.toStore) {
                if (this.controller.getItemStorage().getItemCount(target) >= target.getTargetCount()) continue;
                this.setDebugState("Collecting " + String.valueOf(target) + " before stashing.");
                return TaskCatalogue.getItemTask(target);
            }
        }
        if ((closestContainer = this.controller.getBlockScanner().getNearestBlock(pos -> {
            if (!this.stashRange.contains(this.controller, (BlockPos)pos)) {
                return false;
            }
            Optional<ContainerCache> cache = this.controller.getItemStorage().getContainerAtPosition((BlockPos)pos);
            return cache.map(containerCache -> !containerCache.isFull()).orElse(true);
        }, StoreInContainerTask.CONTAINER_BLOCKS)).isPresent()) {
            this.setDebugState("Storing in closest stash container.");
            return new StoreInContainerTask(closestContainer.get(), false, itemsToStore);
        }
        if (!this.stashRange.contains(this.controller, this.controller.getEntity().blockPosition())) {
            this.setDebugState("Traveling to stash area.");
            BlockPos centerStash = this.stashRange.getCenter();
            return new GetToXZTask(centerStash.getX(), centerStash.getZ());
        }
        this.setDebugState("Inside stash, but no non-full containers found. Cannot store items.");
        return null;
    }

    @Override
    public boolean isFinished() {
        return this.getItemsToStore(this.controller).length == 0;
    }

    private ItemTarget[] getItemsToStore(PlayerEngineController controller) {
        return (ItemTarget[])Arrays.stream(this.toStore).filter(target -> controller.getItemStorage().hasItem(target.getMatches())).toArray(ItemTarget[]::new);
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof StoreInStashTask)) {
            bl = false;
        } else {
            StoreInStashTask task = (StoreInStashTask)other;
            bl = task.stashRange.equals(this.stashRange) && task.getIfNotPresent == this.getIfNotPresent && Arrays.equals(task.toStore, this.toStore);
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Storing in stash " + String.valueOf(this.stashRange) + ": " + Arrays.toString(this.toStore);
    }
}

