/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.multiversion.item.ItemVer;
import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.container.CraftInTableTask;
import com.player2.playerengine.tasks.container.SmeltInSmokerTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.resources.CollectCropTask;
import com.player2.playerengine.tasks.resources.CollectMeatTask;
import com.player2.playerengine.tasks.resources.KillAndLootTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.SmeltTarget;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;

public class CollectFoodTask
extends Task {
    public static final CookableFoodTarget[] COOKABLE_FOODS = new CookableFoodTarget[]{new CookableFoodTarget("beef", Cow.class), new CookableFoodTarget("porkchop", Pig.class), new CookableFoodTarget("chicken", Chicken.class), new CookableFoodTarget("mutton", Sheep.class), new CookableFoodTarget("rabbit", Rabbit.class)};
    public static final Item[] ITEMS_TO_PICK_UP = new Item[]{Items.ENCHANTED_GOLDEN_APPLE, Items.GOLDEN_APPLE, Items.GOLDEN_CARROT, Items.BREAD, Items.BAKED_POTATO};
    public static final CropTarget[] CROPS = new CropTarget[]{new CropTarget(Items.WHEAT, Blocks.WHEAT), new CropTarget(Items.CARROT, Blocks.CARROTS)};
    private final double unitsNeeded;
    private final TimerGame checkNewOptionsTimer = new TimerGame(10.0);
    private Task currentResourceTask = null;

    public CollectFoodTask(double unitsNeeded) {
        this.unitsNeeded = unitsNeeded;
    }

    @Override
    protected void onStart() {
        this.controller.getBehaviour().push();
        this.controller.getBehaviour().addProtectedItems(ITEMS_TO_PICK_UP);
        this.controller.getBehaviour().addProtectedItems(Items.HAY_BLOCK, Items.SWEET_BERRIES);
    }

    @Override
    protected Task onTick() {
        CollectFoodTask.blackListChickenJockeys(this.controller);
        CollectFoodTask.blacklistPillagerHayBales(this.controller);
        SmeltTarget toSmelt = this.getBestSmeltTarget(this.controller);
        if (toSmelt != null) {
            this.setDebugState("Smelting food");
            return new SmeltInSmokerTask(toSmelt);
        }
        if (this.checkNewOptionsTimer.elapsed()) {
            this.checkNewOptionsTimer.reset();
            this.currentResourceTask = null;
        }
        if (this.currentResourceTask != null && this.currentResourceTask.isActive() && !this.currentResourceTask.isFinished() && !this.currentResourceTask.thisOrChildAreTimedOut()) {
            return this.currentResourceTask;
        }
        double potentialFood = StorageHelper.calculateInventoryFoodScore(this.controller);
        if (potentialFood >= this.unitsNeeded) {
            if (this.controller.getItemStorage().getItemCount(Items.HAY_BLOCK) >= 1) {
                this.setDebugState("Crafting wheat from hay");
                this.currentResourceTask = new CraftInInventoryTask(new RecipeTarget(Items.WHEAT, 9, CraftingRecipe.newShapedRecipe("wheat", new ItemTarget[]{new ItemTarget(Items.HAY_BLOCK, 1)}, 9)));
                return this.currentResourceTask;
            }
            if (this.controller.getItemStorage().getItemCount(Items.WHEAT) >= 3) {
                this.setDebugState("Crafting bread");
                this.currentResourceTask = new CraftInTableTask(new RecipeTarget(Items.BREAD, 1, CraftingRecipe.newShapedRecipe("bread", new ItemTarget[]{new ItemTarget(Items.WHEAT, 3)}, 1)));
                return this.currentResourceTask;
            }
        }
        for (Item item : ITEMS_TO_PICK_UP) {
            if (!this.controller.getEntityTracker().itemDropped(item)) continue;
            this.setDebugState("Picking up high-value food: " + item.getDescription().getString());
            this.currentResourceTask = new PickupDroppedItemTask(new ItemTarget(item), true);
            return this.currentResourceTask;
        }
        for (CookableFoodTarget cookableFoodTarget : COOKABLE_FOODS) {
            if (!this.controller.getEntityTracker().itemDropped(cookableFoodTarget.getRaw(), cookableFoodTarget.getCooked())) continue;
            this.setDebugState("Picking up dropped meat");
            this.currentResourceTask = new PickupDroppedItemTask(new ItemTarget(cookableFoodTarget.getRaw(), cookableFoodTarget.getCooked()), true);
            return this.currentResourceTask;
        }
        if (this.controller.getBlockScanner().anyFound(Blocks.HAY_BLOCK)) {
            this.setDebugState("Collecting hay bales");
            this.currentResourceTask = new MineAndCollectTask(new ItemTarget(Items.HAY_BLOCK, 9999), new Block[]{Blocks.HAY_BLOCK}, MiningRequirement.HAND);
            return this.currentResourceTask;
        }
        for (CropTarget cropTarget : CROPS) {
            if (!this.controller.getBlockScanner().anyFound(pos -> CollectFoodTask.isCropMature(this.controller, pos, crop.cropBlock), cropTarget.cropBlock)) continue;
            this.setDebugState("Harvesting " + cropTarget.cropItem.getDescription().getString());
            this.currentResourceTask = new CollectCropTask(new ItemTarget(cropTarget.cropItem, 9999), new Block[]{cropTarget.cropBlock}, cropTarget.cropItem);
            return this.currentResourceTask;
        }
        Entity entity = this.getBestAnimalToKill(this.controller);
        if (entity != null) {
            this.setDebugState("Killing " + entity.getType().getDescription().getString());
            Item rawFood = Arrays.stream(COOKABLE_FOODS).filter(c -> c.mobToKill == bestEntityToKill.getClass()).findFirst().get().getRaw();
            this.currentResourceTask = new KillAndLootTask(entity.getClass(), new ItemTarget(rawFood, 1));
            return this.currentResourceTask;
        }
        if (this.controller.getBlockScanner().anyFound(Blocks.SWEET_BERRY_BUSH)) {
            this.setDebugState("Collecting sweet berries");
            this.currentResourceTask = new MineAndCollectTask(new ItemTarget(Items.SWEET_BERRIES, 9999), new Block[]{Blocks.SWEET_BERRY_BUSH}, MiningRequirement.HAND);
            return this.currentResourceTask;
        }
        this.setDebugState("Searching for food source...");
        return new TimeoutWanderTask();
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    public boolean isFinished() {
        return (double)StorageHelper.calculateInventoryFoodScore(this.controller) >= this.unitsNeeded;
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof CollectFoodTask) {
            CollectFoodTask task = (CollectFoodTask)other;
            bl = task.unitsNeeded == this.unitsNeeded;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Collecting " + this.unitsNeeded + " food units.";
    }

    private SmeltTarget getBestSmeltTarget(PlayerEngineController controller) {
        for (CookableFoodTarget cookable : COOKABLE_FOODS) {
            int rawCount = controller.getItemStorage().getItemCount(cookable.getRaw());
            if (rawCount <= 0) continue;
            return new SmeltTarget(new ItemTarget(cookable.getCooked(), rawCount), new ItemTarget(cookable.getRaw(), rawCount), new Item[0]);
        }
        return null;
    }

    private Entity getBestAnimalToKill(PlayerEngineController controller) {
        double bestScore = -1.0;
        Entity bestEntity = null;
        Predicate<Entity> notBaby = entity -> entity instanceof LivingEntity && !((LivingEntity)entity).isBaby();
        for (CookableFoodTarget cookable : COOKABLE_FOODS) {
            double score;
            double distanceSq;
            Optional<Entity> nearest;
            if (!controller.getEntityTracker().entityFound(cookable.mobToKill) || !(nearest = controller.getEntityTracker().getClosestEntity(controller.getEntity().position(), notBaby, cookable.mobToKill)).isPresent() || (distanceSq = nearest.get().position().distanceToSqr(controller.getEntity().position())) == 0.0 || !((score = (double)cookable.getCookedUnits() / distanceSq) > bestScore)) continue;
            bestScore = score;
            bestEntity = nearest.get();
        }
        return bestEntity;
    }

    public static void blackListChickenJockeys(PlayerEngineController controller) {
        for (Chicken chicken : controller.getEntityTracker().getTrackedEntities(Chicken.class)) {
            if (!chicken.isVehicle()) continue;
            controller.getEntityTracker().requestEntityUnreachable((Entity)chicken);
        }
    }

    private static void blacklistPillagerHayBales(PlayerEngineController controller) {
        for (BlockPos pos : controller.getBlockScanner().getKnownLocations(Blocks.HAY_BLOCK)) {
            if (!controller.getWorld().getBlockState(pos.above()).is(Blocks.CARVED_PUMPKIN)) continue;
            controller.getBlockScanner().requestBlockUnreachable(pos, 0);
        }
    }

    private static boolean isCropMature(PlayerEngineController controller, BlockPos pos, Block block) {
        boolean bl;
        if (!controller.getChunkTracker().isChunkLoaded(pos)) {
            return false;
        }
        Block block2 = controller.getWorld().getBlockState(pos).getBlock();
        if (block2 instanceof CropBlock) {
            CropBlock crop = (CropBlock)block2;
            bl = crop.isMaxAge(controller.getWorld().getBlockState(pos));
        } else {
            bl = true;
        }
        return bl;
    }

    public static double calculateFoodPotential(PlayerEngineController mod) {
        double potentialFood = 0.0;
        for (ItemStack food : mod.getItemStorage().getItemStacksPlayerInventory(true)) {
            potentialFood += CollectMeatTask.getFoodPotential(food);
        }
        int potentialBread = mod.getItemStorage().getItemCount(Items.WHEAT) / 3 + mod.getItemStorage().getItemCount(Items.HAY_BLOCK) * 3;
        return potentialFood + (double)(Objects.requireNonNull(ItemVer.getFoodComponent(Items.BREAD)).getHunger() * potentialBread);
    }

    public static class CookableFoodTarget {
        public final String rawFood;
        public final String cookedFood;
        public final Class<? extends Entity> mobToKill;

        public CookableFoodTarget(String rawFood, Class<? extends Entity> mobToKill) {
            this(rawFood, "cooked_" + rawFood, mobToKill);
        }

        public CookableFoodTarget(String rawFood, String cookedFood, Class<? extends Entity> mobToKill) {
            this.rawFood = rawFood;
            this.cookedFood = cookedFood;
            this.mobToKill = mobToKill;
        }

        public Item getRaw() {
            return TaskCatalogue.getItemMatches(this.rawFood)[0];
        }

        public Item getCooked() {
            return TaskCatalogue.getItemMatches(this.cookedFood)[0];
        }

        public int getCookedUnits() {
            return ItemVer.getFoodComponent(this.getCooked()).getHunger();
        }
    }

    public static class CropTarget {
        public final Item cropItem;
        public final Block cropBlock;

        public CropTarget(Item cropItem, Block cropBlock) {
            this.cropItem = cropItem;
            this.cropBlock = cropBlock;
        }
    }
}

