/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PlaceBlockTask;
import com.player2.playerengine.tasks.movement.GetCloseToBlockTask;
import com.player2.playerengine.tasks.movement.SearchChunkForBlockTask;
import com.player2.playerengine.tasks.squashed.CataloguedResourceTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CollectHoneycombTask
extends ResourceTask {
    private final boolean campfire;
    private final int count;
    private BlockPos nest;

    public CollectHoneycombTask(int targetCount) {
        super(Items.HONEYCOMB, targetCount);
        this.campfire = true;
        this.count = targetCount;
    }

    public CollectHoneycombTask(int targetCount, boolean useCampfire) {
        super(Items.HONEYCOMB, targetCount);
        this.campfire = useCampfire;
        this.count = targetCount;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
        mod.getBehaviour().push();
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        Optional<BlockPos> getNearestNest;
        if (this.nest == null && (getNearestNest = mod.getBlockScanner().getNearestBlock(Blocks.BEE_NEST)).isPresent()) {
            this.nest = getNearestNest.get();
        }
        if (this.nest == null) {
            if (this.campfire && !mod.getItemStorage().hasItemInventoryOnly(Items.CAMPFIRE)) {
                this.setDebugState("Can't find nest, getting campfire first...");
                return new CataloguedResourceTask(new ItemTarget(Items.CAMPFIRE, 1));
            }
            this.setDebugState("Alright, we're searching");
            return new SearchChunkForBlockTask(Blocks.BEE_NEST);
        }
        if (this.campfire && !this.isCampfireUnderNest(mod, this.nest)) {
            if (!mod.getItemStorage().hasItemInventoryOnly(Items.CAMPFIRE)) {
                this.setDebugState("Getting a campfire");
                return new CataloguedResourceTask(new ItemTarget(Items.CAMPFIRE, 1));
            }
            this.setDebugState("Placing campfire");
            return new PlaceBlockTask(this.nest.below(2), Blocks.CAMPFIRE);
        }
        if (!mod.getItemStorage().hasItemInventoryOnly(Items.SHEARS)) {
            this.setDebugState("Getting shears");
            return new CataloguedResourceTask(new ItemTarget(Items.SHEARS, 1));
        }
        if ((Integer)mod.getWorld().getBlockState(this.nest).getValue((Property)BlockStateProperties.LEVEL_HONEY) != 5) {
            if (!this.nest.closerToCenterThan((Position)mod.getPlayer().position(), 20.0)) {
                this.setDebugState("Getting close to nest");
                return new GetCloseToBlockTask(this.nest);
            }
            this.setDebugState("Waiting for nest to get honey...");
            return null;
        }
        return new InteractWithBlockTask(Items.SHEARS, this.nest);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
        mod.getBehaviour().pop();
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectHoneycombTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " Honeycombs " + (this.campfire ? "Peacefully" : "Recklessly");
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    private boolean isCampfireUnderNest(PlayerEngineController mod, BlockPos pos) {
        for (BlockPos underPos : WorldHelper.scanRegion(pos.below(6), pos.below())) {
            if (mod.getWorld().getBlockState(underPos).getBlock() != Blocks.CAMPFIRE) continue;
            return true;
        }
        return false;
    }
}

