/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.speedrun;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.GoalGetToBlock;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.mixins.LivingEntityMixin;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.entity.AbstractKillEntityTask;
import com.player2.playerengine.tasks.entity.DoToClosestEntityTask;
import com.player2.playerengine.tasks.misc.EquipArmorTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.resources.CollectBlockByOneTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class KillEnderDragonTask
extends Task {
    private static final String[] DIAMOND_ARMORS = new String[]{"diamond_chestplate", "diamond_leggings", "diamond_helmet", "diamond_boots"};
    private final TimerGame lookDownTimer = new TimerGame(0.5);
    private final Task collectBuildMaterialsTask = new CollectBlockByOneTask.CollectEndStoneTask(100);
    private final PunkEnderDragonTask punkTask = new PunkEnderDragonTask();
    private BlockPos exitPortalTop;

    private static Task getPickupTaskIfAny(PlayerEngineController mod, Item ... itemsToPickup) {
        for (Item check : itemsToPickup) {
            if (!mod.getEntityTracker().itemDropped(check)) continue;
            return new PickupDroppedItemTask(new ItemTarget(check), true);
        }
        return null;
    }

    @Override
    protected void onStart() {
        PlayerEngineController mod = this.controller;
        mod.getBehaviour().push();
        mod.getBehaviour().addForceFieldExclusion(entity -> entity instanceof EnderMan || entity instanceof EnderDragon || entity instanceof EnderDragonPart);
        mod.getBehaviour().setPreferredStairs(true);
    }

    @Override
    protected Task onTick() {
        Task pickupDrops;
        PlayerEngineController mod = this.controller;
        if (this.exitPortalTop == null) {
            this.exitPortalTop = this.locateExitPortalTop(mod);
        }
        ArrayList<Item> toPickUp = new ArrayList<Item>(Arrays.asList(Items.DIAMOND_SWORD, Items.DIAMOND_BOOTS, Items.DIAMOND_LEGGINGS, Items.DIAMOND_CHESTPLATE, Items.DIAMOND_HELMET));
        if (StorageHelper.calculateInventoryFoodScore(mod) < 10) {
            toPickUp.addAll(Arrays.asList(Items.BREAD, Items.COOKED_BEEF, Items.COOKED_CHICKEN, Items.COOKED_MUTTON, Items.COOKED_RABBIT, Items.COOKED_PORKCHOP));
        }
        if ((pickupDrops = KillEnderDragonTask.getPickupTaskIfAny(mod, (Item[])toPickUp.toArray(Item[]::new))) != null) {
            this.setDebugState("Picking up drops in end.");
            return pickupDrops;
        }
        for (Item armor : ItemHelper.DIAMOND_ARMORS) {
            try {
                if (!mod.getItemStorage().hasItem(armor) || StorageHelper.isArmorEquipped(mod, armor)) continue;
                this.setDebugState("Equipping " + String.valueOf(armor));
                return new EquipArmorTask(armor);
            }
            catch (NullPointerException var9) {
                Debug.logError("NullpointerException that Should never happen.");
                var9.printStackTrace();
            }
        }
        if (!this.isRailingOnDragon() && this.lookDownTimer.elapsed() && !mod.getControllerExtras().isBreakingBlock() && mod.getPlayer().onGround()) {
            this.lookDownTimer.reset();
            mod.getBaritone().getLookBehavior().updateTarget(new Rotation(0.0f, 90.0f), true);
        }
        if (mod.getBlockScanner().anyFound(Blocks.END_PORTAL)) {
            this.setDebugState("Entering portal to beat the game.");
            return new DoToClosestBlockTask(blockPos -> new GetToBlockTask(blockPos.above(), false), Blocks.END_PORTAL);
        }
        int MINIMUM_BUILDING_BLOCKS = 1;
        if (mod.getEntityTracker().entityFound(EndCrystal.class) && mod.getItemStorage().getItemCount(Items.DIRT, Items.COBBLESTONE, Items.NETHERRACK, Items.END_STONE) < MINIMUM_BUILDING_BLOCKS || this.collectBuildMaterialsTask.isActive() && !this.collectBuildMaterialsTask.isFinished()) {
            if (StorageHelper.miningRequirementMetInventory(this.controller, MiningRequirement.WOOD)) {
                mod.getBehaviour().addProtectedItems(Items.END_STONE);
                this.setDebugState("Collecting building blocks to pillar to crystals");
                return this.collectBuildMaterialsTask;
            }
        } else {
            mod.getBehaviour().removeProtectedItems(Items.END_STONE);
        }
        if (mod.getEntityTracker().entityFound(EndCrystal.class)) {
            this.setDebugState("Kamakazeeing crystals");
            return new DoToClosestEntityTask(toDestroy -> {
                if (toDestroy.closerThan((Entity)mod.getPlayer(), 7.0)) {
                    mod.getControllerExtras().attack((Entity)toDestroy);
                }
                return new GetToBlockTask(toDestroy.blockPosition().offset(1, 0, 0), false);
            }, EndCrystal.class);
        }
        if (mod.getEntityTracker().entityFound(EnderDragon.class)) {
            this.setDebugState("Punking dragon");
            return this.punkTask;
        }
        this.setDebugState("Couldn't find ender dragon... This can be very good or bad news.");
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof KillEnderDragonTask;
    }

    @Override
    protected String toDebugString() {
        return "Killing Ender Dragon";
    }

    private boolean isRailingOnDragon() {
        return this.punkTask.getMode() == Mode.RAILING;
    }

    private BlockPos locateExitPortalTop(PlayerEngineController mod) {
        if (!mod.getChunkTracker().isChunkLoaded(new BlockPos(0, 64, 0))) {
            return null;
        }
        int height = WorldHelper.getGroundHeight(mod, 0, 0, Blocks.BEDROCK);
        return height != -1 ? new BlockPos(0, height, 0) : null;
    }

    private class PunkEnderDragonTask
    extends Task {
        private final HashMap<BlockPos, Double> breathCostMap = new HashMap();
        private final TimerGame hitHoldTimer = new TimerGame(0.1);
        private final TimerGame hitResetTimer = new TimerGame(0.4);
        private final TimerGame randomWanderChangeTimeout = new TimerGame(20.0);
        private Mode mode = Mode.WAITING_FOR_PERCH;
        private BlockPos randomWanderPos;
        private boolean wasHitting;
        private boolean wasReleased;

        private PunkEnderDragonTask() {
        }

        public Mode getMode() {
            return this.mode;
        }

        private void hit(PlayerEngineController mod) {
            mod.getExtraBaritoneSettings().setInteractionPaused(true);
            if (!this.wasHitting) {
                this.wasHitting = true;
                this.wasReleased = false;
                this.hitHoldTimer.reset();
                this.hitResetTimer.reset();
                Debug.logInternal("HIT");
                mod.getInputControls().tryPress(Input.CLICK_LEFT);
            }
            if (this.hitHoldTimer.elapsed() && !this.wasReleased) {
                Debug.logInternal("    up");
                this.wasReleased = true;
            }
            if (this.wasHitting && this.hitResetTimer.elapsed() && (double)this.getAttackCooldownProgress(mod.getPlayer(), 0.0f) > 0.99) {
                this.wasHitting = false;
                mod.getExtraBaritoneSettings().setInteractionPaused(false);
                this.hitResetTimer.reset();
            }
        }

        public float getAttackCooldownProgressPerTick(LivingEntity entity) {
            return (float)(1.0 / entity.getAttributeValue(Attributes.ATTACK_SPEED) * 20.0);
        }

        public float getAttackCooldownProgress(LivingEntity entity, float baseTime) {
            return Mth.clamp((float)(((float)((LivingEntityMixin)entity).getLastAttackedTicks() + baseTime) / this.getAttackCooldownProgressPerTick(entity)), (float)0.0f, (float)1.0f);
        }

        private void stopHitting(PlayerEngineController mod) {
            if (this.wasHitting) {
                if (!this.wasReleased) {
                    mod.getExtraBaritoneSettings().setInteractionPaused(false);
                    this.wasReleased = true;
                }
                this.wasHitting = false;
            }
        }

        @Override
        protected void onStart() {
            this.controller.getBaritone().getCustomGoalProcess().onLostControl();
        }

        @Override
        protected Task onTick() {
            PlayerEngineController mod = this.controller;
            if (!mod.getEntityTracker().entityFound(EnderDragon.class)) {
                this.setDebugState("No dragon found.");
                return null;
            }
            List<EnderDragon> dragons = mod.getEntityTracker().getTrackedEntities(EnderDragon.class);
            if (!dragons.isEmpty()) {
                for (EnderDragon dragon : dragons) {
                    DragonPhaseInstance dragonPhase = dragon.getPhaseManager().getCurrentPhase();
                    boolean perchingOrGettingReady = dragonPhase.getPhase() == EnderDragonPhase.LANDING || dragonPhase.isSitting();
                    switch (this.mode.ordinal()) {
                        case 1: {
                            if (!perchingOrGettingReady) {
                                Debug.logMessage("Dragon no longer perching.");
                                mod.getBaritone().getCustomGoalProcess().onLostControl();
                                this.mode = Mode.WAITING_FOR_PERCH;
                                break;
                            }
                            EnderDragonPart head = dragon.head;
                            if (head.closerThan((Entity)mod.getPlayer(), 7.5) && dragon.dragonDeathTime <= 1) {
                                AbstractKillEntityTask.equipWeapon(mod);
                                Vec3 targetLookPos = head.position().add(0.0, 3.0, 0.0);
                                Rotation targetRotation = RotationUtils.calcRotationFromVec3d(mod.getBaritone().getEntityContext().headPos(), targetLookPos, mod.getBaritone().getEntityContext().entityRotations());
                                mod.getBaritone().getLookBehavior().updateTarget(targetRotation, true);
                                mod.getBaritone().getInputOverrideHandler().setInputForceState(Input.MOVE_FORWARD, true);
                                this.hit(mod);
                            } else {
                                this.stopHitting(mod);
                            }
                            if (!mod.getBaritone().getCustomGoalProcess().isActive() && KillEnderDragonTask.this.exitPortalTop != null) {
                                int bottomYDelta = -3;
                                BlockPos closest = null;
                                double closestDist = Double.POSITIVE_INFINITY;
                                for (int dx = -2; dx <= 2; ++dx) {
                                    for (int dz = -2; dz <= 2; ++dz) {
                                        BlockPos toCheck;
                                        double distSq;
                                        if (Math.abs(dx) == 2 && Math.abs(dz) == 2 || !((distSq = BlockPosVer.getSquaredDistance(toCheck = KillEnderDragonTask.this.exitPortalTop.offset(dx, bottomYDelta, dz), (Position)head.position())) < closestDist)) continue;
                                        closest = toCheck;
                                        closestDist = distSq;
                                    }
                                }
                                if (closest != null) {
                                    mod.getBaritone().getCustomGoalProcess().setGoalAndPath(new GoalGetToBlock(closest));
                                }
                            }
                            this.setDebugState("Railing on dragon");
                            break;
                        }
                        case 0: {
                            this.stopHitting(mod);
                            if (perchingOrGettingReady) {
                                mod.getBaritone().getCustomGoalProcess().onLostControl();
                                Debug.logMessage("Dragon perching detected. Dabar duosiu \u012f snuki.");
                                this.mode = Mode.RAILING;
                                break;
                            }
                            if (this.randomWanderPos != null && WorldHelper.inRangeXZ((Entity)mod.getPlayer(), this.randomWanderPos, 2.0)) {
                                this.randomWanderPos = null;
                            }
                            if (this.randomWanderPos != null && this.randomWanderChangeTimeout.elapsed()) {
                                this.randomWanderPos = null;
                                Debug.logMessage("Reset wander pos after timeout, oof");
                            }
                            if (this.randomWanderPos == null) {
                                this.randomWanderPos = this.getRandomWanderPos(mod);
                                this.randomWanderChangeTimeout.reset();
                                mod.getBaritone().getCustomGoalProcess().onLostControl();
                            }
                            if (!mod.getBaritone().getCustomGoalProcess().isActive()) {
                                mod.getBaritone().getCustomGoalProcess().setGoalAndPath(new GoalGetToBlock(this.randomWanderPos));
                            }
                            this.setDebugState("Waiting for perch");
                        }
                    }
                }
            }
            return null;
        }

        @Override
        protected void onStop(Task interruptTask) {
            PlayerEngineController mod = this.controller;
            mod.getBaritone().getCustomGoalProcess().onLostControl();
            mod.getBaritone().getInputOverrideHandler().setInputForceState(Input.MOVE_FORWARD, false);
            mod.getExtraBaritoneSettings().setInteractionPaused(false);
        }

        @Override
        protected boolean isEqual(Task other) {
            return other instanceof PunkEnderDragonTask;
        }

        @Override
        protected String toDebugString() {
            return "Punking the dragon";
        }

        private BlockPos getRandomWanderPos(PlayerEngineController mod) {
            double RADIUS_RANGE = 45.0;
            double MIN_RADIUS = 7.0;
            BlockPos pos = null;
            int allowed = 5000;
            while (pos == null) {
                int z;
                double angle;
                if (allowed-- < 0) {
                    Debug.logWarning("Failed to find random solid ground in end, this may lead to problems.");
                    return null;
                }
                double radius = MIN_RADIUS + (RADIUS_RANGE - MIN_RADIUS) * Math.random();
                int x = (int)(radius * Math.cos(angle = Math.PI * 2 * Math.random()));
                int y = WorldHelper.getGroundHeight(mod, x, z = (int)(radius * Math.sin(angle)));
                if (y == -1) continue;
                BlockPos check = new BlockPos(x, y, z);
                if (mod.getWorld().getBlockState(check).getBlock() != Blocks.END_STONE) continue;
                pos = check.above();
            }
            return pos;
        }
    }

    private static enum Mode {
        WAITING_FOR_PERCH,
        RAILING;

    }
}

