/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.tasks;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.prioritycalculators.PriorityCalculator;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.tasks.PriorityTask;
import com.player2.playerengine.util.Pair;
import java.util.function.Function;

public class ActionPriorityTask
extends PriorityTask {
    private final TaskAndPriorityProvider taskAndPriorityProvider;
    private Task lastTask = null;

    public ActionPriorityTask(TaskProvider taskProvider, PriorityCalculator priorityCalculator) {
        this(taskProvider, priorityCalculator, a -> true, false, true, false);
    }

    public ActionPriorityTask(TaskProvider taskProvider, PriorityCalculator priorityCalculator, Function<PlayerEngineController, Boolean> canCall) {
        this((PlayerEngineController mod) -> new Pair<Task, Double>(taskProvider.getTask(mod), priorityCalculator.getPriority()), canCall);
    }

    public ActionPriorityTask(TaskAndPriorityProvider taskAndPriorityProvider) {
        this(taskAndPriorityProvider, (PlayerEngineController a) -> true);
    }

    public ActionPriorityTask(TaskAndPriorityProvider taskAndPriorityProvider, Function<PlayerEngineController, Boolean> canCall) {
        this(taskAndPriorityProvider, canCall, false, true, false);
    }

    public ActionPriorityTask(TaskProvider taskProvider, PriorityCalculator priorityCalculator, Function<PlayerEngineController, Boolean> canCall, boolean shouldForce, boolean canCache, boolean bypassForceCooldown) {
        this(mod -> new Pair<Task, Double>(taskProvider.getTask(mod), priorityCalculator.getPriority()), canCall, shouldForce, canCache, bypassForceCooldown);
    }

    public ActionPriorityTask(TaskAndPriorityProvider taskAndPriorityProvider, Function<PlayerEngineController, Boolean> canCall, boolean shouldForce, boolean canCache, boolean bypassForceCooldown) {
        super(canCall, shouldForce, canCache, bypassForceCooldown);
        this.taskAndPriorityProvider = taskAndPriorityProvider;
    }

    @Override
    public Task getTask(PlayerEngineController mod) {
        this.lastTask = this.getTaskAndPriority(mod).getLeft();
        return this.lastTask;
    }

    @Override
    public String getDebugString() {
        return "Performing an action: " + String.valueOf(this.lastTask);
    }

    @Override
    protected double getPriority(PlayerEngineController mod) {
        return this.getTaskAndPriority(mod).getRight();
    }

    private Pair<Task, Double> getTaskAndPriority(PlayerEngineController mod) {
        Pair<Task, Double> pair = this.taskAndPriorityProvider.getTaskAndPriority(mod);
        if (pair == null) {
            pair = new Pair<Object, Double>(null, 0.0);
        }
        if (pair.getRight() <= 0.0 || pair.getLeft() == null) {
            pair.setLeft(null);
            pair.setRight(Double.NEGATIVE_INFINITY);
        }
        return pair;
    }

    public static interface TaskProvider {
        public Task getTask(PlayerEngineController var1);
    }

    public static interface TaskAndPriorityProvider {
        public Pair<Task, Double> getTaskAndPriority(PlayerEngineController var1);
    }
}

