/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util;

import com.player2.playerengine.util.Debug;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public enum MiningRequirement implements Comparable<MiningRequirement>
{
    HAND(Items.AIR),
    WOOD(Items.WOODEN_PICKAXE),
    STONE(Items.STONE_PICKAXE),
    IRON(Items.IRON_PICKAXE),
    DIAMOND(Items.DIAMOND_PICKAXE);

    private final Item minPickaxe;

    private MiningRequirement(Item minPickaxe) {
        this.minPickaxe = minPickaxe;
    }

    public static MiningRequirement getMinimumRequirementForBlock(Block block) {
        if (block.defaultBlockState().requiresCorrectToolForDrops()) {
            for (MiningRequirement req : MiningRequirement.values()) {
                Item pick;
                if (req == HAND || !(pick = req.getMinimumPickaxe()).isCorrectToolForDrops(new ItemStack((ItemLike)pick), block.defaultBlockState())) continue;
                return req;
            }
            Debug.logWarning("Failed to find ANY effective tool against: " + String.valueOf(block) + ". I assume netherite is not required anywhere, so something else probably went wrong.");
            return DIAMOND;
        }
        return HAND;
    }

    public Item getMinimumPickaxe() {
        return this.minPickaxe;
    }
}

