/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.entity;

import net.minecraft.class_1267;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_2487;
import net.minecraft.class_4174;

public class LivingEntityHungerManager {
    private int foodLevel = 20;
    private float foodSaturationLevel = 20.0f;
    private float exhaustion;
    private int foodTickTimer;
    private int prevFoodLevel = 20;

    public void add(int food, float saturationModifier) {
        this.foodLevel = Math.min(food + this.foodLevel, 20);
        this.foodSaturationLevel = Math.min(this.foodSaturationLevel + (float)food * saturationModifier * 2.0f, (float)this.foodLevel);
    }

    public void eat(class_1792 item, class_1799 stack) {
        if (item.method_19263()) {
            class_4174 foodComponent = item.method_19264();
            this.add(foodComponent.method_19230(), foodComponent.method_19231());
        }
    }

    public void update(class_1309 player) {
        boolean bl;
        class_1267 difficulty = player.method_37908().method_8407();
        this.prevFoodLevel = this.foodLevel;
        if (this.exhaustion > 4.0f) {
            this.exhaustion -= 4.0f;
            if (this.foodSaturationLevel > 0.0f) {
                this.foodSaturationLevel = Math.max(this.foodSaturationLevel - 1.0f, 0.0f);
            } else if (difficulty != class_1267.field_5801) {
                this.foodLevel = Math.max(this.foodLevel - 1, 0);
            }
        }
        if ((bl = player.method_37908().method_8450().method_8355(class_1928.field_19395)) && this.foodSaturationLevel > 0.0f && this.canFoodHeal(player) && this.foodLevel >= 20) {
            ++this.foodTickTimer;
            if (this.foodTickTimer >= 10) {
                float f = Math.min(this.foodSaturationLevel, 6.0f);
                player.method_6025(f / 6.0f);
                this.addExhaustion(f);
                this.foodTickTimer = 0;
            }
        } else if (bl && this.foodLevel >= 18 && this.canFoodHeal(player)) {
            ++this.foodTickTimer;
            if (this.foodTickTimer >= 80) {
                player.method_6025(1.0f);
                this.addExhaustion(6.0f);
                this.foodTickTimer = 0;
            }
        } else if (this.foodLevel <= 0) {
            ++this.foodTickTimer;
            if (this.foodTickTimer >= 80) {
                if (player.method_6032() > 10.0f || difficulty == class_1267.field_5807 || player.method_6032() > 1.0f && difficulty == class_1267.field_5802) {
                    player.method_5643(player.method_48923().method_48825(), 1.0f);
                }
                this.foodTickTimer = 0;
            }
        } else {
            this.foodTickTimer = 0;
        }
    }

    public void readNbt(class_2487 nbt) {
        if (nbt.method_10573("foodLevel", 99)) {
            this.foodLevel = nbt.method_10550("foodLevel");
            this.foodTickTimer = nbt.method_10550("foodTickTimer");
            this.foodSaturationLevel = nbt.method_10583("foodSaturationLevel");
            this.exhaustion = nbt.method_10583("foodExhaustionLevel");
        }
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10569("foodLevel", this.foodLevel);
        nbt.method_10569("foodTickTimer", this.foodTickTimer);
        nbt.method_10548("foodSaturationLevel", this.foodSaturationLevel);
        nbt.method_10548("foodExhaustionLevel", this.exhaustion);
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public int getPrevFoodLevel() {
        return this.prevFoodLevel;
    }

    public boolean isNotFull() {
        return this.foodLevel < 20;
    }

    public void addExhaustion(float exhaustion) {
        this.exhaustion = Math.min(this.exhaustion + exhaustion, 40.0f);
    }

    public float getExhaustion() {
        return this.exhaustion;
    }

    public float getSaturationLevel() {
        return this.foodSaturationLevel;
    }

    public void setFoodLevel(int foodLevel) {
        this.foodLevel = foodLevel;
    }

    public void setSaturationLevel(float saturationLevel) {
        this.foodSaturationLevel = saturationLevel;
    }

    public void setExhaustion(float exhaustion) {
        this.exhaustion = exhaustion;
    }

    public boolean canFoodHeal(class_1309 entity) {
        return entity.method_6032() > 0.0f && entity.method_6032() < entity.method_6063();
    }
}

