/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.pathing.goals;

import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.utils.SettingsUtil;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class GoalStrictDirection
implements Goal {
    public final int x;
    public final int y;
    public final int z;
    public final int dx;
    public final int dz;

    public GoalStrictDirection(class_2338 origin, class_2350 direction) {
        this.x = origin.method_10263();
        this.y = origin.method_10264();
        this.z = origin.method_10260();
        this.dx = direction.method_10148();
        this.dz = direction.method_10165();
        if (this.dx == 0 && this.dz == 0) {
            throw new IllegalArgumentException(String.valueOf(direction));
        }
    }

    @Override
    public boolean isInGoal(int x, int y, int z) {
        return false;
    }

    @Override
    public double heuristic(int x, int y, int z) {
        int distanceFromStartInDesiredDirection = (x - this.x) * this.dx + (z - this.z) * this.dz;
        int distanceFromStartInIncorrectDirection = Math.abs((x - this.x) * this.dz) + Math.abs((z - this.z) * this.dx);
        int verticalDistanceFromStart = Math.abs(y - this.y);
        double heuristic = -distanceFromStartInDesiredDirection * 100;
        return (heuristic += (double)(distanceFromStartInIncorrectDirection * 1000)) + (double)(verticalDistanceFromStart * 1000);
    }

    @Override
    public double heuristic() {
        return Double.NEGATIVE_INFINITY;
    }

    public String toString() {
        return String.format("GoalStrictDirection{x=%s, y=%s, z=%s, dx=%s, dz=%s}", SettingsUtil.maybeCensor(this.x), SettingsUtil.maybeCensor(this.y), SettingsUtil.maybeCensor(this.z), SettingsUtil.maybeCensor(this.dx), SettingsUtil.maybeCensor(this.dz));
    }
}

