/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.utils;

import com.player2.playerengine.automaton.api.utils.BlockUtils;
import com.player2.playerengine.automaton.api.utils.accessor.IItemStack;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_39;
import net.minecraft.class_47;
import net.minecraft.class_8567;

public final class BlockOptionalMeta {
    private final class_2248 block;
    private final Set<class_2680> blockstates;
    private final IntSet stateHashes;
    private final IntSet stackHashes;
    private static final Pattern pattern = Pattern.compile("^(.+?)(?::(\\d+))?$");
    private static final Map<class_2248, List<class_1792>> drops = new HashMap<class_2248, List<class_1792>>();

    public BlockOptionalMeta(class_3218 world, class_2248 block) {
        this.block = block;
        this.blockstates = BlockOptionalMeta.getStates(block);
        this.stateHashes = BlockOptionalMeta.getStateHashes(this.blockstates);
        this.stackHashes = BlockOptionalMeta.getStackHashes(world, this.blockstates);
    }

    public BlockOptionalMeta(class_3218 world, String selector) {
        Matcher matcher = pattern.matcher(selector);
        if (!matcher.find()) {
            throw new IllegalArgumentException("invalid block selector");
        }
        MatchResult matchResult = matcher.toMatchResult();
        this.block = BlockUtils.stringToBlockRequired(matchResult.group(1));
        this.blockstates = BlockOptionalMeta.getStates(this.block);
        this.stateHashes = BlockOptionalMeta.getStateHashes(this.blockstates);
        this.stackHashes = BlockOptionalMeta.getStackHashes(world, this.blockstates);
    }

    private static Set<class_2680> getStates(class_2248 block) {
        return new HashSet<class_2680>((Collection<class_2680>)block.method_9595().method_11662());
    }

    private static IntSet getStateHashes(Set<class_2680> blockstates) {
        return (IntSet)blockstates.stream().map(Object::hashCode).collect(Collectors.toCollection(IntOpenHashSet::new));
    }

    private static IntSet getStackHashes(class_3218 world, Set<class_2680> blockstates) {
        return (IntSet)blockstates.stream().flatMap(state -> BlockOptionalMeta.drops(world, state.method_26204()).stream().map(item -> new class_1799((class_1935)item, 1))).map(stack -> ((IItemStack)stack).getBaritoneHash()).collect(Collectors.toCollection(IntOpenHashSet::new));
    }

    public class_2248 getBlock() {
        return this.block;
    }

    public boolean matches(class_2248 block) {
        return block == this.block;
    }

    public boolean matches(class_2680 blockstate) {
        class_2248 block = blockstate.method_26204();
        return block == this.block && this.stateHashes.contains(blockstate.hashCode());
    }

    public boolean matches(class_1799 stack) {
        int hash = ((IItemStack)stack).getBaritoneHash();
        return this.stackHashes.contains(hash -= stack.method_7919());
    }

    public String toString() {
        return String.format("BlockOptionalMeta{block=%s}", this.block);
    }

    public class_2680 getAnyBlockState() {
        return this.blockstates.size() > 0 ? this.blockstates.iterator().next() : null;
    }

    private static synchronized List<class_1792> drops(class_3218 world, class_2248 b) {
        return drops.computeIfAbsent(b, block -> {
            class_2960 lootTableLocation = block.method_26162();
            if (lootTableLocation == class_39.field_844) {
                return Collections.emptyList();
            }
            ArrayList items = new ArrayList();
            world.method_8503().method_3857().getLootTable(lootTableLocation).method_320(new class_47.class_48(new class_8567.class_8568(world).method_51874(class_181.field_24424, (Object)class_243.method_24954((class_2382)class_2338.field_10980)).method_51874(class_181.field_1229, (Object)class_1799.field_8037).method_51877(class_181.field_1228, null).method_51874(class_181.field_1224, (Object)block.method_9564()).method_51875(class_173.field_1172)).method_304(world.method_8412()).method_309(null), stack -> items.add(stack.method_7909()));
            return items;
        });
    }
}

