/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.behavior;

import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.behavior.Behavior;
import com.player2.playerengine.automaton.utils.ToolSet;
import java.util.ArrayList;
import java.util.OptionalInt;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1831;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_6862;

public final class InventoryBehavior
extends Behavior {
    public InventoryBehavior(Baritone baritone) {
        super(baritone);
    }

    @Override
    public void onTickServer() {
        class_1309 class_13092;
        if (this.baritone.settings().allowInventory.get().booleanValue() && (class_13092 = this.ctx.entity()) instanceof IInventoryProvider) {
            int pick;
            IInventoryProvider player = (IInventoryProvider)class_13092;
            if (this.firstValidThrowaway(player.getLivingInventory()) >= 9) {
                this.swapWithHotBar(this.firstValidThrowaway(player.getLivingInventory()), 8, player.getLivingInventory());
            }
            if ((pick = this.bestToolAgainst(class_2246.field_10340, class_1810.class)) >= 9) {
                for (int i = 0; i < 9; ++i) {
                    if (player.getLivingInventory().method_5438(i).method_7909() == class_1802.field_8550) continue;
                    this.swapWithHotBar(pick, i, player.getLivingInventory());
                    break;
                }
            }
        }
    }

    public void attemptToPutOnHotbar(int inMainInvy, Predicate<Integer> disallowedHotbar, LivingEntityInventory inventory) {
        OptionalInt destination = this.getTempHotbarSlot(disallowedHotbar);
        if (destination.isPresent()) {
            this.swapWithHotBar(inMainInvy, destination.getAsInt(), inventory);
        }
    }

    public OptionalInt getTempHotbarSlot(Predicate<Integer> disallowedHotbar) {
        LivingEntityInventory inventory = this.ctx.inventory();
        if (inventory == null) {
            return OptionalInt.empty();
        }
        ArrayList<Integer> candidates = new ArrayList<Integer>();
        for (int i = 1; i < 8; ++i) {
            if (!((class_1799)inventory.main.get(i)).method_7960() || disallowedHotbar.test(i)) continue;
            candidates.add(i);
        }
        if (candidates.isEmpty()) {
            for (int ix = 1; ix < 8; ++ix) {
                if (disallowedHotbar.test(ix)) continue;
                candidates.add(ix);
            }
        }
        return candidates.isEmpty() ? OptionalInt.empty() : OptionalInt.of((Integer)candidates.get(new Random().nextInt(candidates.size())));
    }

    private void swapWithHotBar(int inInventory, int inHotbar, LivingEntityInventory inventory) {
        class_1799 h = inventory.method_5438(inHotbar);
        inventory.method_5447(inHotbar, inventory.method_5438(inInventory));
        inventory.method_5447(inInventory, h);
    }

    private int firstValidThrowaway(LivingEntityInventory inventory) {
        class_2371<class_1799> invy = inventory.main;
        for (int i = 0; i < invy.size(); ++i) {
            if (!this.baritone.settings().acceptableThrowawayItems.get().contains(((class_1799)invy.get(i)).method_7909())) continue;
            return i;
        }
        return -1;
    }

    private int bestToolAgainst(class_2248 against, Class<? extends class_1831> cla$$) {
        class_2371<class_1799> invy = this.ctx.inventory().main;
        int bestInd = -1;
        double bestSpeed = -1.0;
        for (int i = 0; i < invy.size(); ++i) {
            double speed;
            class_1799 stack = (class_1799)invy.get(i);
            if (stack.method_7960() || this.baritone.settings().itemSaver.get().booleanValue() && stack.method_7919() >= stack.method_7936() && stack.method_7936() > 1 || !cla$$.isInstance(stack.method_7909()) || !((speed = ToolSet.calculateSpeedVsBlock(stack, against.method_9564())) > bestSpeed)) continue;
            bestSpeed = speed;
            bestInd = i;
        }
        return bestInd;
    }

    public boolean hasGenericThrowaway() {
        return this.throwaway(false, stack -> this.baritone.settings().acceptableThrowawayItems.get().contains(stack.method_7909()));
    }

    public boolean selectThrowawayForLocation(boolean select, int x, int y, int z) {
        class_2680 maybe = this.baritone.getBuilderProcess().placeAt(x, y, z, this.baritone.bsi.get0(x, y, z));
        if (maybe != null && this.throwaway(select, stack -> stack.method_7909() instanceof class_1747 && maybe.equals(((class_1747)stack.method_7909()).method_7711().method_9605(new class_1750(new class_1838((class_1937)this.ctx.world(), null, class_1268.field_5808, (class_1799)stack, new class_3965(new class_243(this.ctx.entity().method_23317(), this.ctx.entity().method_23318(), this.ctx.entity().method_23321()), class_2350.field_11036, (class_2338)this.ctx.feetPos(), false)){

            public boolean method_8046() {
                return false;
            }
        }))))) {
            return true;
        }
        return maybe != null && this.throwaway(select, stack -> stack.method_7909() instanceof class_1747 && ((class_1747)stack.method_7909()).method_7711().equals(maybe.method_26204())) ? true : this.throwaway(select, stack -> this.baritone.settings().acceptableThrowawayItems.get().contains(stack.method_7909()));
    }

    public boolean throwaway(boolean select, Predicate<? super class_1799> desired) {
        class_1799 item;
        class_1309 class_13092 = this.ctx.entity();
        if (!(class_13092 instanceof IInventoryProvider)) {
            return false;
        }
        IInventoryProvider p = (IInventoryProvider)class_13092;
        class_2371<class_1799> var7 = p.getLivingInventory().main;
        for (int i = 0; i < 9; ++i) {
            item = (class_1799)var7.get(i);
            if (!desired.test((class_1799)item)) continue;
            if (select) {
                p.getLivingInventory().selectedSlot = i;
            }
            return true;
        }
        if (desired.test((class_1799)((class_1799)p.getLivingInventory().offHand.get(0)))) {
            for (int ix = 0; ix < 9; ++ix) {
                item = (class_1799)var7.get(ix);
                if (!item.method_7960() && !(item.method_7909() instanceof class_1810)) continue;
                if (select) {
                    p.getLivingInventory().selectedSlot = ix;
                }
                return true;
            }
        }
        return false;
    }

    public static int getSlotWithStack(LivingEntityInventory inv, class_6862<class_1792> tag) {
        for (int i = 0; i < inv.main.size(); ++i) {
            if (((class_1799)inv.main.get(i)).method_7960() || !((class_1799)inv.main.get(i)).method_31573(tag)) continue;
            return i;
        }
        return -1;
    }
}

