/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.movement;

import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.Settings;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.api.pathing.movement.ActionCosts;
import com.player2.playerengine.automaton.api.pathing.movement.MovementStatus;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.RayTraceUtils;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.VecUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementState;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.automaton.utils.ToolSet;
import java.util.Optional;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_2189;
import net.minecraft.class_2190;
import net.minecraft.class_2211;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2334;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2384;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2482;
import net.minecraft.class_2484;
import net.minecraft.class_2488;
import net.minecraft.class_2506;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2553;
import net.minecraft.class_2577;
import net.minecraft.class_2667;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3621;
import net.minecraft.class_3736;
import net.minecraft.class_3965;
import net.minecraft.class_4770;

public interface MovementHelper
extends ActionCosts {
    public static boolean avoidBreaking(BlockStateInterface bsi, int x, int y, int z, class_2680 state, Settings settings) {
        class_2248 b = state.method_26204();
        return b == class_2246.field_10295 || b instanceof class_2384 || MovementHelper.avoidAdjacentBreaking(bsi, x, y + 1, z, true, settings) || MovementHelper.avoidAdjacentBreaking(bsi, x + 1, y, z, false, settings) || MovementHelper.avoidAdjacentBreaking(bsi, x - 1, y, z, false, settings) || MovementHelper.avoidAdjacentBreaking(bsi, x, y, z + 1, false, settings) || MovementHelper.avoidAdjacentBreaking(bsi, x, y, z - 1, false, settings);
    }

    public static boolean avoidAdjacentBreaking(BlockStateInterface bsi, int x, int y, int z, boolean directlyAbove, Settings settings) {
        class_2680 state = bsi.get0(x, y, z);
        class_2248 block = state.method_26204();
        return !directlyAbove && block instanceof class_2346 && settings.avoidUpdatingFallingBlocks.get() != false && class_2346.method_10128((class_2680)bsi.get0(x, y - 1, z)) ? true : !state.method_26227().method_15769();
    }

    public static boolean canWalkThrough(IEntityContext ctx, BetterBlockPos pos) {
        return MovementHelper.canWalkThrough(new BlockStateInterface(ctx), pos.x, pos.y, pos.z, ctx.baritone().settings());
    }

    public static boolean canWalkThrough(BlockStateInterface bsi, int x, int y, int z, Settings settings) {
        return MovementHelper.canWalkThrough(bsi, x, y, z, bsi.get0(x, y, z), settings);
    }

    public static boolean canWalkThrough(BlockStateInterface bsi, int x, int y, int z, class_2680 state, Settings settings) {
        class_2248 block = state.method_26204();
        if (block instanceof class_2189) {
            return true;
        }
        if (!(block instanceof class_4770 || block == class_2246.field_10589 || block == class_2246.field_10343 || block == class_2246.field_10027 || block == class_2246.field_10302 || block instanceof class_2190 || block == class_2246.field_10422 || block instanceof class_2480 || block instanceof class_2482 || block instanceof class_2533 || block == class_2246.field_21211 || block == class_2246.field_28678 || block == class_2246.field_28679 || block == class_2246.field_28411 || block == class_2246.field_28675 || block == class_2246.field_28676 || block == class_2246.field_10455)) {
            if (settings.blocksToAvoid.get().contains(state.method_26204())) {
                return false;
            }
            if (block instanceof class_2323 || block instanceof class_2349) {
                return block instanceof class_2349 || class_2323.method_24796((class_2680)state);
            }
            if (block instanceof class_2577) {
                return MovementHelper.canWalkOn(bsi, x, y - 1, z, settings);
            }
            if (block instanceof class_2488) {
                if (!bsi.worldContainsLoadedChunk(x, z)) {
                    return true;
                }
                return (Integer)state.method_11654((class_2769)class_2488.field_11518) >= 3 ? false : MovementHelper.canWalkOn(bsi, x, y - 1, z, settings);
            }
            if (MovementHelper.isFlowing(x, y, z, state, bsi)) {
                return false;
            }
            class_3610 fluidState = state.method_26227();
            if (!(fluidState.method_15772() instanceof class_3621)) {
                return state.method_26171(bsi.access, class_2338.field_10980, class_10.field_50);
            }
            if (settings.assumeWalkOnWater.get().booleanValue()) {
                return false;
            }
            class_2680 up = bsi.get0(x, y + 1, z);
            return (settings.allowSwimming.get() != false || up.method_26227().method_15769()) && !(up.method_26204() instanceof class_2553);
        }
        return false;
    }

    public static boolean fullyPassable(CalculationContext context, int x, int y, int z) {
        return MovementHelper.fullyPassable(context.bsi.access, (class_2338)context.bsi.isPassableBlockPos.method_10103(x, y, z), context.bsi.get0(x, y, z));
    }

    public static boolean fullyPassable(IEntityContext ctx, class_2338 pos) {
        return MovementHelper.fullyPassable((class_1922)ctx.world(), pos, ctx.world().method_8320(pos));
    }

    public static boolean fullyPassable(class_1922 access, class_2338 pos, class_2680 state) {
        class_2248 block = state.method_26204();
        if (block instanceof class_2189) {
            return true;
        }
        return !(block instanceof class_4770) && block != class_2246.field_10589 && block != class_2246.field_10343 && block != class_2246.field_10597 && block != class_2246.field_9983 && block != class_2246.field_10302 && !(block instanceof class_2323) && !(block instanceof class_2349) && !(block instanceof class_2488) && state.method_26227().method_15769() && !(block instanceof class_2533) && !(block instanceof class_2334) && !(block instanceof class_2484) && !(block instanceof class_2480) ? state.method_26171(access, pos, class_10.field_50) : false;
    }

    public static boolean isReplaceable(int x, int y, int z, class_2680 state, BlockStateInterface bsi) {
        class_2248 block = state.method_26204();
        if (block instanceof class_2189) {
            return true;
        }
        if (block instanceof class_2488) {
            return !bsi.worldContainsLoadedChunk(x, z) ? true : (Integer)state.method_11654((class_2769)class_2488.field_11518) == 1;
        }
        return block != class_2246.field_10313 && block != class_2246.field_10214 ? state.method_45474() : true;
    }

    @Deprecated
    public static boolean isReplacable(int x, int y, int z, class_2680 state, BlockStateInterface bsi) {
        return MovementHelper.isReplaceable(x, y, z, state, bsi);
    }

    public static boolean isDoorPassable(IEntityContext ctx, class_2338 doorPos, class_2338 playerPos) {
        if (playerPos.equals((Object)doorPos)) {
            return false;
        }
        class_2680 state = BlockStateInterface.get(ctx, doorPos);
        return !(state.method_26204() instanceof class_2323) ? true : MovementHelper.isHorizontalBlockPassable(doorPos, state, playerPos, class_2323.field_10945);
    }

    public static boolean isGatePassable(IEntityContext ctx, class_2338 gatePos, class_2338 playerPos) {
        if (playerPos.equals((Object)gatePos)) {
            return false;
        }
        class_2680 state = BlockStateInterface.get(ctx, gatePos);
        return !(state.method_26204() instanceof class_2349) ? true : (Boolean)state.method_11654((class_2769)class_2349.field_11026);
    }

    public static boolean isHorizontalBlockPassable(class_2338 blockPos, class_2680 blockState, class_2338 playerPos, class_2746 propertyOpen) {
        class_2350.class_2351 playerFacing;
        if (playerPos.equals((Object)blockPos)) {
            return false;
        }
        class_2350.class_2351 facing = ((class_2350)blockState.method_11654((class_2769)class_2383.field_11177)).method_10166();
        boolean open = (Boolean)blockState.method_11654((class_2769)propertyOpen);
        if (!playerPos.method_10095().equals((Object)blockPos) && !playerPos.method_10072().equals((Object)blockPos)) {
            if (!playerPos.method_10078().equals((Object)blockPos) && !playerPos.method_10067().equals((Object)blockPos)) {
                return true;
            }
            playerFacing = class_2350.class_2351.field_11048;
        } else {
            playerFacing = class_2350.class_2351.field_11051;
        }
        return facing == playerFacing == open;
    }

    public static boolean avoidWalkingInto(class_2680 state) {
        class_2248 block = state.method_26204();
        return !state.method_26227().method_15769() || block == class_2246.field_10092 || block == class_2246.field_10029 || block instanceof class_4770 || block == class_2246.field_10027 || block == class_2246.field_10343 || block == class_2246.field_10422;
    }

    public static boolean canWalkOn(BlockStateInterface bsi, int x, int y, int z, class_2680 state, Settings settings) {
        class_2248 block = state.method_26204();
        if (block instanceof class_2189 || block == class_2246.field_10092 || block == class_2246.field_10422 || block == class_2246.field_21211) {
            return false;
        }
        if (MovementHelper.isBlockNormalCube(state)) {
            return true;
        }
        if (state.method_26164(class_3481.field_22414)) {
            return true;
        }
        if (block == class_2246.field_10362 || block == class_2246.field_10194) {
            return true;
        }
        if (block == class_2246.field_10443 || block == class_2246.field_10034 || block == class_2246.field_10380) {
            return true;
        }
        if (MovementHelper.isWater(state)) {
            class_2680 upState = bsi.get0(x, y + 1, z);
            class_2248 up = upState.method_26204();
            if (up != class_2246.field_10588 && !(up instanceof class_2577)) {
                return !MovementHelper.isFlowing(x, y, z, state, bsi) && upState.method_26227().method_15772() != class_3612.field_15909 ? MovementHelper.isWater(upState) ^ settings.assumeWalkOnWater.get() : MovementHelper.isWater(upState) && settings.assumeWalkOnWater.get() == false;
            }
            return true;
        }
        if (settings.assumeWalkOnLava.get().booleanValue() && MovementHelper.isLava(state) && !MovementHelper.isFlowing(x, y, z, state, bsi)) {
            return true;
        }
        if (block == class_2246.field_10033 || block instanceof class_2506) {
            return true;
        }
        if (!(block instanceof class_2482)) {
            return block instanceof class_2510;
        }
        return !settings.allowWalkOnBottomSlab.get().booleanValue() ? state.method_11654((class_2769)class_2482.field_11501) != class_2771.field_12681 : true;
    }

    public static boolean canWalkOn(IEntityContext ctx, BetterBlockPos pos, class_2680 state) {
        return MovementHelper.canWalkOn(new BlockStateInterface(ctx), pos.x, pos.y, pos.z, state, ctx.baritone().settings());
    }

    public static boolean canWalkOn(IEntityContext ctx, class_2338 pos) {
        return MovementHelper.canWalkOn(new BlockStateInterface(ctx), pos.method_10263(), pos.method_10264(), pos.method_10260(), ctx.baritone().settings());
    }

    public static boolean canWalkOn(IEntityContext ctx, BetterBlockPos pos) {
        return MovementHelper.canWalkOn(new BlockStateInterface(ctx), pos.x, pos.y, pos.z, ctx.baritone().settings());
    }

    public static boolean canWalkOn(BlockStateInterface bsi, int x, int y, int z, Settings settings) {
        return MovementHelper.canWalkOn(bsi, x, y, z, bsi.get0(x, y, z), settings);
    }

    public static boolean canPlaceAgainst(BlockStateInterface bsi, int x, int y, int z) {
        return MovementHelper.canPlaceAgainst(bsi, x, y, z, bsi.get0(x, y, z));
    }

    public static boolean canPlaceAgainst(BlockStateInterface bsi, class_2338 pos) {
        return MovementHelper.canPlaceAgainst(bsi, pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static boolean canPlaceAgainst(IEntityContext ctx, class_2338 pos) {
        return MovementHelper.canPlaceAgainst(new BlockStateInterface(ctx), pos);
    }

    public static boolean canPlaceAgainst(BlockStateInterface bsi, int x, int y, int z, class_2680 state) {
        return MovementHelper.isBlockNormalCube(state) || state.method_26204() == class_2246.field_10033 || state.method_26204() instanceof class_2506;
    }

    public static double getMiningDurationTicks(CalculationContext context, int x, int y, int z, boolean includeFalling) {
        return MovementHelper.getMiningDurationTicks(context, x, y, z, context.get(x, y, z), includeFalling);
    }

    public static double getMiningDurationTicks(CalculationContext context, int x, int y, int z, class_2680 state, boolean includeFalling) {
        if (!MovementHelper.canWalkThrough(context.bsi, x, y, z, state, context.baritone.settings())) {
            class_2680 above;
            if (!state.method_26227().method_15769()) {
                return 1000000.0;
            }
            double mult = context.breakCostMultiplierAt(x, y, z, state);
            if (mult >= 1000000.0) {
                return 1000000.0;
            }
            if (MovementHelper.avoidBreaking(context.bsi, x, y, z, state, context.baritone.settings())) {
                return 1000000.0;
            }
            if (context.toolSet == null) {
                return 1000000.0;
            }
            double strVsBlock = context.toolSet.getStrVsBlock(state);
            if (strVsBlock <= 0.0) {
                return 1000000.0;
            }
            double result = 1.0 / strVsBlock;
            result += context.breakBlockAdditionalCost;
            result *= mult;
            if (includeFalling && (above = context.get(x, y + 1, z)).method_26204() instanceof class_2346) {
                result += MovementHelper.getMiningDurationTicks(context, x, y + 1, z, above, true);
            }
            return result;
        }
        return 0.0;
    }

    public static boolean isBottomSlab(class_2680 state) {
        return state.method_26204() instanceof class_2482 && state.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681;
    }

    public static void switchToBestToolFor(IEntityContext ctx, class_2680 b) {
        class_1309 entity = ctx.entity();
        if (entity instanceof IInventoryProvider) {
            MovementHelper.switchToBestToolFor(ctx, b, new ToolSet(entity), ctx.baritone().settings().preferSilkTouch.get());
        }
    }

    public static void switchToBestToolFor(IEntityContext ctx, class_2680 b, ToolSet ts, boolean preferSilkTouch) {
        LivingEntityInventory inventory = ctx.inventory();
        if (inventory != null && !ctx.baritone().settings().disableAutoTool.get().booleanValue() && !ctx.baritone().settings().assumeExternalAutoTool.get().booleanValue()) {
            inventory.selectedSlot = ts.getBestSlot(b.method_26204(), preferSilkTouch);
        }
    }

    public static void moveTowards(IEntityContext ctx, MovementState state, class_2338 pos) {
        state.setTarget(new MovementState.MovementTarget(new Rotation(RotationUtils.calcRotationFromVec3d(ctx.headPos(), VecUtils.getBlockPosCenter(pos), ctx.entityRotations()).getYaw(), ctx.entity().method_36455()), false)).setInput(Input.MOVE_FORWARD, true);
    }

    public static boolean isWater(class_2680 state) {
        return state.method_26227().method_15767(class_3486.field_15517);
    }

    public static boolean isWater(IEntityContext ctx, class_2338 bp) {
        return MovementHelper.isWater(BlockStateInterface.get(ctx, bp));
    }

    public static boolean isLava(class_2680 state) {
        class_3611 f = state.method_26227().method_15772();
        return f == class_3612.field_15908 || f == class_3612.field_15907;
    }

    public static boolean isLiquid(IEntityContext ctx, class_2338 p) {
        return MovementHelper.isLiquid(BlockStateInterface.get(ctx, p));
    }

    public static boolean isLiquid(class_2680 blockState) {
        return !blockState.method_26227().method_15769();
    }

    public static boolean possiblyFlowing(class_2680 state) {
        class_3610 fluidState = state.method_26227();
        return fluidState.method_15772() instanceof class_3609 && fluidState.method_15772().method_15779(fluidState) != 8;
    }

    public static boolean isFlowing(int x, int y, int z, class_2680 state, BlockStateInterface bsi) {
        class_3610 fluidState = state.method_26227();
        if (!(fluidState.method_15772() instanceof class_3609)) {
            return false;
        }
        return fluidState.method_15772().method_15779(fluidState) != 8 ? true : MovementHelper.possiblyFlowing(bsi.get0(x + 1, y, z)) || MovementHelper.possiblyFlowing(bsi.get0(x - 1, y, z)) || MovementHelper.possiblyFlowing(bsi.get0(x, y, z + 1)) || MovementHelper.possiblyFlowing(bsi.get0(x, y, z - 1));
    }

    public static boolean isBlockNormalCube(class_2680 state) {
        class_2248 block = state.method_26204();
        if (!(block instanceof class_2211 || block instanceof class_2667 || block instanceof class_3736 || block instanceof class_2480)) {
            try {
                return state.method_26234(null, class_2338.field_10980);
            }
            catch (NullPointerException var3) {
                return false;
            }
        }
        return false;
    }

    public static PlaceResult attemptToPlaceABlock(MovementState state, IBaritone baritone, class_2338 placeAt, boolean preferDown, boolean wouldSneak) {
        IEntityContext ctx = baritone.getEntityContext();
        Optional<Rotation> direct = RotationUtils.reachable(ctx, placeAt, wouldSneak);
        boolean found = false;
        if (direct.isPresent()) {
            state.setTarget(new MovementState.MovementTarget(direct.get(), true));
            found = true;
        }
        int i = 0;
        while (true) {
            block12: {
                block11: {
                    if (i >= 5) break block11;
                    class_2338 against1 = placeAt.method_10093(Movement.HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i]);
                    if (!MovementHelper.canPlaceAgainst(ctx, against1)) break block12;
                    if (!((Baritone)baritone).getInventoryBehavior().selectThrowawayForLocation(false, placeAt.method_10263(), placeAt.method_10264(), placeAt.method_10260())) {
                        baritone.logDebug("bb pls get me some blocks. dirt, netherrack, cobble");
                        state.setStatus(MovementStatus.UNREACHABLE);
                        return PlaceResult.NO_OPTION;
                    }
                    double faceX = ((double)(placeAt.method_10263() + against1.method_10263()) + 1.0) * 0.5;
                    double faceY = ((double)(placeAt.method_10264() + against1.method_10264()) + 0.5) * 0.5;
                    double faceZ = ((double)(placeAt.method_10260() + against1.method_10260()) + 1.0) * 0.5;
                    Rotation place = RotationUtils.calcRotationFromVec3d(wouldSneak ? RayTraceUtils.inferSneakingEyePosition((class_1297)ctx.entity()) : ctx.headPos(), new class_243(faceX, faceY, faceZ), ctx.entityRotations());
                    class_239 res = RayTraceUtils.rayTraceTowards((class_1297)ctx.entity(), place, ctx.playerController().getBlockReachDistance(), wouldSneak);
                    if (res == null || res.method_17783() != class_239.class_240.field_1332 || !((class_3965)res).method_17777().equals((Object)against1) || !((class_3965)res).method_17777().method_10093(((class_3965)res).method_17780()).equals((Object)placeAt)) break block12;
                    state.setTarget(new MovementState.MovementTarget(place, true));
                    found = true;
                    if (preferDown) break block12;
                }
                if (ctx.getSelectedBlock().isPresent()) {
                    class_2338 selectedBlock = ctx.getSelectedBlock().get();
                    class_2350 side = ((class_3965)ctx.objectMouseOver()).method_17780();
                    if (selectedBlock.equals((Object)placeAt) || MovementHelper.canPlaceAgainst(ctx, selectedBlock) && selectedBlock.method_10093(side).equals((Object)placeAt)) {
                        if (wouldSneak) {
                            state.setInput(Input.SNEAK, true);
                        }
                        ((Baritone)baritone).getInventoryBehavior().selectThrowawayForLocation(true, placeAt.method_10263(), placeAt.method_10264(), placeAt.method_10260());
                        return PlaceResult.READY_TO_PLACE;
                    }
                }
                if (found) {
                    if (wouldSneak) {
                        state.setInput(Input.SNEAK, true);
                    }
                    ((Baritone)baritone).getInventoryBehavior().selectThrowawayForLocation(true, placeAt.method_10263(), placeAt.method_10264(), placeAt.method_10260());
                    return PlaceResult.ATTEMPTING;
                }
                return PlaceResult.NO_OPTION;
            }
            ++i;
        }
    }

    public static boolean isTransparent(class_2248 b) {
        return b == class_2246.field_10124 || b == class_2246.field_10164 || b == class_2246.field_10382;
    }

    public static enum PlaceResult {
        READY_TO_PLACE,
        ATTEMPTING,
        NO_OPTION;

    }
}

