/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.movement.movements;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.api.pathing.movement.MovementStatus;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.VecUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.behavior.InventoryBehavior;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.pathing.movement.MovementState;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementDescend;
import com.player2.playerengine.automaton.utils.pathing.MutableMoveResult;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2399;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3621;

public class MovementFall
extends Movement {
    public MovementFall(IBaritone baritone, BetterBlockPos src, BetterBlockPos dest) {
        super(baritone, src, dest, MovementFall.buildPositionsToBreak(src, dest));
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementDescend.cost(context, this.src.x, this.src.y, this.src.z, this.dest.x, this.dest.z, result);
        return result.y != this.dest.y ? 1000000.0 : result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        HashSet<BetterBlockPos> set = new HashSet<BetterBlockPos>();
        set.add(this.src);
        for (int y = this.src.y - this.dest.y; y >= 0; --y) {
            set.add(this.dest.up(y));
        }
        return set;
    }

    private boolean willPlaceBucket() {
        CalculationContext context = new CalculationContext(this.baritone);
        MutableMoveResult result = new MutableMoveResult();
        return MovementDescend.dynamicFallCost(context, this.src.x, this.src.y, this.src.z, this.dest.x, this.dest.z, 0.0, context.get(this.dest.x, this.src.y - 2, this.dest.z), result);
    }

    @Override
    public MovementState updateState(MovementState state) {
        class_2382 avoid;
        super.updateState(state);
        if (state.getStatus() != MovementStatus.RUNNING) {
            return state;
        }
        BetterBlockPos playerFeet = this.ctx.feetPos();
        Rotation toDest = RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), VecUtils.getBlockPosCenter(this.dest), this.ctx.entityRotations());
        Rotation targetRotation = null;
        class_2680 destState = this.ctx.world().method_8320((class_2338)this.dest);
        boolean isWater = destState.method_26227().method_15772() instanceof class_3621;
        if (!isWater && this.willPlaceBucket() && !playerFeet.equals((Object)this.dest)) {
            LivingEntityInventory inventory = this.ctx.inventory();
            if (inventory == null || !LivingEntityInventory.isValidHotbarIndex(InventoryBehavior.getSlotWithStack(inventory, PlayerEngine.WATER_BUCKETS)) || this.ctx.world().method_8597().comp_644()) {
                return state.setStatus(MovementStatus.UNREACHABLE);
            }
            if (this.ctx.entity().method_23318() - (double)this.dest.method_10264() < this.ctx.playerController().getBlockReachDistance() && !this.ctx.entity().method_24828()) {
                inventory.selectedSlot = InventoryBehavior.getSlotWithStack(inventory, PlayerEngine.WATER_BUCKETS);
                targetRotation = new Rotation(toDest.getYaw(), 90.0f);
                if (this.ctx.isLookingAt(this.dest) || this.ctx.isLookingAt(this.dest.down())) {
                    state.setInput(Input.CLICK_RIGHT, true);
                }
            }
        }
        if (targetRotation != null) {
            state.setTarget(new MovementState.MovementTarget(targetRotation, true));
        } else {
            state.setTarget(new MovementState.MovementTarget(toDest, false));
        }
        if (playerFeet.equals((Object)this.dest) && (this.ctx.entity().method_23318() - (double)playerFeet.method_10264() < 0.094 || isWater)) {
            if (!isWater) {
                return state.setStatus(MovementStatus.SUCCESS);
            }
            state.setInput(Input.JUMP, true);
            LivingEntityInventory inventoryx = this.ctx.inventory();
            if (inventoryx != null && LivingEntityInventory.isValidHotbarIndex(InventoryBehavior.getSlotWithStack(inventoryx, PlayerEngine.EMPTY_BUCKETS))) {
                inventoryx.selectedSlot = InventoryBehavior.getSlotWithStack(inventoryx, PlayerEngine.EMPTY_BUCKETS);
                if (this.ctx.entity().method_18798().field_1351 >= 0.0) {
                    return state.setInput(Input.CLICK_RIGHT, true);
                }
                return state;
            }
            if (this.ctx.entity().method_18798().field_1351 >= 0.0) {
                return state.setStatus(MovementStatus.SUCCESS);
            }
        }
        class_243 destCenter = VecUtils.getBlockPosCenter(this.dest);
        if (Math.abs(this.ctx.entity().method_23317() + this.ctx.entity().method_18798().field_1352 - destCenter.field_1352) > 0.1 || Math.abs(this.ctx.entity().method_23321() + this.ctx.entity().method_18798().field_1350 - destCenter.field_1350) > 0.1) {
            if (!this.ctx.entity().method_24828() && Math.abs(this.ctx.entity().method_18798().field_1351) > 0.4) {
                state.setInput(Input.SNEAK, true);
            }
            state.setInput(Input.MOVE_FORWARD, true);
        }
        if ((avoid = (class_2382)Optional.ofNullable(this.avoid()).map(class_2350::method_10163).orElse(null)) == null) {
            avoid = this.src.method_10059((class_2382)this.dest);
        } else {
            double dist = Math.abs((double)avoid.method_10263() * (destCenter.field_1352 - (double)avoid.method_10263() / 2.0 - this.ctx.entity().method_23317())) + Math.abs((double)avoid.method_10260() * (destCenter.field_1350 - (double)avoid.method_10260() / 2.0 - this.ctx.entity().method_23321()));
            if (dist < 0.6) {
                state.setInput(Input.MOVE_FORWARD, true);
            } else if (!this.ctx.entity().method_24828()) {
                state.setInput(Input.SNEAK, false);
            }
        }
        if (targetRotation == null) {
            class_243 destCenterOffset = new class_243(destCenter.field_1352 + 0.125 * (double)avoid.method_10263(), destCenter.field_1351, destCenter.field_1350 + 0.125 * (double)avoid.method_10260());
            state.setTarget(new MovementState.MovementTarget(RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), destCenterOffset, this.ctx.entityRotations()), false));
        }
        if (this.ctx.world().method_8320((class_2338)playerFeet).method_27852(class_2246.field_16492) || this.ctx.world().method_8320(playerFeet.method_10074()).method_27852(class_2246.field_16492)) {
            state.setInput(Input.SNEAK, true);
        }
        return state;
    }

    private class_2350 avoid() {
        for (int i = 0; i < 15; ++i) {
            class_2680 state = this.ctx.world().method_8320((class_2338)this.ctx.feetPos().down(i));
            if (state.method_26204() != class_2246.field_9983) continue;
            return (class_2350)state.method_11654((class_2769)class_2399.field_11253);
        }
        return null;
    }

    @Override
    public boolean safeToCancel(MovementState state) {
        return this.ctx.feetPos().equals((Object)this.src) || state.getStatus() != MovementStatus.RUNNING;
    }

    private static BetterBlockPos[] buildPositionsToBreak(BetterBlockPos src, BetterBlockPos dest) {
        int diffX = src.method_10263() - dest.method_10263();
        int diffZ = src.method_10260() - dest.method_10260();
        int diffY = src.method_10264() - dest.method_10264();
        BetterBlockPos[] toBreak = new BetterBlockPos[diffY + 2];
        for (int i = 0; i < toBreak.length; ++i) {
            toBreak[i] = new BetterBlockPos(src.method_10263() - diffX, src.method_10264() + 1 - i, src.method_10260() - diffZ);
        }
        return toBreak;
    }

    @Override
    protected boolean prepared(MovementState state) {
        if (state.getStatus() == MovementStatus.WAITING) {
            return true;
        }
        for (int i = 0; i < 4 && i < this.positionsToBreak.length; ++i) {
            if (MovementHelper.canWalkThrough(this.ctx, this.positionsToBreak[i])) continue;
            return super.prepared(state);
        }
        return true;
    }
}

