/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.process;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.cache.ICachedWorld;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.goals.GoalComposite;
import com.player2.playerengine.automaton.api.pathing.goals.GoalXZ;
import com.player2.playerengine.automaton.api.pathing.goals.GoalYLevel;
import com.player2.playerengine.automaton.api.process.IExploreProcess;
import com.player2.playerengine.automaton.api.process.PathingCommand;
import com.player2.playerengine.automaton.api.process.PathingCommandType;
import com.player2.playerengine.automaton.api.utils.MyChunkPos;
import com.player2.playerengine.automaton.utils.BaritoneProcessHelper;
import com.player2.playerengine.automaton.utils.NotificationHelper;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import net.minecraft.class_1923;
import net.minecraft.class_2338;

public final class ExploreProcess
extends BaritoneProcessHelper
implements IExploreProcess {
    private class_2338 explorationOrigin;
    private IChunkFilter filter;
    private int distanceCompleted;

    public ExploreProcess(Baritone baritone) {
        super(baritone);
    }

    @Override
    public boolean isActive() {
        return this.explorationOrigin != null;
    }

    @Override
    public void explore(int centerX, int centerZ) {
        this.explorationOrigin = new class_2338(centerX, 0, centerZ);
        this.distanceCompleted = 0;
    }

    @Override
    public void applyJsonFilter(Path path, boolean invert) throws Exception {
        this.filter = new JsonChunkFilter(path, invert);
    }

    public IChunkFilter calcFilter() {
        IChunkFilter filter = this.filter != null ? new EitherChunk(this.filter, new BaritoneChunkCache()) : new BaritoneChunkCache();
        return filter;
    }

    @Override
    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        if (calcFailed) {
            this.logDirect("Failed");
            if (this.baritone.settings().desktopNotifications.get().booleanValue() && this.baritone.settings().notificationOnExploreFinished.get().booleanValue()) {
                NotificationHelper.notify("Exploration failed", true);
            }
            this.onLostControl();
            return null;
        }
        IChunkFilter filter = this.calcFilter();
        if (!this.baritone.settings().disableCompletionCheck.get().booleanValue() && filter.countRemain() == 0) {
            this.logDirect("Explored all chunks");
            if (this.baritone.settings().desktopNotifications.get().booleanValue() && this.baritone.settings().notificationOnExploreFinished.get().booleanValue()) {
                NotificationHelper.notify("Explored all chunks", false);
            }
            this.onLostControl();
            return null;
        }
        Goal[] closestUncached = this.closestUncachedChunks(this.explorationOrigin, filter);
        if (closestUncached == null) {
            this.baritone.logDebug("awaiting region load from disk");
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        return new PathingCommand(new GoalComposite(closestUncached), PathingCommandType.FORCE_REVALIDATE_GOAL_AND_PATH);
    }

    private Goal[] closestUncachedChunks(class_2338 center, IChunkFilter filter) {
        int chunkX = center.method_10263() >> 4;
        int chunkZ = center.method_10260() >> 4;
        int count = Math.min(filter.countRemain(), this.baritone.settings().exploreChunkSetMinimumSize.get());
        ArrayList<class_2338> centers = new ArrayList<class_2338>();
        int renderDistance = this.baritone.settings().worldExploringChunkOffset.get();
        int dist = this.distanceCompleted;
        while (true) {
            for (int dx = -dist; dx <= dist; ++dx) {
                int zval = dist - Math.abs(dx);
                for (int mult = 0; mult < 2; ++mult) {
                    int dz = (mult * 2 - 1) * zval;
                    int trueDist = Math.abs(dx) + Math.abs(dz);
                    if (trueDist != dist) {
                        throw new IllegalStateException();
                    }
                    switch (filter.isAlreadyExplored(chunkX + dx, chunkZ + dz).ordinal()) {
                        case 2: {
                            return null;
                        }
                        default: {
                            int centerX = (chunkX + dx << 4) + 8;
                            int centerZ = (chunkZ + dz << 4) + 8;
                            int offset = renderDistance << 4;
                            centerX = dx < 0 ? (centerX -= offset) : (centerX += offset);
                            centerZ = dz < 0 ? (centerZ -= offset) : (centerZ += offset);
                            centers.add(new class_2338(centerX, 0, centerZ));
                        }
                        case 0: 
                    }
                }
            }
            if (dist % 10 == 0) {
                count = Math.min(filter.countRemain(), this.baritone.settings().exploreChunkSetMinimumSize.get());
            }
            if (centers.size() >= count) {
                return (Goal[])centers.stream().map(pos -> this.createGoal(pos.method_10263(), pos.method_10260())).toArray(Goal[]::new);
            }
            if (centers.isEmpty()) {
                this.distanceCompleted = dist + 1;
            }
            ++dist;
        }
    }

    private Goal createGoal(int x, int z) {
        return this.baritone.settings().exploreMaintainY.get() == -1 ? new GoalXZ(x, z) : new GoalXZ(x, z){

            @Override
            public double heuristic(int x, int y, int zx) {
                return super.heuristic(x, y, zx) + GoalYLevel.calculate(((ExploreProcess)ExploreProcess.this).baritone.settings().exploreMaintainY.get(), y);
            }
        };
    }

    @Override
    public void onLostControl() {
        this.explorationOrigin = null;
    }

    @Override
    public String displayName0() {
        return "Exploring around " + String.valueOf(this.explorationOrigin) + ", distance completed " + this.distanceCompleted + ", currently going to " + String.valueOf(new GoalComposite(this.closestUncachedChunks(this.explorationOrigin, this.calcFilter())));
    }

    private class JsonChunkFilter
    implements IChunkFilter {
        private final boolean invert;
        private final LongOpenHashSet inFilter;
        private final MyChunkPos[] positions;

        private JsonChunkFilter(Path path, boolean invert) throws Exception {
            this.invert = invert;
            Gson gson = new GsonBuilder().create();
            this.positions = (MyChunkPos[])gson.fromJson((Reader)new InputStreamReader(Files.newInputStream(path, new OpenOption[0])), MyChunkPos[].class);
            ExploreProcess.this.logDirect("Loaded " + this.positions.length + " positions");
            this.inFilter = new LongOpenHashSet();
            for (MyChunkPos mcp : this.positions) {
                this.inFilter.add(class_1923.method_8331((int)mcp.x, (int)mcp.z));
            }
        }

        @Override
        public Status isAlreadyExplored(int chunkX, int chunkZ) {
            return this.inFilter.contains(class_1923.method_8331((int)chunkX, (int)chunkZ)) ^ this.invert ? Status.EXPLORED : Status.UNKNOWN;
        }

        @Override
        public int countRemain() {
            if (!this.invert) {
                return Integer.MAX_VALUE;
            }
            int countRemain = 0;
            BaritoneChunkCache bcc = new BaritoneChunkCache();
            for (MyChunkPos pos : this.positions) {
                if (bcc.isAlreadyExplored(pos.x, pos.z) == Status.EXPLORED || ++countRemain < ((ExploreProcess)ExploreProcess.this).baritone.settings().exploreChunkSetMinimumSize.get()) continue;
                return countRemain;
            }
            return countRemain;
        }
    }

    private static interface IChunkFilter {
        public Status isAlreadyExplored(int var1, int var2);

        public int countRemain();
    }

    private class EitherChunk
    implements IChunkFilter {
        private final IChunkFilter a;
        private final IChunkFilter b;

        private EitherChunk(IChunkFilter a, IChunkFilter b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public Status isAlreadyExplored(int chunkX, int chunkZ) {
            return this.a.isAlreadyExplored(chunkX, chunkZ) == Status.EXPLORED ? Status.EXPLORED : this.b.isAlreadyExplored(chunkX, chunkZ);
        }

        @Override
        public int countRemain() {
            return Math.min(this.a.countRemain(), this.b.countRemain());
        }
    }

    private class BaritoneChunkCache
    implements IChunkFilter {
        private final ICachedWorld cache;

        private BaritoneChunkCache() {
            this.cache = ExploreProcess.this.baritone.getWorldProvider().getCurrentWorld().getCachedWorld();
        }

        @Override
        public Status isAlreadyExplored(int chunkX, int chunkZ) {
            int centerX = chunkX << 4;
            int centerZ = chunkZ << 4;
            return this.cache.isCached(centerX, centerZ) ? Status.EXPLORED : Status.NOT_EXPLORED;
        }

        @Override
        public int countRemain() {
            return Integer.MAX_VALUE;
        }
    }

    private static enum Status {
        EXPLORED,
        NOT_EXPLORED,
        UNKNOWN;

    }
}

