/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.chains;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.behavior.PathingBehavior;
import com.player2.playerengine.chains.SingleTaskChain;
import com.player2.playerengine.control.KillAura;
import com.player2.playerengine.multiversion.item.ItemVer;
import com.player2.playerengine.tasks.base.TaskRunner;
import com.player2.playerengine.tasks.construction.ProjectileProtectionWallTask;
import com.player2.playerengine.tasks.entity.KillEntitiesTask;
import com.player2.playerengine.tasks.movement.CustomBaritoneGoalTask;
import com.player2.playerengine.tasks.movement.DodgeProjectilesTask;
import com.player2.playerengine.tasks.movement.RunAwayFromCreepersTask;
import com.player2.playerengine.tasks.movement.RunAwayFromHostilesTask;
import com.player2.playerengine.tasks.speedrun.DragonBreathTracker;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.baritone.CachedProjectile;
import com.player2.playerengine.util.helpers.BaritoneHelper;
import com.player2.playerengine.util.helpers.EntityHelper;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.ProjectileHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.slots.PlayerSlot;
import com.player2.playerengine.util.slots.Slot;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1267;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1528;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1549;
import net.minecraft.class_1551;
import net.minecraft.class_1560;
import net.minecraft.class_1571;
import net.minecraft.class_1589;
import net.minecraft.class_1604;
import net.minecraft.class_1613;
import net.minecraft.class_1621;
import net.minecraft.class_1627;
import net.minecraft.class_1632;
import net.minecraft.class_1639;
import net.minecraft.class_1640;
import net.minecraft.class_1667;
import net.minecraft.class_1670;
import net.minecraft.class_1674;
import net.minecraft.class_1677;
import net.minecraft.class_1679;
import net.minecraft.class_1686;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_4760;
import net.minecraft.class_4770;
import net.minecraft.class_4836;
import net.minecraft.class_5136;
import net.minecraft.class_5419;
import net.minecraft.class_7260;

public class MobDefenseChain
extends SingleTaskChain {
    private static final double DANGER_KEEP_DISTANCE = 30.0;
    private static final double CREEPER_KEEP_DISTANCE = 10.0;
    private static final double ARROW_KEEP_DISTANCE_HORIZONTAL = 2.0;
    private static final double ARROW_KEEP_DISTANCE_VERTICAL = 10.0;
    private static final double SAFE_KEEP_DISTANCE = 8.0;
    private static final List<Class<? extends class_1297>> ignoredMobs = List.of(class_7260.class, class_1528.class, class_1560.class, class_1545.class, class_1639.class, class_4760.class, class_5136.class, class_5419.class, class_1632.class, class_1589.class);
    private static boolean shielding = false;
    private final DragonBreathTracker dragonBreathTracker = new DragonBreathTracker();
    private final KillAura killAura = new KillAura();
    private class_1297 targetEntity;
    private boolean doingFunkyStuff = false;
    private boolean wasPuttingOutFire = false;
    private CustomBaritoneGoalTask runAwayTask;
    private float prevHealth = 20.0f;
    private boolean needsChangeOnAttack = false;
    private class_1297 lockedOnEntity = null;
    private float cachedLastPriority;

    public MobDefenseChain(TaskRunner runner) {
        super(runner);
    }

    public static double getCreeperSafety(class_243 pos, class_1548 creeper) {
        double distance = creeper.method_5707(pos);
        float fuse = creeper.method_7003(1.0f);
        return fuse <= 0.001f ? distance : distance * 0.2;
    }

    private static void startShielding(PlayerEngineController mod) {
        class_1799 handItem;
        shielding = true;
        ((PathingBehavior)mod.getBaritone().getPathingBehavior()).requestPause();
        mod.getExtraBaritoneSettings().setInteractionPaused(true);
        if (!mod.getPlayer().method_6039() && ItemVer.isFood(handItem = StorageHelper.getItemStackInSlot(PlayerSlot.getEquipSlot(mod.getInventory())))) {
            for (class_1799 spaceSlot : mod.getItemStorage().getItemStacksPlayerInventory(false)) {
                if (!spaceSlot.method_7960()) continue;
                mod.getSlotHandler().clickSlot(PlayerSlot.getEquipSlot(mod.getInventory()), 0, class_1713.field_7794);
                return;
            }
            Optional<Slot> garbage = StorageHelper.getGarbageSlot(mod);
            garbage.ifPresent(slot -> mod.getSlotHandler().forceEquipItem(StorageHelper.getItemStackInSlot(slot).method_7909()));
        }
        mod.getInputControls().hold(Input.SNEAK);
        mod.getInputControls().hold(Input.CLICK_RIGHT);
    }

    private static int getDangerousnessScore(List<class_1309> toDealWithList) {
        int numberOfProblematicEntities = toDealWithList.size();
        for (class_1309 toDealWith : toDealWithList) {
            if (toDealWith instanceof class_1560 || toDealWith instanceof class_1621 || toDealWith instanceof class_1545) {
                ++numberOfProblematicEntities;
                continue;
            }
            if (!(toDealWith instanceof class_1551) || toDealWith.method_5743() != class_1802.field_8547) continue;
            numberOfProblematicEntities += 5;
        }
        return numberOfProblematicEntities;
    }

    @Override
    public float getPriority() {
        this.cachedLastPriority = this.getPriorityInner();
        if (this.getCurrentTask() == null) {
            this.cachedLastPriority = 0.0f;
        }
        this.prevHealth = this.controller.getPlayer().method_6032();
        return this.cachedLastPriority;
    }

    private void stopShielding(PlayerEngineController mod) {
        if (shielding) {
            Optional<Slot> toMoveTo;
            class_1799 cursor = StorageHelper.getItemStackInCursorSlot(this.controller);
            if (ItemVer.isFood(cursor) && (toMoveTo = mod.getItemStorage().getSlotThatCanFitInPlayerInventory(cursor, false).or(() -> StorageHelper.getGarbageSlot(mod))).isPresent()) {
                Slot garbageSlot = toMoveTo.get();
                mod.getSlotHandler().clickSlot(garbageSlot, 0, class_1713.field_7790);
            }
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().release(Input.CLICK_RIGHT);
            mod.getExtraBaritoneSettings().setInteractionPaused(false);
            shielding = false;
        }
    }

    public boolean isShielding() {
        return shielding || this.killAura.isShielding();
    }

    private boolean escapeDragonBreath(PlayerEngineController mod) {
        this.dragonBreathTracker.updateBreath(mod);
        for (class_2338 playerIn : WorldHelper.getBlocksTouchingPlayer(mod.getPlayer())) {
            if (!this.dragonBreathTracker.isTouchingDragonBreath(playerIn)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getPriorityInner() {
        Object shieldSlot;
        class_2338 fireBlock;
        if (!PlayerEngineController.inGame()) {
            return Float.NEGATIVE_INFINITY;
        }
        PlayerEngineController mod = this.controller;
        if (!mod.getModSettings().isMobDefense()) {
            return Float.NEGATIVE_INFINITY;
        }
        if (mod.getWorld().method_8407() == class_1267.field_5801) {
            return Float.NEGATIVE_INFINITY;
        }
        if (this.needsChangeOnAttack && (mod.getPlayer().method_6032() < this.prevHealth || this.killAura.attackedLastTick)) {
            this.needsChangeOnAttack = false;
        }
        if ((fireBlock = this.isInsideFireAndOnFire(mod)) != null) {
            this.putOutFire(mod, fireBlock);
            this.wasPuttingOutFire = true;
        } else {
            mod.getBaritone().getInputOverrideHandler().setInputForceState(Input.CLICK_LEFT, false);
            this.wasPuttingOutFire = false;
        }
        Optional<class_1297> universallyDangerous = this.getUniversallyDangerousMob(mod);
        if (universallyDangerous.isPresent() && mod.getPlayer().method_6032() <= 10.0f) {
            this.runAwayTask = new RunAwayFromHostilesTask(30.0, true);
            this.runAwayTask.controller = this.controller;
            this.setTask(this.runAwayTask);
            return 70.0f;
        }
        this.doingFunkyStuff = false;
        Slot offhandSlot = PlayerSlot.getOffhandSlot(mod.getInventory());
        class_1792 offhandItem = StorageHelper.getItemStackInSlot(offhandSlot).method_7909();
        class_1548 blowingUp = this.getClosestFusingCreeper(mod);
        if (blowingUp != null && blowingUp.method_5739((class_1297)mod.getEntity()) <= 16.0f) {
            if (mod.getFoodChain().needsToEat() && !(mod.getPlayer().method_6032() < 9.0f) || !MobDefenseChain.hasShield(mod) || mod.getEntityTracker().entityFound(class_1686.class) || !mod.getBaritone().getPathingBehavior().isSafeToCancel() || !((double)blowingUp.method_7003((float)blowingUp.method_7007()) > 0.5)) {
                this.doingFunkyStuff = true;
                this.runAwayTask = new RunAwayFromCreepersTask(10.0);
                this.runAwayTask.controller = this.controller;
                this.setTask(this.runAwayTask);
                return 50.0f + blowingUp.method_7003(1.0f) * 50.0f;
            }
            LookHelper.lookAt(mod, blowingUp.method_33571());
            shieldSlot = StorageHelper.getItemStackInSlot(offhandSlot);
            if (shieldSlot.method_7909() != class_1802.field_8255) {
                mod.getSlotHandler().forceEquipItemToOffhand(class_1802.field_8255);
            } else {
                MobDefenseChain.startShielding(mod);
            }
        }
        shieldSlot = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (shieldSlot) {
            if (mod.getModSettings().isDodgeProjectiles() && MobDefenseChain.hasShield(mod) && mod.getBaritone().getPathingBehavior().isSafeToCancel() && !mod.getEntityTracker().entityFound(class_1686.class) && this.isProjectileClose(mod)) {
                class_1799 shieldSlot2 = StorageHelper.getItemStackInSlot(new Slot(mod.getInventory().offHand, 0));
                if (shieldSlot2.method_7909() != class_1802.field_8255) {
                    mod.getSlotHandler().forceEquipItemToOffhand(class_1802.field_8255);
                } else {
                    MobDefenseChain.startShielding(mod);
                }
                return 60.0f;
            }
            if (blowingUp == null && !this.isProjectileClose(mod)) {
                this.stopShielding(mod);
            }
        }
        if (!mod.getFoodChain().needsToEat() && !mod.getMLGBucketChain().isFalling(mod) && mod.getMLGBucketChain().doneMLG() && !mod.getMLGBucketChain().isChorusFruiting()) {
            this.doForceField(mod);
            if (mod.getPlayer().method_6032() <= 10.0f && !MobDefenseChain.hasShield(mod)) {
                if (StorageHelper.getNumberOfThrowawayBlocks(mod) > 0 && !mod.getFoodChain().needsToEat() && mod.getModSettings().isDodgeProjectiles() && this.isProjectileClose(mod)) {
                    this.doingFunkyStuff = true;
                    this.setTask(new ProjectileProtectionWallTask(mod));
                    return 65.0f;
                }
                if (this.isProjectileClose(mod)) {
                    this.runAwayTask = new DodgeProjectilesTask(2.0, 10.0);
                    this.runAwayTask.controller = this.controller;
                    this.setTask(this.runAwayTask);
                    return 65.0f;
                }
            }
            if (!this.isInDanger(mod) || this.escapeDragonBreath(mod) || mod.getFoodChain().isShouldStop() || this.targetEntity != null && !WorldHelper.isSurroundedByHostiles(mod)) {
                if (mod.getModSettings().shouldDealWithAnnoyingHostiles()) {
                    List<class_1309> hostiles = mod.getEntityTracker().getHostiles();
                    ArrayList<class_1309> toDealWithList = new ArrayList<class_1309>();
                    Object object = BaritoneHelper.MINECRAFT_LOCK;
                    synchronized (object) {
                        for (class_1309 hostile : hostiles) {
                            if (hostile == mod.getEntity()) continue;
                            boolean isRangedOrPoisonous = hostile instanceof class_1613 || hostile instanceof class_1640 || hostile instanceof class_1604 || hostile instanceof class_4836 || hostile instanceof class_1627 || hostile instanceof class_1549;
                            int annoyingRange = 10;
                            if (isRangedOrPoisonous) {
                                annoyingRange = 20;
                                if (!MobDefenseChain.hasShield(mod)) {
                                    annoyingRange = 35;
                                }
                            }
                            if (!hostile.method_24516((class_1297)mod.getPlayer(), (double)annoyingRange) || !LookHelper.seesPlayer((class_1297)hostile, (class_1297)mod.getPlayer(), annoyingRange)) continue;
                            boolean isIgnored = false;
                            for (Class<? extends class_1297> ignored : ignoredMobs) {
                                if (!ignored.isInstance(hostile)) continue;
                                isIgnored = true;
                                break;
                            }
                            if (isIgnored) {
                                if (!(mod.getPlayer().method_6032() <= 10.0f)) continue;
                                toDealWithList.add(hostile);
                                continue;
                            }
                            toDealWithList.add(hostile);
                        }
                    }
                    toDealWithList.sort(Comparator.comparingDouble(entity -> mod.getPlayer().method_5739((class_1297)entity)));
                    if (!toDealWithList.isEmpty()) {
                        class_1297 toKill;
                        int shield;
                        float damage;
                        class_1831 bestWeapon = MobDefenseChain.getBestWeapon(mod);
                        int armor = mod.getPlayer().method_6096();
                        int canDealWith = (int)Math.ceil((double)armor * 3.6 / 20.0 + (double)(damage = bestWeapon == null ? 0.0f : bestWeapon.method_8022().method_8028() + 1.0f) * 0.8 + (double)(shield = MobDefenseChain.hasShield(mod) && bestWeapon != null ? 3 : 0));
                        if (canDealWith < MobDefenseChain.getDangerousnessScore(toDealWithList) && !this.needsChangeOnAttack) {
                            this.runAwayTask = new RunAwayFromHostilesTask(30.0, true);
                            this.runAwayTask.controller = this.controller;
                            this.setTask(this.runAwayTask);
                            return 80.0f;
                        }
                        if (!(this.mainTask instanceof KillEntitiesTask)) {
                            this.needsChangeOnAttack = true;
                        }
                        this.runAwayTask = null;
                        this.lockedOnEntity = toKill = (class_1297)toDealWithList.get(0);
                        this.setTask(new KillEntitiesTask(toKill.getClass()));
                        return 65.0f;
                    }
                }
                if (this.runAwayTask != null && !this.runAwayTask.isFinished()) {
                    this.setTask(this.runAwayTask);
                    return this.cachedLastPriority;
                }
                this.runAwayTask = null;
                if (this.needsChangeOnAttack && this.lockedOnEntity != null && this.lockedOnEntity.method_5805()) {
                    this.setTask(new KillEntitiesTask(this.lockedOnEntity.getClass()));
                    return 65.0f;
                }
                this.needsChangeOnAttack = false;
                this.lockedOnEntity = null;
                return 0.0f;
            }
            this.runAwayTask = new RunAwayFromHostilesTask(30.0, true);
            this.runAwayTask.controller = this.controller;
            this.setTask(this.runAwayTask);
            return 70.0f;
        }
        this.killAura.stopShielding(mod);
        this.stopShielding(mod);
        return Float.NEGATIVE_INFINITY;
    }

    private static boolean hasShield(PlayerEngineController mod) {
        return mod.getItemStorage().hasItem(class_1802.field_8255) || mod.getItemStorage().hasItemInOffhand(mod, class_1802.field_8255);
    }

    public static class_1831 getBestWeapon(PlayerEngineController mod) {
        class_1792[] WEAPONS = new class_1792[]{class_1802.field_22022, class_1802.field_22025, class_1802.field_8802, class_1802.field_8556, class_1802.field_8371, class_1802.field_8475, class_1802.field_8845, class_1802.field_8825, class_1802.field_8528, class_1802.field_8062, class_1802.field_8091, class_1802.field_8406};
        class_1831 bestSword = null;
        for (class_1792 item : WEAPONS) {
            if (!mod.getItemStorage().hasItem(item)) continue;
            bestSword = (class_1831)item;
            break;
        }
        return bestSword;
    }

    private class_2338 isInsideFireAndOnFire(PlayerEngineController mod) {
        class_2338[] toCheck;
        boolean onFire = mod.getPlayer().method_5809();
        if (!onFire) {
            return null;
        }
        class_2338 p = mod.getPlayer().method_24515();
        for (class_2338 check : toCheck = new class_2338[]{p, p.method_10069(1, 0, 0), p.method_10069(1, 0, -1), p.method_10069(0, 0, -1), p.method_10069(-1, 0, -1), p.method_10069(-1, 0, 0), p.method_10069(-1, 0, 1), p.method_10069(0, 0, 1), p.method_10069(1, 0, 1)}) {
            class_2248 b = mod.getWorld().method_8320(check).method_26204();
            if (!(b instanceof class_4770)) continue;
            return check;
        }
        return null;
    }

    private void putOutFire(PlayerEngineController mod, class_2338 pos) {
        Optional<Rotation> reach = LookHelper.getReach(mod, pos);
        if (reach.isPresent()) {
            IBaritone b = mod.getBaritone();
            if (LookHelper.isLookingAt(mod, pos)) {
                ((PathingBehavior)b.getPathingBehavior()).requestPause();
                b.getInputOverrideHandler().setInputForceState(Input.CLICK_LEFT, true);
                return;
            }
            LookHelper.lookAt(this.controller, reach.get());
        }
    }

    private void doForceField(PlayerEngineController mod) {
        this.killAura.tickStart();
        List<class_1297> entities = mod.getEntityTracker().getCloseEntities();
        try {
            for (class_1297 entity : entities) {
                if (entity == mod.getPlayer()) continue;
                boolean shouldForce = false;
                if (mod.getBehaviour().shouldExcludeFromForcefield(entity)) continue;
                if (entity instanceof class_1308) {
                    if (EntityHelper.isProbablyHostileToPlayer(mod, entity) && LookHelper.seesPlayer(entity, (class_1297)mod.getPlayer(), 10.0)) {
                        shouldForce = true;
                    }
                } else if (entity instanceof class_1674) {
                    shouldForce = true;
                }
                if (!shouldForce) continue;
                this.killAura.applyAura(entity);
            }
        }
        catch (Exception var6) {
            var6.printStackTrace();
        }
        this.killAura.tickEnd(mod);
    }

    private class_1548 getClosestFusingCreeper(PlayerEngineController mod) {
        double worstSafety = Double.POSITIVE_INFINITY;
        class_1548 target = null;
        try {
            for (class_1548 creeper : mod.getEntityTracker().getTrackedEntities(class_1548.class)) {
                double safety;
                if (creeper == null || (double)creeper.method_7003(1.0f) < 0.04 || !((safety = MobDefenseChain.getCreeperSafety(mod.getPlayer().method_19538(), creeper)) < worstSafety)) continue;
                target = creeper;
            }
            return target;
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException | ConcurrentModificationException var10) {
            Debug.logWarning("Weird Exception caught and ignored while scanning for creepers: " + var10.getMessage());
            return target;
        }
    }

    private boolean isProjectileClose(PlayerEngineController mod) {
        List<CachedProjectile> projectiles = mod.getEntityTracker().getProjectiles();
        try {
            for (CachedProjectile projectile : projectiles) {
                class_1309 clientPlayerEntity;
                boolean isGhastBall;
                if (!(projectile.position.method_1025(mod.getPlayer().method_19538()) < 150.0)) continue;
                boolean bl = isGhastBall = projectile.projectileType == class_1674.class;
                if (isGhastBall) {
                    Optional<class_1297> ghastBall = mod.getEntityTracker().getClosestEntity(class_1674.class);
                    Optional<class_1297> ghast = mod.getEntityTracker().getClosestEntity(class_1571.class);
                    if (ghastBall.isPresent() && ghast.isPresent() && this.runAwayTask == null && mod.getBaritone().getPathingBehavior().isSafeToCancel()) {
                        ((PathingBehavior)mod.getBaritone().getPathingBehavior()).requestPause();
                        LookHelper.lookAt(mod, ghast.get().method_33571());
                    }
                    return false;
                }
                if (projectile.projectileType == class_1670.class || (projectile.projectileType == class_1667.class || projectile.projectileType == class_1679.class || projectile.projectileType == class_1677.class) && (clientPlayerEntity = mod.getPlayer()).method_5707(projectile.position) < clientPlayerEntity.method_5707(projectile.position.method_1019(projectile.velocity))) continue;
                class_243 expectedHit = ProjectileHelper.calculateArrowClosestApproach(projectile, mod.getPlayer().method_19538());
                class_243 delta = mod.getPlayer().method_19538().method_1020(expectedHit);
                double horizontalDistanceSq = delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350;
                double verticalDistance = Math.abs(delta.field_1351);
                if (!(horizontalDistanceSq < 4.0) || !(verticalDistance < 10.0)) continue;
                if (mod.getBaritone().getPathingBehavior().isSafeToCancel() && MobDefenseChain.hasShield(mod)) {
                    ((PathingBehavior)mod.getBaritone().getPathingBehavior()).requestPause();
                    LookHelper.lookAt(mod, projectile.position.method_1031(0.0, 0.3, 0.0));
                }
                return true;
            }
        }
        catch (ConcurrentModificationException var12) {
            Debug.logWarning(var12.getMessage());
        }
        for (class_1613 skeleton : mod.getEntityTracker().getTrackedEntities(class_1613.class)) {
            if (skeleton.method_5739((class_1297)mod.getPlayer()) > 10.0f || !skeleton.method_6057((class_1297)mod.getPlayer()) || skeleton.method_6048() <= 15) continue;
            return true;
        }
        return false;
    }

    private Optional<class_1297> getUniversallyDangerousMob(PlayerEngineController mod) {
        Class[] dangerousMobs = new Class[]{class_7260.class, class_1528.class, class_1639.class, class_4760.class, class_5136.class, class_5419.class, class_1632.class};
        double range = 6.0;
        for (Class dangerous : dangerousMobs) {
            Optional<class_1297> entity = mod.getEntityTracker().getClosestEntity(dangerous);
            if (!entity.isPresent() || !(entity.get().method_5858((class_1297)mod.getPlayer()) < range * range) || !EntityHelper.isAngryAtPlayer(mod, entity.get())) continue;
            return entity;
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInDanger(PlayerEngineController mod) {
        boolean witchNearby = mod.getEntityTracker().entityFound(class_1640.class);
        double safeKeepDistance = 8.0;
        float health = mod.getPlayer().method_6032();
        if (health <= 10.0f && witchNearby) {
            safeKeepDistance = 30.0;
        }
        if (mod.getPlayer().method_6059(class_1294.field_5920) || mod.getPlayer().method_6059(class_1294.field_5899) && witchNearby) {
            safeKeepDistance = 30.0;
        }
        if (WorldHelper.isVulnerable(mod.getPlayer())) {
            try {
                class_1309 player = mod.getPlayer();
                List<class_1309> hostiles = mod.getEntityTracker().getHostiles();
                Object object = BaritoneHelper.MINECRAFT_LOCK;
                synchronized (object) {
                    for (class_1297 class_12972 : hostiles) {
                        if (!class_12972.method_24516((class_1297)player, safeKeepDistance) || mod.getBehaviour().shouldExcludeFromForcefield(class_12972) || !EntityHelper.isAngryAtPlayer(mod, class_12972) || class_12972 == mod.getPlayer()) continue;
                        return true;
                    }
                }
            }
            catch (Exception var13) {
                Debug.logWarning("Weird multithread exception. Will fix later. " + var13.getMessage());
            }
        }
        return false;
    }

    public void setTargetEntity(class_1297 entity) {
        this.targetEntity = entity;
    }

    public void resetTargetEntity() {
        this.targetEntity = null;
    }

    public void setForceFieldRange(double range) {
        this.killAura.setRange(range);
    }

    public void resetForceField() {
        this.killAura.setRange(Double.POSITIVE_INFINITY);
    }

    public boolean isDoingAcrobatics() {
        return this.doingFunkyStuff;
    }

    public boolean isPuttingOutFire() {
        return this.wasPuttingOutFire;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected void onTaskFinish(PlayerEngineController mod) {
    }

    @Override
    public String getName() {
        return "Mob Defense";
    }
}

