/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api.auth;

import com.player2.playerengine.automaton.utils.DirUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.class_2487;
import net.minecraft.class_2507;

public class TokenStorage {
    private static final Path PATH = DirUtil.getGameDir().resolve("playerengine_token_storage.dat");
    private static final TokenStorage INSTANCE = new TokenStorage();
    private class_2487 tokensStored = new class_2487();

    private TokenStorage() {
        this.load();
    }

    private String makeKey(String username, String clientId) {
        return username + ":" + clientId;
    }

    public static String getToken(String username, String clientId) {
        return TokenStorage.getInstance().tokensStored.method_10558(TokenStorage.getInstance().makeKey(username, clientId));
    }

    static void storeToken(String username, String clientId, String token) {
        System.out.println("[TokenStorage]: Storing token for player " + username + " and client " + clientId);
        TokenStorage.getInstance().tokensStored.method_10582(TokenStorage.getInstance().makeKey(username, clientId), token);
        TokenStorage.getInstance().save();
    }

    private void load() {
        if (Files.exists(PATH, new LinkOption[0])) {
            try {
                this.tokensStored = class_2507.method_30613((File)PATH.toFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void save() {
        System.out.println("[TokenStorage]: save() called");
        try {
            class_2507.method_30614((class_2487)this.tokensStored, (File)PATH.toFile());
            System.out.println("[TokenStorage]: Writing to file...");
        }
        catch (IOException e) {
            System.err.println("[TokenStorage]: Writing to file FAILED");
            e.printStackTrace();
        }
    }

    private static TokenStorage getInstance() {
        return INSTANCE;
    }
}

