/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.control.InputControls;
import com.player2.playerengine.tasks.base.ITaskRequiresGrounded;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.SafeRandomShimmyTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2356;

public abstract class CustomBaritoneGoalTask
extends Task
implements ITaskRequiresGrounded {
    private final Task wanderTask = new TimeoutWanderTask(5.0f, true);
    private final MovementProgressChecker stuckCheck = new MovementProgressChecker();
    private final boolean wander;
    protected MovementProgressChecker checker = new MovementProgressChecker();
    protected Goal cachedGoal = null;
    class_2248[] annoyingBlocks = new class_2248[]{class_2246.field_10597, class_2246.field_22117, class_2246.field_28675, class_2246.field_28676, class_2246.field_23078, class_2246.field_23079, class_2246.field_22124, class_2246.field_9983, class_2246.field_28682, class_2246.field_28683, class_2246.field_28684, class_2246.field_10214, class_2246.field_10479, class_2246.field_16999};
    private Task unstuckTask = null;

    public CustomBaritoneGoalTask(boolean wander) {
        this.wander = wander;
    }

    public CustomBaritoneGoalTask() {
        this(true);
    }

    private static class_2338[] generateSides(class_2338 pos) {
        return new class_2338[]{pos.method_10069(1, 0, 0), pos.method_10069(-1, 0, 0), pos.method_10069(0, 0, 1), pos.method_10069(0, 0, -1), pos.method_10069(1, 0, -1), pos.method_10069(1, 0, 1), pos.method_10069(-1, 0, -1), pos.method_10069(-1, 0, 1)};
    }

    private boolean isAnnoying(PlayerEngineController mod, class_2338 pos) {
        int b = 0;
        class_2248[] arrayOfBlock = this.annoyingBlocks;
        int i = arrayOfBlock.length;
        if (b >= i) {
            return false;
        }
        class_2248 AnnoyingBlocks = arrayOfBlock[b];
        return mod.getWorld().method_8320(pos).method_26204() == AnnoyingBlocks || mod.getWorld().method_8320(pos).method_26204() instanceof class_2323 || mod.getWorld().method_8320(pos).method_26204() instanceof class_2354 || mod.getWorld().method_8320(pos).method_26204() instanceof class_2349 || mod.getWorld().method_8320(pos).method_26204() instanceof class_2356;
    }

    private class_2338 stuckInBlock(PlayerEngineController mod) {
        class_2338[] toCheckHigh;
        class_2338[] toCheck;
        class_2338 p = mod.getPlayer().method_24515();
        if (this.isAnnoying(mod, p)) {
            return p;
        }
        if (this.isAnnoying(mod, p.method_10084())) {
            return p.method_10084();
        }
        for (class_2338 check : toCheck = CustomBaritoneGoalTask.generateSides(p)) {
            if (!this.isAnnoying(mod, check)) continue;
            return check;
        }
        for (class_2338 checkx : toCheckHigh = CustomBaritoneGoalTask.generateSides(p.method_10084())) {
            if (!this.isAnnoying(mod, checkx)) continue;
            return checkx;
        }
        return null;
    }

    private Task getFenceUnstuckTask() {
        return new SafeRandomShimmyTask();
    }

    @Override
    protected void onStart() {
        this.controller.getBaritone().getPathingBehavior().forceCancel();
        this.checker.reset();
        this.stuckCheck.reset();
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        InputControls controls = mod.getInputControls();
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.checker.reset();
        }
        if (WorldHelper.isInNetherPortal(this.controller)) {
            if (!mod.getBaritone().getPathingBehavior().isPathing()) {
                this.setDebugState("Getting out from nether portal");
                controls.hold(Input.SNEAK);
                controls.hold(Input.MOVE_FORWARD);
                return null;
            }
            controls.release(Input.SNEAK);
            controls.release(Input.MOVE_BACK);
            controls.release(Input.MOVE_FORWARD);
        } else if (mod.getBaritone().getPathingBehavior().isPathing()) {
            controls.release(Input.SNEAK);
            controls.release(Input.MOVE_BACK);
            controls.release(Input.MOVE_FORWARD);
        }
        if (this.unstuckTask != null && this.unstuckTask.isActive() && !this.unstuckTask.isFinished() && this.stuckInBlock(mod) != null) {
            this.setDebugState("Getting unstuck from block.");
            this.stuckCheck.reset();
            mod.getBaritone().getCustomGoalProcess().onLostControl();
            mod.getBaritone().getExploreProcess().onLostControl();
            return this.unstuckTask;
        }
        if (!this.checker.check(mod) || !this.stuckCheck.check(mod)) {
            class_2338 blockStuck = this.stuckInBlock(mod);
            if (blockStuck != null) {
                this.unstuckTask = this.getFenceUnstuckTask();
                return this.unstuckTask;
            }
            if (this.stuckCheck.lastBreakingBlock != null) {
                mod.getBaritone().getCustomGoalProcess().setGoalAndPath(this.cachedGoal);
            }
            this.stuckCheck.reset();
        }
        if (this.cachedGoal == null) {
            this.cachedGoal = this.newGoal(mod);
        }
        if (this.wander) {
            if (this.isFinished()) {
                this.checker.reset();
            } else {
                if (this.wanderTask.isActive() && !this.wanderTask.isFinished()) {
                    this.setDebugState("Wandering...");
                    this.checker.reset();
                    return this.wanderTask;
                }
                if (!this.checker.check(mod)) {
                    Debug.logMessage("Failed to make progress on goal, wandering.");
                    this.onWander(mod);
                    return this.wanderTask;
                }
            }
        }
        if (!mod.getBaritone().getCustomGoalProcess().isActive() && mod.getBaritone().getPathingBehavior().isSafeToCancel()) {
            mod.getBaritone().getCustomGoalProcess().setGoalAndPath(this.cachedGoal);
        }
        this.setDebugState("Completing goal.");
        return null;
    }

    @Override
    public boolean isFinished() {
        if (this.cachedGoal == null) {
            this.cachedGoal = this.newGoal(this.controller);
        }
        return this.cachedGoal != null && this.cachedGoal.isInGoal(this.controller.getPlayer().method_24515());
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBaritone().getPathingBehavior().forceCancel();
    }

    protected abstract Goal newGoal(PlayerEngineController var1);

    protected void onWander(PlayerEngineController mod) {
    }
}

