/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.CustomBaritoneGoalTask;
import com.player2.playerengine.util.baritone.GoalRunAwayFromEntities;
import com.player2.playerengine.util.helpers.BaritoneHelper;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1613;

public class RunAwayFromHostilesTask
extends CustomBaritoneGoalTask {
    private final double distanceToRun;
    private final boolean includeSkeletons;

    public RunAwayFromHostilesTask(double distance, boolean includeSkeletons) {
        this.distanceToRun = distance;
        this.includeSkeletons = includeSkeletons;
    }

    public RunAwayFromHostilesTask(double distance) {
        this(distance, false);
    }

    @Override
    protected Goal newGoal(PlayerEngineController mod) {
        mod.getBaritone().getPathingBehavior().forceCancel();
        return new GoalRunAwayFromHostiles(mod, this.distanceToRun);
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof RunAwayFromHostilesTask) {
            RunAwayFromHostilesTask task = (RunAwayFromHostilesTask)other;
            bl = Math.abs(task.distanceToRun - this.distanceToRun) < 1.0;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "NIGERUNDAYOO, SUMOOKEYY! distance=" + this.distanceToRun + ", skeletons=" + this.includeSkeletons;
    }

    private class GoalRunAwayFromHostiles
    extends GoalRunAwayFromEntities {
        public GoalRunAwayFromHostiles(PlayerEngineController mod, double distance) {
            super(mod, distance, false, 0.8);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<class_1297> getEntities(PlayerEngineController mod) {
            Stream<Object> stream = mod.getEntityTracker().getHostiles().stream();
            Object object = BaritoneHelper.MINECRAFT_LOCK;
            synchronized (object) {
                if (!RunAwayFromHostilesTask.this.includeSkeletons) {
                    stream = stream.filter(hostile -> !(hostile instanceof class_1613));
                }
                return stream.collect(Collectors.toList());
            }
        }
    }
}

