/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PutOutFireTask;
import com.player2.playerengine.tasks.entity.KillEntitiesTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.RunAwayFromHostilesTask;
import com.player2.playerengine.tasks.movement.SearchChunkForBlockTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1545;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class CollectBlazeRodsTask
extends ResourceTask {
    private static final double SPAWNER_BLAZE_RADIUS = 32.0;
    private static final double TOO_LITTLE_HEALTH_BLAZE = 10.0;
    private static final int TOO_MANY_BLAZES = 5;
    private final int count;
    private final Task searcher = new SearchChunkForBlockTask(class_2246.field_10266);
    private class_2338 foundBlazeSpawner = null;

    public CollectBlazeRodsTask(int count) {
        super(class_1802.field_8894, count);
        this.count = count;
    }

    private static boolean isHoveringAboveLavaOrTooHigh(PlayerEngineController mod, class_1297 entity) {
        int MAX_HEIGHT = 11;
        class_2338 check = entity.method_24515();
        while (entity.method_24515().method_10264() - check.method_10264() < MAX_HEIGHT) {
            if (mod.getWorld().method_8320(check).method_26204() == class_2246.field_10164) {
                return true;
            }
            if (WorldHelper.isSolidBlock(mod, check)) {
                return false;
            }
            check = check.method_10074();
        }
        return true;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (WorldHelper.getCurrentDimension(this.controller) != Dimension.NETHER) {
            this.setDebugState("Going to nether");
            return new DefaultGoToDimensionTask(Dimension.NETHER);
        }
        Optional<Object> toKill = Optional.empty();
        if (mod.getEntityTracker().entityFound(class_1545.class)) {
            class_3965 hit;
            class_1297 kill;
            class_243 nearest;
            double sqDistanceToPlayer;
            toKill = mod.getEntityTracker().getClosestEntity(class_1545.class);
            if (toKill.isPresent() && (double)mod.getPlayer().method_6032() <= 10.0 && mod.getEntityTracker().getTrackedEntities(class_1545.class).size() >= 5) {
                this.setDebugState("Running away as there are too many blazes nearby.");
                return new RunAwayFromHostilesTask(30.0, true);
            }
            if (this.foundBlazeSpawner != null && toKill.isPresent() && (sqDistanceToPlayer = (nearest = (kill = (class_1297)toKill.get()).method_19538()).method_1025(mod.getPlayer().method_19538())) > 1024.0 && (hit = mod.getWorld().method_17742(new class_3959(mod.getPlayer().method_5836(1.0f), kill.method_5836(1.0f), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)mod.getPlayer()))) != null && BlockPosVer.getSquaredDistance(hit.method_17777(), (class_2374)mod.getPlayer().method_19538()) < sqDistanceToPlayer) {
                toKill = Optional.empty();
            }
        }
        if (toKill.isPresent() && ((class_1297)toKill.get()).method_5805() && !CollectBlazeRodsTask.isHoveringAboveLavaOrTooHigh(mod, (class_1297)toKill.get())) {
            this.setDebugState("Killing blaze");
            Predicate<class_1297> safeToPursue = entity -> !CollectBlazeRodsTask.isHoveringAboveLavaOrTooHigh(mod, entity);
            return new KillEntitiesTask(safeToPursue, ((class_1297)toKill.get()).getClass());
        }
        if (this.foundBlazeSpawner != null && mod.getChunkTracker().isChunkLoaded(this.foundBlazeSpawner) && !this.isValidBlazeSpawner(mod, this.foundBlazeSpawner)) {
            Debug.logMessage("Blaze spawner at " + String.valueOf(this.foundBlazeSpawner) + " too far away or invalid. Re-searching.");
            this.foundBlazeSpawner = null;
        }
        if (this.foundBlazeSpawner != null) {
            if (!this.foundBlazeSpawner.method_19769((class_2374)mod.getPlayer().method_19538(), 4.0)) {
                this.setDebugState("Going to blaze spawner");
                return new GetToBlockTask(this.foundBlazeSpawner.method_10084(), false);
            }
            Optional<class_2338> nearestFire = mod.getBlockScanner().getNearestWithinRange(this.foundBlazeSpawner, 5.0, class_2246.field_10036);
            if (nearestFire.isPresent()) {
                this.setDebugState("Clearing fire around spawner to prevent loss of blaze rods.");
                return new PutOutFireTask(nearestFire.get());
            }
            this.setDebugState("Waiting near blaze spawner for blazes to spawn");
            return null;
        }
        Optional<class_2338> pos = mod.getBlockScanner().getNearestBlock(blockPos -> this.isValidBlazeSpawner(mod, (class_2338)blockPos), class_2246.field_10260);
        pos.ifPresent(blockPos -> {
            this.foundBlazeSpawner = blockPos;
        });
        this.setDebugState("Searching for fortress/Traveling around fortress");
        return this.searcher;
    }

    private boolean isValidBlazeSpawner(PlayerEngineController mod, class_2338 pos) {
        return !mod.getChunkTracker().isChunkLoaded(pos) ? false : WorldHelper.getSpawnerEntity(mod, pos) instanceof class_1545;
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectBlazeRodsTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collect blaze rods - " + this.controller.getItemStorage().getItemCount(class_1802.field_8894) + "/" + this.count;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }
}

