/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.slot;

import com.player2.playerengine.control.SlotHandler;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.util.slots.Slot;
import net.minecraft.class_1713;

public class ClickSlotTask
extends Task {
    private final Slot slot;
    private final int mouseButton;
    private final class_1713 type;
    private boolean clicked = false;

    public ClickSlotTask(Slot slot, int mouseButton, class_1713 type) {
        this.slot = slot;
        this.mouseButton = mouseButton;
        this.type = type;
    }

    public ClickSlotTask(Slot slot, class_1713 type) {
        this(slot, 0, type);
    }

    public ClickSlotTask(Slot slot, int mouseButton) {
        this(slot, mouseButton, class_1713.field_7790);
    }

    public ClickSlotTask(Slot slot) {
        this(slot, class_1713.field_7790);
    }

    @Override
    protected void onStart() {
        this.clicked = false;
    }

    @Override
    protected Task onTick() {
        SlotHandler slotHandler = this.controller.getSlotHandler();
        if (slotHandler.canDoSlotAction()) {
            slotHandler.clickSlot(this.slot, this.mouseButton, this.type);
            slotHandler.registerSlotAction();
            this.clicked = true;
        }
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task obj) {
        boolean bl;
        if (!(obj instanceof ClickSlotTask)) {
            bl = false;
        } else {
            ClickSlotTask task = (ClickSlotTask)obj;
            bl = task.mouseButton == this.mouseButton && task.type == this.type && task.slot.equals(this.slot);
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Clicking " + this.slot.toString();
    }

    @Override
    public boolean isFinished() {
        return this.clicked;
    }
}

