/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.speedrun.beatgame;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.commands.BlockScanner;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.GetRidOfExtraWaterBucketTask;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.SafeNetherPortalTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceBlockNearbyTask;
import com.player2.playerengine.tasks.construction.PlaceObsidianBucketTask;
import com.player2.playerengine.tasks.container.CraftInTableTask;
import com.player2.playerengine.tasks.container.LootContainerTask;
import com.player2.playerengine.tasks.container.SmeltInFurnaceTask;
import com.player2.playerengine.tasks.container.SmeltInSmokerTask;
import com.player2.playerengine.tasks.misc.EquipArmorTask;
import com.player2.playerengine.tasks.misc.PlaceBedAndSetSpawnTask;
import com.player2.playerengine.tasks.misc.SleepThroughNightTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.GetToXZTask;
import com.player2.playerengine.tasks.movement.GetWithinRangeOfBlockTask;
import com.player2.playerengine.tasks.movement.GoToStrongholdPortalTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.movement.SearchChunkForBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.resources.CollectBlazeRodsTask;
import com.player2.playerengine.tasks.resources.CollectBucketLiquidTask;
import com.player2.playerengine.tasks.resources.CollectFoodTask;
import com.player2.playerengine.tasks.resources.CollectMeatTask;
import com.player2.playerengine.tasks.resources.GetBuildingMaterialsTask;
import com.player2.playerengine.tasks.resources.KillEndermanTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.tasks.resources.TradeWithPiglinsTask;
import com.player2.playerengine.tasks.speedrun.BeatMinecraftConfig;
import com.player2.playerengine.tasks.speedrun.DragonBreathTracker;
import com.player2.playerengine.tasks.speedrun.KillEnderDragonTask;
import com.player2.playerengine.tasks.speedrun.KillEnderDragonWithBedsTask;
import com.player2.playerengine.tasks.speedrun.beatgame.UselessItems;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.prioritycalculators.CollectFoodPriorityCalculator;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.prioritycalculators.DistanceItemPriorityCalculator;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.prioritycalculators.ItemPriorityCalculator;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.prioritycalculators.StaticItemPriorityCalculator;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.tasks.ActionPriorityTask;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.tasks.CraftItemPriorityTask;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.tasks.MineBlockPriorityTask;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.tasks.PriorityTask;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.tasks.RecraftableItemPriorityTask;
import com.player2.playerengine.tasks.speedrun.beatgame.prioritytask.tasks.ResourcePriorityTask;
import com.player2.playerengine.trackers.EntityTracker;
import com.player2.playerengine.trackers.storage.ItemStorageTracker;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.Pair;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.SmeltTarget;
import com.player2.playerengine.util.helpers.ConfigHelper;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.slots.Slot;
import com.player2.playerengine.util.time.TimerGame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1560;
import net.minecraft.class_1588;
import net.minecraft.class_1604;
import net.minecraft.class_1614;
import net.minecraft.class_1640;
import net.minecraft.class_1713;
import net.minecraft.class_1743;
import net.minecraft.class_1777;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1890;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2333;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.apache.commons.lang3.ArrayUtils;

public class BeatMinecraftTask
extends Task {
    private static final class_1792[] COLLECT_EYE_ARMOR = new class_1792[]{class_1802.field_8058, class_1802.field_8348, class_1802.field_8285};
    private static final class_1792[] COLLECT_IRON_ARMOR = ItemHelper.IRON_ARMORS;
    private static final class_1792[] COLLECT_EYE_ARMOR_END = ItemHelper.DIAMOND_ARMORS;
    private static final ItemTarget[] COLLECT_EYE_GEAR_MIN = BeatMinecraftTask.combine(ItemTarget.of(class_1802.field_8802), ItemTarget.of(class_1802.field_8377));
    private static final int END_PORTAL_FRAME_COUNT = 12;
    private static final double END_PORTAL_BED_SPAWN_RANGE = 8.0;
    private static final Predicate<class_1799> noCurseOfBinding = stack -> !class_1890.method_8224((class_1799)stack);
    private static BeatMinecraftConfig config;
    private static GoToStrongholdPortalTask locateStrongholdTask;
    private static boolean openingEndPortal;
    private final UselessItems uselessItems;
    private final HashMap<class_1792, Integer> cachedEndItemDrops = new HashMap();
    private final TimerGame cachedEndItemNothingWaitTime = new TimerGame(10.0);
    private final Task buildMaterialsTask;
    private final PlaceBedAndSetSpawnTask setBedSpawnTask = new PlaceBedAndSetSpawnTask();
    private final Task getOneBedTask = TaskCatalogue.getItemTask("bed", 1);
    private final Task sleepThroughNightTask = new SleepThroughNightTask();
    private final Task killDragonBedStratsTask = new KillEnderDragonWithBedsTask();
    private final DragonBreathTracker dragonBreathTracker = new DragonBreathTracker();
    private final TimerGame timer1 = new TimerGame(5.0);
    private final TimerGame timer2 = new TimerGame(35.0);
    private final TimerGame timer3 = new TimerGame(60.0);
    private final List<PriorityTask> gatherResources = new LinkedList<PriorityTask>();
    private final TimerGame changedTaskTimer = new TimerGame(3.0);
    private final TimerGame forcedTaskTimer = new TimerGame(10.0);
    private final List<class_2338> blacklistedChests = new LinkedList<class_2338>();
    private final TimerGame waterPlacedTimer = new TimerGame(1.5);
    private final TimerGame fortressTimer = new TimerGame(20.0);
    private final PlayerEngineController mod;
    private PriorityTask lastGather = null;
    private Task lastTask = null;
    private boolean pickupFurnace = false;
    private boolean pickupSmoker = false;
    private boolean pickupCrafting = false;
    private Task rePickupTask = null;
    private Task searchTask = null;
    private boolean hasRods = false;
    private boolean gotToBiome = false;
    private GetRidOfExtraWaterBucketTask getRidOfExtraWaterBucketTask = null;
    private int repeated = 0;
    private boolean gettingPearls = false;
    private SafeNetherPortalTask safeNetherPortalTask;
    private boolean escaped = false;
    private boolean gotToFortress = false;
    private GetWithinRangeOfBlockTask cachedFortressTask = null;
    private boolean resetFortressTask = false;
    private class_2338 prevPos = null;
    private Task goToNetherTask = new DefaultGoToDimensionTask(Dimension.NETHER);
    private boolean dragonIsDead = false;
    private class_2338 endPortalCenterLocation;
    private boolean ranStrongholdLocator;
    private boolean endPortalOpened;
    private class_2338 bedSpawnLocation;
    private int cachedFilledPortalFrames = 0;
    private boolean enterindEndPortal = false;
    private Task lootTask;
    private boolean collectingEyes;
    private boolean escapingDragonsBreath = false;
    private Task getBedTask;
    private List<TaskChange> taskChanges = new ArrayList<TaskChange>();
    private PriorityTask prevLastGather = null;
    private class_2338 biomePos = null;

    public BeatMinecraftTask(PlayerEngineController mod) {
        this.mod = mod;
        locateStrongholdTask = new GoToStrongholdPortalTask(BeatMinecraftTask.config.targetEyes);
        this.buildMaterialsTask = new GetBuildingMaterialsTask(BeatMinecraftTask.config.buildMaterialCount);
        this.uselessItems = new UselessItems(config);
        if (mod.getWorld().method_8407() != class_1267.field_5805) {
            mod.logWarning("Detected that the difficulty is other than easy!");
            if (mod.getWorld().method_8407() == class_1267.field_5801) {
                mod.logWarning("No mobs spawn on peaceful difficulty, so the bot will not be able to beat the game. Please change it!");
            } else {
                mod.logWarning("This could cause the bot to die sooner, please consider changing it...");
            }
        }
        ItemStorageTracker itemStorage = mod.getItemStorage();
        this.gatherResources.add(new MineBlockPriorityTask(ItemHelper.itemsToBlocks(ItemHelper.LOG), ItemHelper.LOG, MiningRequirement.STONE, new DistanceItemPriorityCalculator(1050.0, 450.0, 5.0, 4, 10), a -> itemStorage.hasItem(class_1802.field_8062, class_1802.field_8475, class_1802.field_8825, class_1802.field_8556) && itemStorage.getItemCount(ItemHelper.LOG) < 5));
        this.addOreMiningTasks();
        this.addCollectFoodTask(mod);
        this.addStoneToolsTasks();
        this.addPickaxeTasks(mod);
        this.addDiamondArmorTasks(mod);
        this.addLootChestsTasks(mod);
        this.addPickupImportantItemsTask(mod);
        this.gatherResources.add(new MineBlockPriorityTask(new class_2248[]{class_2246.field_10255}, new class_1792[]{class_1802.field_8145}, MiningRequirement.STONE, new DistanceItemPriorityCalculator(17500.0, 7500.0, 5.0, 1, 1), a -> itemStorage.hasItem(class_1802.field_8776) && !itemStorage.hasItem(class_1802.field_8884)));
        this.gatherResources.add(new MineBlockPriorityTask(ItemHelper.itemsToBlocks(ItemHelper.BED), ItemHelper.BED, MiningRequirement.HAND, new DistanceItemPriorityCalculator(25000.0, 25000.0, 5.0, this.getTargetBeds(mod), this.getTargetBeds(mod))));
        this.gatherResources.add(new CraftItemPriorityTask(200.0, this.getRecipeTarget(class_1802.field_8255), a -> itemStorage.hasItem(class_1802.field_8620)));
        this.gatherResources.add(new CraftItemPriorityTask(300.0, mod.getCraftingRecipeTracker().getFirstRecipeTarget(class_1802.field_8550, 2), a -> itemStorage.getItemCount(class_1802.field_8620) >= 6));
        this.gatherResources.add(new CraftItemPriorityTask(100.0, this.getRecipeTarget(class_1802.field_8884), a -> itemStorage.hasItem(class_1802.field_8620) && itemStorage.hasItem(class_1802.field_8145)));
        this.gatherResources.add(new CraftItemPriorityTask(330.0, this.getRecipeTarget(class_1802.field_8802), a -> itemStorage.getItemCount(class_1802.field_8477) >= 2 && StorageHelper.miningRequirementMet(mod, MiningRequirement.DIAMOND)));
        this.gatherResources.add(new CraftItemPriorityTask(400.0, this.getRecipeTarget(class_1802.field_8862), a -> itemStorage.getItemCount(class_1802.field_8695) >= 5));
        this.addSleepTask(mod);
        this.gatherResources.add(new ActionPriorityTask(a -> {
            Pair<ResourceTask, Double> pair = new Pair<ResourceTask, Double>(TaskCatalogue.getItemTask(class_1802.field_8705, 1), Double.NEGATIVE_INFINITY);
            if (!itemStorage.hasItem(class_1802.field_8705) && !BeatMinecraftTask.hasItem(mod, class_1802.field_8705)) {
                Optional<class_2338> optionalPos = mod.getBlockScanner().getNearestBlock(class_2246.field_10382);
                if (optionalPos.isEmpty()) {
                    return pair;
                }
                double distance = Math.sqrt(BlockPosVer.getSquaredDistance(optionalPos.get(), (class_2374)mod.getPlayer().method_19538()));
                if (distance > 55.0) {
                    return pair;
                }
                pair.setRight(10.0 / distance * 77.3);
                return pair;
            }
            return pair;
        }, a -> itemStorage.hasItem(class_1802.field_8550), false, true, true));
        this.addSmeltTasks(mod);
        this.addCookFoodTasks(mod);
    }

    public static BeatMinecraftConfig getConfig() {
        if (config == null) {
            Debug.logInternal("Initializing BeatMinecraftConfig");
            config = new BeatMinecraftConfig();
        }
        return config;
    }

    private static List<class_2338> getFrameBlocks(PlayerEngineController mod, class_2338 endPortalCenter) {
        ArrayList<class_2338> frameBlocks = new ArrayList<class_2338>();
        for (class_2338 pos : mod.getBlockScanner().getKnownLocations(class_2246.field_10398)) {
            if (!pos.method_19771((class_2382)endPortalCenter, 20.0)) continue;
            frameBlocks.add(pos);
        }
        Debug.logInternal("Frame blocks: " + String.valueOf(frameBlocks));
        return frameBlocks;
    }

    private static ItemTarget[] combine(ItemTarget[] ... targets) {
        ArrayList<ItemTarget> combinedTargets = new ArrayList<ItemTarget>();
        for (ItemTarget[] targetArray : targets) {
            combinedTargets.addAll(Arrays.asList(targetArray));
        }
        Debug.logInternal("Combined Targets: " + String.valueOf(combinedTargets));
        ItemTarget[] combinedArray = combinedTargets.toArray(new ItemTarget[0]);
        Debug.logInternal("Combined Array: " + Arrays.toString(combinedArray));
        return combinedArray;
    }

    private static boolean isEndPortalFrameFilled(PlayerEngineController mod, class_2338 pos) {
        if (!mod.getChunkTracker().isChunkLoaded(pos)) {
            Debug.logInternal("Chunk is not loaded");
            return false;
        }
        class_2680 blockState = mod.getWorld().method_8320(pos);
        if (blockState.method_26204() != class_2246.field_10398) {
            Debug.logInternal("Block is not an End Portal Frame");
            return false;
        }
        boolean isFilled = (Boolean)blockState.method_11654((class_2769)class_2333.field_10958);
        Debug.logInternal("End Portal Frame is " + (isFilled ? "filled" : "not filled"));
        return isFilled;
    }

    public static boolean isTaskRunning(PlayerEngineController mod, Task task) {
        if (task == null) {
            Debug.logInternal("Task is null");
            return false;
        }
        boolean taskActive = task.isActive();
        boolean taskFinished = task.isFinished();
        Debug.logInternal("Task is not null");
        Debug.logInternal("Task is " + (taskActive ? "active" : "not active"));
        Debug.logInternal("Task is " + (taskFinished ? "finished" : "not finished"));
        return taskActive && !taskFinished;
    }

    public static void throwAwayItems(PlayerEngineController mod, class_1792 ... items) {
        BeatMinecraftTask.throwAwaySlots(mod, mod.getItemStorage().getSlotsWithItemPlayerInventory(false, items));
    }

    public static void throwAwaySlots(PlayerEngineController mod, List<Slot> slots) {
        for (Slot slot : slots) {
            if (Slot.isCursor(slot)) {
                mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, class_1713.field_7790);
                continue;
            }
            mod.getSlotHandler().clickSlot(slot, 0, class_1713.field_7790);
        }
    }

    public static boolean hasItem(PlayerEngineController mod, class_1792 item) {
        class_1309 player = mod.getPlayer();
        LivingEntityInventory inv = mod.getInventory();
        for (List list : List.of(inv.main, inv.armor, inv.offHand)) {
            for (class_1799 itemStack : list) {
                if (!itemStack.method_7909().equals(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getCountWithCraftedFromOre(PlayerEngineController mod, class_1792 item) {
        ItemStorageTracker itemStorage = mod.getItemStorage();
        if (item == class_1802.field_8713) {
            return itemStorage.getItemCount(item);
        }
        if (item == class_1802.field_33400) {
            int count = itemStorage.getItemCount(class_1802.field_33400, class_1802.field_8620);
            count += itemStorage.getItemCount(class_1802.field_8550, class_1802.field_8705, class_1802.field_8187, class_1802.field_28354, class_1802.field_27876) * 3;
            count += BeatMinecraftTask.hasItem(mod, class_1802.field_8255) ? 1 : 0;
            count += BeatMinecraftTask.hasItem(mod, class_1802.field_8884) ? 1 : 0;
            count += BeatMinecraftTask.hasItem(mod, class_1802.field_8371) ? 2 : 0;
            count += BeatMinecraftTask.hasItem(mod, class_1802.field_8403) ? 3 : 0;
            count += BeatMinecraftTask.hasItem(mod, class_1802.field_8743) ? 5 : 0;
            count += BeatMinecraftTask.hasItem(mod, class_1802.field_8523) ? 8 : 0;
            return (count += BeatMinecraftTask.hasItem(mod, class_1802.field_8396) ? 7 : 0) + (BeatMinecraftTask.hasItem(mod, class_1802.field_8660) ? 4 : 0);
        }
        if (item == class_1802.field_33402) {
            int count = itemStorage.getItemCount(class_1802.field_33402, class_1802.field_8695);
            count += BeatMinecraftTask.hasItem(mod, class_1802.field_8335) ? 3 : 0;
            count += BeatMinecraftTask.hasItem(mod, class_1802.field_8862) ? 5 : 0;
            count += BeatMinecraftTask.hasItem(mod, class_1802.field_8678) ? 8 : 0;
            return (count += BeatMinecraftTask.hasItem(mod, class_1802.field_8416) ? 7 : 0) + (BeatMinecraftTask.hasItem(mod, class_1802.field_8753) ? 4 : 0);
        }
        if (item == class_1802.field_8477) {
            int count = itemStorage.getItemCount(class_1802.field_8477);
            count += BeatMinecraftTask.hasItem(mod, class_1802.field_8802) ? 2 : 0;
            count += BeatMinecraftTask.hasItem(mod, class_1802.field_8377) ? 3 : 0;
            count += BeatMinecraftTask.hasItem(mod, class_1802.field_8805) ? 5 : 0;
            count += BeatMinecraftTask.hasItem(mod, class_1802.field_8058) ? 8 : 0;
            return (count += BeatMinecraftTask.hasItem(mod, class_1802.field_8348) ? 7 : 0) + (BeatMinecraftTask.hasItem(mod, class_1802.field_8285) ? 4 : 0);
        }
        throw new IllegalStateException("Invalid ore item: " + String.valueOf(item));
    }

    private static class_2248[] mapOreItemToBlocks(class_1792 item) {
        if (item.equals(class_1802.field_33400)) {
            return new class_2248[]{class_2246.field_29027, class_2246.field_10212};
        }
        if (item.equals(class_1802.field_33402)) {
            return new class_2248[]{class_2246.field_29026, class_2246.field_10571};
        }
        if (item.equals(class_1802.field_8477)) {
            return new class_2248[]{class_2246.field_29029, class_2246.field_10442};
        }
        if (item.equals(class_1802.field_8713)) {
            return new class_2248[]{class_2246.field_29219, class_2246.field_10418};
        }
        throw new IllegalStateException("Invalid ore: " + String.valueOf(item));
    }

    private void addSleepTask(PlayerEngineController mod) {
        boolean[] skipNight = new boolean[]{false};
        this.gatherResources.add(new ActionPriorityTask(a -> new PlaceBedAndSetSpawnTask(), () -> {
            if (!WorldHelper.canSleep(mod)) {
                skipNight[0] = false;
                return Double.NEGATIVE_INFINITY;
            }
            if (this.lastTask instanceof PlaceBedAndSetSpawnTask && this.lastTask.isFinished()) {
                skipNight[0] = true;
                mod.log("Failed to sleep :(");
                mod.log("Skipping night");
            }
            if (skipNight[0]) {
                return Double.NEGATIVE_INFINITY;
            }
            Optional<class_2338> pos = mod.getBlockScanner().getNearestBlock(ItemHelper.itemsToBlocks(ItemHelper.BED));
            return pos.isPresent() && pos.get().method_19769((class_2374)mod.getPlayer().method_19538(), 30.0) ? 1000000.0 : Double.NEGATIVE_INFINITY;
        }));
    }

    private RecipeTarget getRecipeTarget(class_1792 item) {
        ResourceTask task = TaskCatalogue.getItemTask(item, 1);
        if (task instanceof CraftInTableTask) {
            CraftInTableTask craftInTableTask = (CraftInTableTask)task;
            return craftInTableTask.getRecipeTargets()[0];
        }
        if (task instanceof CraftInInventoryTask) {
            CraftInInventoryTask craftInInventoryTask = (CraftInInventoryTask)task;
            return craftInInventoryTask.getRecipeTarget();
        }
        throw new IllegalStateException("Item isn't cataloged");
    }

    private void addPickupImportantItemsTask(PlayerEngineController mod) {
        List<class_1792> importantItems = List.of(class_1802.field_8403, class_1802.field_8377, class_1802.field_8862, class_1802.field_8802, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285, class_1802.field_8884);
        this.gatherResources.add(new ActionPriorityTask(mod1 -> {
            Pair<Object, Double> pair = new Pair<Object, Double>(null, 0.0);
            for (class_1792 item : importantItems) {
                if (item == class_1802.field_8403 && mod1.getItemStorage().hasItem(class_1802.field_8377) || mod1.getItemStorage().hasItem(item) || !mod1.getEntityTracker().itemDropped(item)) continue;
                pair.setLeft(new PickupDroppedItemTask(item, 1));
                pair.setRight(8000.0);
                return pair;
            }
            return pair;
        }));
    }

    private void addCookFoodTasks(PlayerEngineController mod) {
        this.gatherResources.add(new ActionPriorityTask(a -> {
            double priority;
            Pair<Object, Double> pair = new Pair<Object, Double>(null, Double.NEGATIVE_INFINITY);
            int rawFoodCount = a.getItemStorage().getItemCount(ItemHelper.RAW_FOODS);
            int readyFoodCount = a.getItemStorage().getItemCount(ItemHelper.COOKED_FOODS) + a.getItemStorage().getItemCount(class_1802.field_8229);
            double d = priority = rawFoodCount >= 8 ? 450.0 : (double)(rawFoodCount * 25);
            if (this.lastTask instanceof SmeltInSmokerTask) {
                priority = Double.POSITIVE_INFINITY;
            }
            if (readyFoodCount > 5 && priority < Double.POSITIVE_INFINITY) {
                priority = 0.01;
            }
            for (CollectFoodTask.CookableFoodTarget cookable : CollectMeatTask.COOKABLE_MEATS) {
                int rawCount = a.getItemStorage().getItemCount(cookable.getRaw());
                if (rawCount == 0) continue;
                int toSmelt = rawCount + a.getItemStorage().getItemCount(cookable.getCooked());
                SmeltTarget target = new SmeltTarget(new ItemTarget(cookable.cookedFood, toSmelt), new ItemTarget(cookable.rawFood, rawCount), new class_1792[0]);
                pair.setLeft(new SmeltInSmokerTask(target));
                pair.setRight(priority);
                return pair;
            }
            return pair;
        }, a -> StorageHelper.miningRequirementMet(mod, MiningRequirement.STONE), true, false, false));
    }

    private void addSmeltTasks(PlayerEngineController mod) {
        ItemStorageTracker itemStorage = mod.getItemStorage();
        this.gatherResources.add(new ActionPriorityTask(a -> {
            Pair<Object, Double> pair = new Pair<Object, Double>(null, Double.NEGATIVE_INFINITY);
            boolean hasSufficientPickaxe = itemStorage.hasItem(class_1802.field_8403, class_1802.field_8377);
            int neededIron = 11;
            if (itemStorage.hasItem(class_1802.field_8884)) {
                --neededIron;
            }
            if (BeatMinecraftTask.hasItem(mod, class_1802.field_8255)) {
                --neededIron;
            }
            if (hasSufficientPickaxe) {
                neededIron -= 3;
            }
            int count = itemStorage.getItemCount(class_1802.field_33400);
            int includedCount = count + itemStorage.getItemCount(class_1802.field_8620);
            if ((hasSufficientPickaxe || includedCount < 3) && (BeatMinecraftTask.hasItem(mod, class_1802.field_8255) || includedCount < 1) && includedCount < (neededIron -= Math.min(itemStorage.getItemCount(class_1802.field_8550, class_1802.field_8705, class_1802.field_8187), 2) * 3)) {
                return pair;
            }
            int toSmelt = Math.min(includedCount, neededIron);
            if (toSmelt <= 0) {
                return pair;
            }
            pair.setLeft(new SmeltInFurnaceTask(new SmeltTarget(new ItemTarget(class_1802.field_8620, toSmelt), new ItemTarget(class_1802.field_33400, toSmelt), new class_1792[0])));
            pair.setRight(350.0);
            return pair;
        }, a -> itemStorage.hasItem(class_1802.field_33400), true, false, false));
        this.gatherResources.add(new ActionPriorityTask(a -> new SmeltInFurnaceTask(new SmeltTarget(new ItemTarget(class_1802.field_8695, 5), new ItemTarget(class_1802.field_33402, 5), new class_1792[0])), () -> 140.0, a -> itemStorage.getItemCount(class_1802.field_33402, class_1802.field_8695) >= 5 && !itemStorage.hasItem(class_1802.field_8862), true, true, false));
    }

    private void addLootChestsTasks(PlayerEngineController mod) {
        this.gatherResources.add(new ActionPriorityTask(a -> {
            Pair<Object, Double> pair = new Pair<Object, Double>(null, Double.NEGATIVE_INFINITY);
            Optional<class_2338> chest = this.locateClosestUnopenedChest(mod);
            if (chest.isEmpty()) {
                return pair;
            }
            double dst = Math.sqrt(BlockPosVer.getSquaredDistance(chest.get(), (class_2374)mod.getPlayer().method_19538()));
            pair.setRight(30.0 / dst * 175.0);
            pair.setLeft(new GetToBlockTask(chest.get().method_10084()));
            return pair;
        }, a -> true, false, false, true));
        this.gatherResources.add(new ActionPriorityTask(m -> {
            Pair<Object, Double> pair = new Pair<Object, Double>(null, Double.NEGATIVE_INFINITY);
            Optional<class_2338> chest = this.locateClosestUnopenedChest(mod);
            if (chest.isEmpty()) {
                return pair;
            }
            if (LookHelper.cleanLineOfSight((class_1297)mod.getPlayer(), chest.get(), 10.0) && chest.get().method_19769((class_2374)mod.getPlayer().method_33571(), 5.0)) {
                pair.setLeft(new LootContainerTask(chest.get(), this.lootableItems(mod), noCurseOfBinding));
                pair.setRight(Double.POSITIVE_INFINITY);
            }
            return pair;
        }, a -> true, true, false, true));
    }

    private void addCollectFoodTask(PlayerEngineController mod) {
        LinkedList<class_1792> food = new LinkedList<class_1792>(ItemHelper.cookableFoodMap.values());
        food.addAll(ItemHelper.cookableFoodMap.keySet());
        food.addAll(List.of(class_1802.field_8861, class_1802.field_8229));
        this.gatherResources.add(new ResourcePriorityTask((ItemPriorityCalculator)new CollectFoodPriorityCalculator(mod, (double)BeatMinecraftTask.config.foodUnits), a -> StorageHelper.miningRequirementMet(mod, MiningRequirement.STONE) && mod.getItemStorage().hasItem(class_1802.field_8528, class_1802.field_8371, class_1802.field_8802) && CollectFoodTask.calculateFoodPotential(mod) < (double)BeatMinecraftTask.config.foodUnits, new CollectFoodTask(BeatMinecraftTask.config.foodUnits), ItemTarget.of(food.toArray(new class_1792[0]))));
        this.gatherResources.add(new ActionPriorityTask(mod12 -> {
            Pair<Object, Double> pair = new Pair<Object, Double>(null, 0.0);
            pair.setLeft(TaskCatalogue.getItemTask(class_1802.field_8861, mod12.getItemStorage().getItemCount(class_1802.field_17528) * 9 + mod12.getItemStorage().getItemCount(class_1802.field_8861)));
            pair.setRight(10.0);
            if (StorageHelper.calculateInventoryFoodScore(mod) < 5) {
                pair.setRight(270.0);
            }
            return pair;
        }, a -> mod.getItemStorage().hasItem(class_1802.field_17528)));
        this.gatherResources.add(new ActionPriorityTask(mod1 -> {
            Pair<Object, Double> pair = new Pair<Object, Double>(null, 0.0);
            pair.setLeft(TaskCatalogue.getItemTask("bread", mod1.getItemStorage().getItemCount(class_1802.field_8861) / 3 + mod1.getItemStorage().getItemCount(class_1802.field_8229)));
            pair.setRight(5.0);
            if (StorageHelper.calculateInventoryFoodScore(mod) < 5) {
                pair.setRight(250.0);
            }
            return pair;
        }, a -> mod.getItemStorage().getItemCount(class_1802.field_8861) >= 3));
    }

    private void addOreMiningTasks() {
        this.gatherResources.add(this.getOrePriorityTask(class_1802.field_8713, MiningRequirement.STONE, 1050, 250, 5, 4, 7));
        this.gatherResources.add(this.getOrePriorityTask(class_1802.field_33400, MiningRequirement.STONE, 1050, 250, 5, 11, 11));
        this.gatherResources.add(this.getOrePriorityTask(class_1802.field_33402, MiningRequirement.IRON, 1050, 250, 5, 5, 5));
        this.gatherResources.add(this.getOrePriorityTask(class_1802.field_8477, MiningRequirement.IRON, 1050, 250, 5, 27, 30));
    }

    private PriorityTask getOrePriorityTask(class_1792 item, MiningRequirement requirement, int multiplier, int unneededMultiplier, int unneededThreshold, int minCount, int maxCount) {
        class_2248[] blocks = BeatMinecraftTask.mapOreItemToBlocks(item);
        return new MineBlockPriorityTask(blocks, new class_1792[]{item}, requirement, new DistanceOrePriorityCalculator(item, multiplier, unneededMultiplier, unneededThreshold, minCount, maxCount));
    }

    private void addStoneToolsTasks() {
        this.gatherResources.add(new ResourcePriorityTask((ItemPriorityCalculator)StaticItemPriorityCalculator.of(520), altoClef -> StorageHelper.miningRequirementMet(this.mod, MiningRequirement.STONE), true, true, false, ItemTarget.of(class_1802.field_8062, class_1802.field_8528, class_1802.field_8776, class_1802.field_8431)));
        this.gatherResources.add(new CraftItemPriorityTask(300.0, this.getRecipeTarget(class_1802.field_8528), a -> StorageHelper.miningRequirementMet(this.mod, MiningRequirement.STONE) && !this.mod.getItemStorage().hasItem(class_1802.field_8802, class_1802.field_8371)));
        this.gatherResources.add(new CraftItemPriorityTask(300.0, this.getRecipeTarget(class_1802.field_8062), a -> StorageHelper.miningRequirementMet(this.mod, MiningRequirement.STONE) && !this.mod.getItemStorage().hasItem(class_1802.field_8556, class_1802.field_8475)));
    }

    private void addDiamondArmorTasks(PlayerEngineController mod) {
        this.gatherResources.add(new CraftItemPriorityTask(350.0, this.getRecipeTarget(class_1802.field_8058), a -> mod.getItemStorage().getItemCount(class_1802.field_8477) >= 8));
        this.gatherResources.add(new CraftItemPriorityTask(300.0, this.getRecipeTarget(class_1802.field_8348), a -> mod.getItemStorage().getItemCount(class_1802.field_8477) >= 7));
        this.gatherResources.add(new CraftItemPriorityTask(220.0, this.getRecipeTarget(class_1802.field_8285), a -> mod.getItemStorage().getItemCount(class_1802.field_8477) >= 5));
    }

    private void addPickaxeTasks(PlayerEngineController mod) {
        this.gatherResources.add(new ResourcePriorityTask((ItemPriorityCalculator)StaticItemPriorityCalculator.of(400), a -> !mod.getItemStorage().hasItem(class_1802.field_8647, class_1802.field_8387, class_1802.field_8403, class_1802.field_8377), ItemTarget.of(class_1802.field_8647)));
        this.gatherResources.add(new RecraftableItemPriorityTask(410.0, 10000.0, this.getRecipeTarget(class_1802.field_8387), a -> {
            List<Slot> list = mod.getItemStorage().getSlotsWithItemPlayerInventory(false, new class_1792[0]);
            boolean hasSafeIronPick = false;
            for (Slot slot : list) {
                class_1799 stack;
                if (slot.getInventorySlot() == -1 || StorageHelper.shouldSaveStack(mod, class_2246.field_10340, stack = mod.getBaritone().getEntityContext().inventory().method_5438(slot.getInventorySlot())) || !stack.method_7909().equals(class_1802.field_8403)) continue;
                hasSafeIronPick = true;
                break;
            }
            return StorageHelper.miningRequirementMet(mod, MiningRequirement.WOOD) && !mod.getItemStorage().hasItem(class_1802.field_8387) && !hasSafeIronPick && !mod.getItemStorage().hasItem(class_1802.field_8377);
        }));
        this.gatherResources.add(new CraftItemPriorityTask(420.0, this.getRecipeTarget(class_1802.field_8403), a -> !mod.getItemStorage().hasItem(class_1802.field_8403, class_1802.field_8377) && mod.getItemStorage().getItemCount(class_1802.field_8620) >= 3));
        this.gatherResources.add(new CraftItemPriorityTask(430.0, this.getRecipeTarget(class_1802.field_8377), a -> mod.getItemStorage().getItemCount(class_1802.field_8477) >= 3));
    }

    @Override
    public boolean isFinished() {
        if (WorldHelper.getCurrentDimension(this.mod) == Dimension.OVERWORLD && this.dragonIsDead) {
            Debug.logInternal("isFinished - Dragon is dead in the Overworld");
            return true;
        }
        Debug.logInternal("isFinished - Returning false");
        return false;
    }

    private boolean needsBuildingMaterials(PlayerEngineController mod) {
        int materialCount = StorageHelper.getBuildingMaterialCount(mod);
        boolean shouldForce = BeatMinecraftTask.isTaskRunning(mod, this.buildMaterialsTask);
        if (materialCount >= BeatMinecraftTask.config.minBuildMaterialCount && !shouldForce) {
            Debug.logInternal("Building materials not needed");
            return false;
        }
        Debug.logInternal("Building materials needed: " + materialCount);
        Debug.logInternal("Force build materials: " + shouldForce);
        return true;
    }

    private void updateCachedEndItems(PlayerEngineController mod) {
        List<class_1542> droppedItems = mod.getEntityTracker().getDroppedItems();
        if (droppedItems.isEmpty() && !this.cachedEndItemNothingWaitTime.elapsed()) {
            Debug.logInternal("No dropped items and cache wait time not elapsed.");
        } else {
            this.cachedEndItemNothingWaitTime.reset();
            this.cachedEndItemDrops.clear();
            for (class_1542 entity : droppedItems) {
                class_1792 item = entity.method_6983().method_7909();
                int count = entity.method_6983().method_7947();
                this.cachedEndItemDrops.put(item, this.cachedEndItemDrops.getOrDefault(item, 0) + count);
                Debug.logInternal("Added dropped item: " + String.valueOf(item) + " with count: " + count);
            }
        }
    }

    private List<class_1792> lootableItems(PlayerEngineController mod) {
        boolean hasEnoughGoldIngots;
        ArrayList<class_1792> lootable = new ArrayList<class_1792>();
        lootable.add(class_1802.field_8279);
        lootable.add(class_1802.field_8463);
        lootable.add(class_1802.field_8367);
        lootable.add(class_1802.field_8071);
        lootable.add(class_1802.field_8281);
        lootable.add(class_1802.field_8600);
        lootable.add(class_1802.field_8713);
        lootable.addAll(Arrays.stream(ItemHelper.LOG).toList());
        lootable.add(class_1802.field_8229);
        boolean isGoldenHelmetEquipped = StorageHelper.isArmorEquipped(mod, class_1802.field_8862);
        boolean hasGoldenHelmet = mod.getItemStorage().hasItemInventoryOnly(class_1802.field_8862);
        if (!mod.getItemStorage().hasItem(class_1802.field_8377, class_1802.field_8403)) {
            lootable.add(class_1802.field_8403);
        }
        if (mod.getItemStorage().getItemCount(class_1802.field_8550, class_1802.field_8705, class_1802.field_8187) < 2) {
            lootable.add(class_1802.field_8550);
        }
        boolean bl = hasEnoughGoldIngots = mod.getItemStorage().getItemCountInventoryOnly(class_1802.field_8695) >= 5;
        if (!isGoldenHelmetEquipped && !hasGoldenHelmet) {
            lootable.add(class_1802.field_8862);
        }
        if (!hasEnoughGoldIngots && !isGoldenHelmetEquipped && !hasGoldenHelmet || BeatMinecraftTask.config.barterPearlsInsteadOfEndermanHunt) {
            lootable.add(class_1802.field_8695);
        }
        lootable.add(class_1802.field_8884);
        if (!mod.getItemStorage().hasItemInventoryOnly(class_1802.field_8884) && !mod.getItemStorage().hasItemInventoryOnly(class_1802.field_8814)) {
            lootable.add(class_1802.field_8814);
        }
        if (!mod.getItemStorage().hasItemInventoryOnly(class_1802.field_8550) && !mod.getItemStorage().hasItemInventoryOnly(class_1802.field_8705)) {
            lootable.add(class_1802.field_8620);
        }
        if (!StorageHelper.itemTargetsMetInventory(mod, COLLECT_EYE_GEAR_MIN)) {
            lootable.add(class_1802.field_8477);
        }
        if (!mod.getItemStorage().hasItemInventoryOnly(class_1802.field_8145)) {
            lootable.add(class_1802.field_8145);
        }
        Debug.logInternal("Lootable items: " + String.valueOf(lootable));
        return lootable;
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.mod.getExtraBaritoneSettings().canWalkOnEndPortal(false);
        this.mod.getBehaviour().pop();
        Debug.logInternal("Stopped onStop method");
        Debug.logInternal("canWalkOnEndPortal set to false");
        Debug.logInternal("Behaviour popped");
        Debug.logInternal("Stopped tracking BED blocks");
        Debug.logInternal("Stopped tracking TRACK_BLOCKS");
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean isSameTask = other instanceof BeatMinecraftTask;
        if (!isSameTask) {
            Debug.logInternal("The 'other' task is not of type BeatMinecraftTask");
        }
        return isSameTask;
    }

    @Override
    protected String toDebugString() {
        return "Beating the game (Miran version).";
    }

    private boolean endPortalFound(PlayerEngineController mod, class_2338 endPortalCenter) {
        if (endPortalCenter == null) {
            Debug.logInternal("End portal center is null");
            return false;
        }
        return true;
    }

    private boolean endPortalOpened(PlayerEngineController mod, class_2338 endPortalCenter) {
        BlockScanner blockTracker;
        if (this.endPortalOpened && endPortalCenter != null && (blockTracker = mod.getBlockScanner()) != null) {
            boolean isValid = blockTracker.isBlockAtPosition(endPortalCenter, class_2246.field_10027);
            Debug.logInternal("End Portal is " + (isValid ? "valid" : "invalid"));
            return isValid;
        }
        Debug.logInternal("End Portal is not opened yet");
        return false;
    }

    private boolean spawnSetNearPortal(PlayerEngineController mod, class_2338 endPortalCenter) {
        if (this.bedSpawnLocation == null) {
            Debug.logInternal("Bed spawn location is null");
            return false;
        }
        BlockScanner blockTracker = mod.getBlockScanner();
        boolean isValid = blockTracker.isBlockAtPosition(this.bedSpawnLocation, ItemHelper.itemsToBlocks(ItemHelper.BED));
        Debug.logInternal("Spawn set near portal: " + isValid);
        return isValid;
    }

    private Optional<class_2338> locateClosestUnopenedChest(PlayerEngineController mod) {
        return !WorldHelper.getCurrentDimension(mod).equals((Object)Dimension.OVERWORLD) ? Optional.empty() : mod.getBlockScanner().getNearestBlock(blockPos -> {
            if (this.blacklistedChests.contains(blockPos)) {
                return false;
            }
            boolean isUnopenedChest = WorldHelper.isUnopenedChest(mod, blockPos);
            boolean isWithinDistance = mod.getPlayer().method_24515().method_19771((class_2382)blockPos, 150.0);
            boolean isLootableChest = this.canBeLootablePortalChest(mod, (class_2338)blockPos);
            Optional<class_2338> nearestSpawner = mod.getBlockScanner().getNearestBlock(WorldHelper.toVec3d(blockPos), class_2246.field_10260);
            if (nearestSpawner.isPresent() && nearestSpawner.get().method_19771((class_2382)blockPos, 6.0)) {
                this.blacklistedChests.add((class_2338)blockPos);
                return false;
            }
            class_238 box = new class_238((double)(blockPos.method_10263() - 5), (double)(blockPos.method_10264() - 5), (double)(blockPos.method_10260() - 5), (double)(blockPos.method_10263() + 5), (double)(blockPos.method_10264() + 5), (double)(blockPos.method_10260() + 5));
            Stream<class_2680> states = class_2338.method_29715((class_238)box).map(pos -> mod.getWorld().method_8320(pos));
            if (states.anyMatch(state -> state.method_26204().equals(class_2246.field_10382))) {
                this.blacklistedChests.add((class_2338)blockPos);
                return false;
            }
            Debug.logInternal("isUnopenedChest: " + isUnopenedChest);
            Debug.logInternal("isWithinDistance: " + isWithinDistance);
            Debug.logInternal("isLootableChest: " + isLootableChest);
            return isUnopenedChest && isWithinDistance && isLootableChest;
        }, class_2246.field_10034);
    }

    @Override
    protected void onStart() {
        this.resetTimers();
        this.mod.getBehaviour().push();
        this.addThrowawayItemsWarning(this.mod);
        this.addProtectedItems(this.mod);
        this.allowWalkingOnEndPortal(this.mod);
        this.avoidDragonBreath(this.mod);
        this.avoidBreakingBed(this.mod);
        this.mod.getBehaviour().avoidBlockBreaking(pos -> this.mod.getWorld().method_8320(pos).method_26204().equals(class_2246.field_10316));
    }

    private void resetTimers() {
        this.timer1.reset();
        this.timer2.reset();
        this.timer3.reset();
    }

    private void addThrowawayItemsWarning(PlayerEngineController mod) {
        String settingsWarningTail = "in \".minecraft/playerengine_settings.json\". @gamer may break if you don't add this! (sorry!)";
        if (!ArrayUtils.contains((Object[])mod.getModSettings().getThrowawayItems(mod), (Object)class_1802.field_20399)) {
            Debug.logWarning("\"end_stone\" is not part of your \"throwawayItems\" list " + settingsWarningTail);
        }
        if (!mod.getModSettings().shouldThrowawayUnusedItems()) {
            Debug.logWarning("\"throwawayUnusedItems\" is not set to true " + settingsWarningTail);
        }
    }

    private void addProtectedItems(PlayerEngineController mod) {
        mod.getBehaviour().addProtectedItems(class_1802.field_8449, class_1802.field_8894, class_1802.field_8183, class_1802.field_8634, class_1802.field_8465, class_1802.field_8620, class_1802.field_8705, class_1802.field_8884, class_1802.field_8255, class_1802.field_8868, class_1802.field_8550, class_1802.field_8862, class_1802.field_16309, class_1802.field_8732);
        mod.getBehaviour().addProtectedItems(ItemHelper.BED);
        mod.getBehaviour().addProtectedItems(ItemHelper.IRON_ARMORS);
        mod.getBehaviour().addProtectedItems(ItemHelper.LOG);
        Debug.logInternal("Protected items added successfully.");
    }

    private void allowWalkingOnEndPortal(PlayerEngineController mod) {
        mod.getBehaviour().allowWalkingOn(blockPos -> {
            if (this.enterindEndPortal && mod.getChunkTracker().isChunkLoaded((class_2338)blockPos)) {
                boolean isEndPortal;
                class_2680 blockState = mod.getWorld().method_8320(blockPos);
                boolean bl = isEndPortal = blockState.method_26204() == class_2246.field_10027;
                if (isEndPortal) {
                    Debug.logInternal("Walking on End Portal at " + blockPos.toString());
                }
                return isEndPortal;
            }
            return false;
        });
    }

    private void avoidDragonBreath(PlayerEngineController mod) {
        mod.getBehaviour().avoidWalkingThrough(blockPos -> {
            Dimension currentDimension = WorldHelper.getCurrentDimension(mod);
            boolean isEndDimension = currentDimension == Dimension.END;
            boolean isTouchingDragonBreath = this.dragonBreathTracker.isTouchingDragonBreath((class_2338)blockPos);
            if (isEndDimension && !this.escapingDragonsBreath && isTouchingDragonBreath) {
                Debug.logInternal("Avoiding dragon breath at blockPos: " + String.valueOf(blockPos));
                return true;
            }
            return false;
        });
    }

    private void avoidBreakingBed(PlayerEngineController mod) {
        mod.getBehaviour().avoidBlockBreaking(blockPos -> {
            boolean shouldAvoidBreaking;
            if (this.bedSpawnLocation == null) {
                return false;
            }
            class_2338 bedHead = WorldHelper.getBedHead(mod, this.bedSpawnLocation);
            class_2338 bedFoot = WorldHelper.getBedFoot(mod, this.bedSpawnLocation);
            boolean bl = shouldAvoidBreaking = blockPos.equals((Object)bedHead) || blockPos.equals((Object)bedFoot);
            if (shouldAvoidBreaking) {
                Debug.logInternal("Avoiding breaking bed at block position: " + String.valueOf(blockPos));
            }
            return shouldAvoidBreaking;
        });
    }

    private void blackListDangerousBlock(PlayerEngineController mod, class_2248 block) {
        Optional<class_2338> nearestTracking = mod.getBlockScanner().getNearestBlock(block);
        if (nearestTracking.isPresent()) {
            for (class_1297 entity : mod.getWorld().method_27909()) {
                if (mod.getBlockScanner().isUnreachable(nearestTracking.get()) || !(entity instanceof class_1588) || !(mod.getPlayer().method_5707(entity.method_19538()) < 150.0) || !nearestTracking.get().method_19769((class_2374)entity.method_19538(), 30.0)) continue;
                Debug.logMessage("Blacklisting dangerous " + block.toString());
                mod.getBlockScanner().requestBlockUnreachable(nearestTracking.get(), 0);
            }
        }
    }

    @Override
    protected Task onTick() {
        ItemStorageTracker itemStorage = this.mod.getItemStorage();
        double blockPlacementPenalty = 10.0;
        if (StorageHelper.getNumberOfThrowawayBlocks(this.mod) > 128) {
            blockPlacementPenalty = 5.0;
        } else if (StorageHelper.getNumberOfThrowawayBlocks(this.mod) > 64) {
            blockPlacementPenalty = 7.5;
        }
        this.mod.getBaritoneSettings().blockPlacementPenalty.set(blockPlacementPenalty);
        if (this.mod.getPlayer().method_6047().method_7909() instanceof class_1777 && !openingEndPortal) {
            for (class_1799 itemStack : itemStorage.getItemStacksPlayerInventory(true)) {
                class_1792 item = itemStack.method_7909();
                if (!(item instanceof class_1829) && !(item instanceof class_1743)) continue;
                this.mod.getSlotHandler().forceEquipItem(item);
            }
        }
        boolean shouldSwap = false;
        boolean hasInHotbar = false;
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = this.mod.getBaritone().getEntityContext().inventory().method_5438(i);
            if (stack.method_7909().equals(class_1802.field_8403) && StorageHelper.shouldSaveStack(this.mod, class_2246.field_10340, stack)) {
                shouldSwap = true;
            }
            if (!stack.method_7909().equals(class_1802.field_8387)) continue;
            hasInHotbar = true;
        }
        if (shouldSwap && !hasInHotbar && itemStorage.hasItem(class_1802.field_8387)) {
            this.mod.getSlotHandler().forceEquipItem(class_1802.field_8387);
        }
        boolean eyeGearSatisfied = StorageHelper.isArmorEquippedAll(this.mod, COLLECT_EYE_ARMOR);
        boolean ironGearSatisfied = StorageHelper.isArmorEquippedAll(this.mod, COLLECT_IRON_ARMOR);
        if (itemStorage.hasItem(class_1802.field_8377)) {
            this.mod.getBehaviour().setBlockBreakAdditionalPenalty(1.2);
        } else {
            this.mod.getBehaviour().setBlockBreakAdditionalPenalty((Double)this.mod.getBaritoneSettings().blockBreakAdditionalPenalty.defaultValue);
        }
        Predicate<Task> isCraftingTableTask = task -> task instanceof CraftInTableTask;
        for (class_2338 craftingTable : this.mod.getBlockScanner().getKnownLocations(class_2246.field_9980)) {
            Optional<class_1297> witch;
            if (itemStorage.hasItem(class_1802.field_8465) && !this.thisOrChildSatisfies(isCraftingTableTask) && !this.mod.getBlockScanner().isUnreachable(craftingTable)) {
                Debug.logMessage("Blacklisting extra crafting table.");
                this.mod.getBlockScanner().requestBlockUnreachable(craftingTable, 0);
            }
            if (this.mod.getBlockScanner().isUnreachable(craftingTable)) continue;
            class_2680 craftingTablePosUp = this.mod.getWorld().method_8320(craftingTable.method_10086(2));
            if (this.mod.getEntityTracker().entityFound(class_1640.class) && (witch = this.mod.getEntityTracker().getClosestEntity(class_1640.class)).isPresent() && craftingTable.method_19769((class_2374)witch.get().method_19538(), 15.0)) {
                Debug.logMessage("Blacklisting witch crafting table.");
                this.mod.getBlockScanner().requestBlockUnreachable(craftingTable, 0);
            }
            if (craftingTablePosUp.method_26204() != class_2246.field_10446) continue;
            Debug.logMessage("Blacklisting pillage crafting table.");
            this.mod.getBlockScanner().requestBlockUnreachable(craftingTable, 0);
        }
        for (class_2338 smoker : this.mod.getBlockScanner().getKnownLocations(class_2246.field_16334)) {
            if (!itemStorage.hasItem(class_1802.field_16309) || this.mod.getBlockScanner().isUnreachable(smoker)) continue;
            Debug.logMessage("Blacklisting extra smoker.");
            this.mod.getBlockScanner().requestBlockUnreachable(smoker, 0);
        }
        for (class_2338 furnace : this.mod.getBlockScanner().getKnownLocations(class_2246.field_10181)) {
            if (!itemStorage.hasItem(class_1802.field_8732) || this.goToNetherTask.isActive() || this.ranStrongholdLocator || this.mod.getBlockScanner().isUnreachable(furnace)) continue;
            Debug.logMessage("Blacklisting extra furnace.");
            this.mod.getBlockScanner().requestBlockUnreachable(furnace, 0);
        }
        for (class_2338 log : this.mod.getBlockScanner().getKnownLocations(ItemHelper.itemsToBlocks(ItemHelper.LOG))) {
            for (class_1297 entity : this.mod.getWorld().method_27909()) {
                if (!(entity instanceof class_1604) || this.mod.getBlockScanner().isUnreachable(log) || !log.method_19769((class_2374)entity.method_19538(), 40.0)) continue;
                Debug.logMessage("Blacklisting pillage log.");
                this.mod.getBlockScanner().requestBlockUnreachable(log, 0);
            }
            if (log.method_10264() >= 62 || this.mod.getBlockScanner().isUnreachable(log) || ironGearSatisfied || eyeGearSatisfied) continue;
            Debug.logMessage("Blacklisting dangerous log.");
            this.mod.getBlockScanner().requestBlockUnreachable(log, 0);
        }
        if (!ironGearSatisfied && !eyeGearSatisfied) {
            this.blackListDangerousBlock(this.mod, class_2246.field_29219);
            this.blackListDangerousBlock(this.mod, class_2246.field_10418);
            this.blackListDangerousBlock(this.mod, class_2246.field_29027);
            this.blackListDangerousBlock(this.mod, class_2246.field_10212);
        }
        List<class_2248> ancientCityBlocks = List.of(class_2246.field_28900, class_2246.field_37568, class_2246.field_37569, class_2246.field_28108, class_2246.field_37571, class_2246.field_28897, class_2246.field_29222, class_2246.field_22110, class_2246.field_28896, class_2246.field_28892);
        int radius = 5;
        block7: for (class_2338 pos2 : this.mod.getBlockScanner().getKnownLocations(ItemHelper.itemsToBlocks(ItemHelper.WOOL))) {
            for (int x = -5; x < 5; ++x) {
                for (int y = -5; y < 5; ++y) {
                    for (int z = -5; z < 5; ++z) {
                        class_2338 p2 = pos2.method_10069(x, y, z);
                        class_2248 block = this.mod.getWorld().method_8320(p2).method_26204();
                        if (!ancientCityBlocks.contains(block)) continue;
                        Debug.logMessage("Blacklisting ancient city wool " + String.valueOf(pos2));
                        this.mod.getBlockScanner().requestBlockUnreachable(pos2, 0);
                        continue block7;
                    }
                }
            }
        }
        if (locateStrongholdTask.isActive() && WorldHelper.getCurrentDimension(this.mod) == Dimension.OVERWORLD && !this.mod.getBaritone().getExploreProcess().isActive() && this.timer1.elapsed()) {
            this.timer1.reset();
        }
        if ((this.getOneBedTask != null && this.getOneBedTask.isActive() || this.sleepThroughNightTask.isActive() && !itemStorage.hasItem(ItemHelper.BED)) && this.getBedTask == null && !this.mod.getBaritone().getExploreProcess().isActive() && this.timer3.elapsed()) {
            this.timer3.reset();
        }
        if (WorldHelper.getCurrentDimension(this.mod) != Dimension.END && itemStorage.hasItem(class_1802.field_8255) && !itemStorage.hasItemInOffhand(this.controller, class_1802.field_8255)) {
            return new EquipArmorTask(class_1802.field_8255);
        }
        if (WorldHelper.getCurrentDimension(this.mod) == Dimension.NETHER) {
            if (itemStorage.hasItem(class_1802.field_8862)) {
                return new EquipArmorTask(class_1802.field_8862);
            }
            if (itemStorage.hasItem(class_1802.field_8805) && !BeatMinecraftTask.hasItem(this.mod, class_1802.field_8862)) {
                return new EquipArmorTask(class_1802.field_8805);
            }
        } else if (itemStorage.hasItem(class_1802.field_8805)) {
            return new EquipArmorTask(class_1802.field_8805);
        }
        if (itemStorage.hasItem(class_1802.field_8058)) {
            return new EquipArmorTask(class_1802.field_8058);
        }
        if (itemStorage.hasItem(class_1802.field_8348)) {
            return new EquipArmorTask(class_1802.field_8348);
        }
        if (itemStorage.hasItem(class_1802.field_8285)) {
            return new EquipArmorTask(class_1802.field_8285);
        }
        if (itemStorage.getItemCount(class_1802.field_8732) > 1) {
            return new PlaceBlockNearbyTask(p -> this.controller.getWorld().method_8320(p).method_26204() != class_2246.field_9980, class_2246.field_10181);
        }
        if (itemStorage.getItemCount(class_1802.field_8465) > 1) {
            return new PlaceBlockNearbyTask(class_2246.field_9980);
        }
        BeatMinecraftTask.throwAwayItems(this.mod, class_1802.field_8858, class_1802.field_8200);
        BeatMinecraftTask.throwAwayItems(this.mod, class_1802.field_8810);
        BeatMinecraftTask.throwAwayItems(this.mod, this.uselessItems.uselessItems);
        if (itemStorage.hasItem(class_1802.field_8387, class_1802.field_8403, class_1802.field_8377)) {
            BeatMinecraftTask.throwAwayItems(this.mod, class_1802.field_8647);
        }
        if (itemStorage.hasItem(class_1802.field_8377)) {
            BeatMinecraftTask.throwAwayItems(this.mod, class_1802.field_8403, class_1802.field_8387);
        }
        if (itemStorage.hasItem(class_1802.field_8802)) {
            BeatMinecraftTask.throwAwayItems(this.mod, class_1802.field_8528, class_1802.field_8371);
        }
        if (itemStorage.hasItem(class_1802.field_8862)) {
            BeatMinecraftTask.throwAwayItems(this.mod, class_1802.field_33402, class_1802.field_8695);
        }
        if (itemStorage.hasItem(class_1802.field_8145) || itemStorage.hasItem(class_1802.field_8884)) {
            BeatMinecraftTask.throwAwayItems(this.mod, class_1802.field_8110);
        }
        if (itemStorage.hasItem(class_1802.field_8884)) {
            BeatMinecraftTask.throwAwayItems(this.mod, class_1802.field_8145);
        }
        if (BeatMinecraftTask.isTaskRunning(this.mod, this.getRidOfExtraWaterBucketTask)) {
            return this.getRidOfExtraWaterBucketTask;
        }
        if (itemStorage.getItemCount(class_1802.field_8705) > 1) {
            this.getRidOfExtraWaterBucketTask = new GetRidOfExtraWaterBucketTask();
            return this.getRidOfExtraWaterBucketTask;
        }
        if (itemStorage.getItemCount(class_1802.field_8884) > 1) {
            BeatMinecraftTask.throwAwayItems(this.mod, class_1802.field_8884);
        }
        if (itemStorage.getItemCount(ItemHelper.BED) > this.getTargetBeds(this.mod) && !this.endPortalFound(this.mod, this.endPortalCenterLocation) && WorldHelper.getCurrentDimension(this.mod) != Dimension.END) {
            BeatMinecraftTask.throwAwayItems(this.mod, ItemHelper.BED);
        }
        this.enterindEndPortal = false;
        if (WorldHelper.getCurrentDimension(this.mod) != Dimension.END) {
            this.cachedEndItemNothingWaitTime.reset();
            if (!this.endPortalOpened(this.mod, this.endPortalCenterLocation) && WorldHelper.getCurrentDimension(this.mod) == Dimension.OVERWORLD) {
                Optional<class_2338> endPortal = this.mod.getBlockScanner().getNearestBlock(class_2246.field_10027);
                if (endPortal.isPresent()) {
                    this.endPortalCenterLocation = endPortal.get();
                    this.endPortalOpened = true;
                } else {
                    this.endPortalCenterLocation = this.doSimpleSearchForEndPortal(this.mod);
                }
            }
            if (BeatMinecraftTask.isTaskRunning(this.mod, this.rePickupTask)) {
                return this.rePickupTask;
            }
            if (!this.endPortalOpened && WorldHelper.getCurrentDimension(this.mod) != Dimension.END && BeatMinecraftTask.config.rePickupCraftingTable && !itemStorage.hasItem(class_1802.field_8465) && !this.thisOrChildSatisfies(isCraftingTableTask) && (this.mod.getBlockScanner().anyFound(blockPos -> WorldHelper.canBreak(this.mod, blockPos) && WorldHelper.canReach(this.mod, blockPos), class_2246.field_9980) || this.mod.getEntityTracker().itemDropped(class_1802.field_8465)) && this.pickupCrafting) {
                this.setDebugState("Picking up the crafting table while we are at it.");
                return new MineAndCollectTask(class_1802.field_8465, 1, new class_2248[]{class_2246.field_9980}, MiningRequirement.HAND);
            }
            if (BeatMinecraftTask.config.rePickupSmoker && !this.endPortalOpened && WorldHelper.getCurrentDimension(this.mod) != Dimension.END && !itemStorage.hasItem(class_1802.field_16309) && (this.mod.getBlockScanner().anyFound(blockPos -> WorldHelper.canBreak(this.mod, blockPos) && WorldHelper.canReach(this.mod, blockPos), class_2246.field_16334) || this.mod.getEntityTracker().itemDropped(class_1802.field_16309)) && this.pickupSmoker) {
                this.setDebugState("Picking up the smoker while we are at it.");
                this.rePickupTask = new MineAndCollectTask(class_1802.field_16309, 1, new class_2248[]{class_2246.field_16334}, MiningRequirement.WOOD);
                return this.rePickupTask;
            }
            if (BeatMinecraftTask.config.rePickupFurnace && !this.endPortalOpened && WorldHelper.getCurrentDimension(this.mod) != Dimension.END && !itemStorage.hasItem(class_1802.field_8732) && (this.mod.getBlockScanner().anyFound(blockPos -> WorldHelper.canBreak(this.mod, blockPos) && WorldHelper.canReach(this.mod, blockPos), class_2246.field_10181) || this.mod.getEntityTracker().itemDropped(class_1802.field_8732)) && !this.goToNetherTask.isActive() && !this.ranStrongholdLocator && this.pickupFurnace) {
                this.setDebugState("Picking up the furnace while we are at it.");
                this.rePickupTask = new MineAndCollectTask(class_1802.field_8732, 1, new class_2248[]{class_2246.field_10181}, MiningRequirement.WOOD);
                return this.rePickupTask;
            }
            this.pickupFurnace = false;
            this.pickupSmoker = false;
            this.pickupCrafting = false;
            if (BeatMinecraftTask.config.sleepThroughNight && !this.endPortalOpened && WorldHelper.getCurrentDimension(this.mod) == Dimension.OVERWORLD) {
                if (WorldHelper.canSleep(this.mod)) {
                    if (this.timer2.elapsed()) {
                        this.timer2.reset();
                    }
                    if (this.timer2.getDuration() >= 30.0 && !this.mod.getPlayer().method_6113()) {
                        if (this.mod.getEntityTracker().itemDropped(ItemHelper.BED) && this.needsBeds(this.mod)) {
                            this.setDebugState("Resetting sleep through night task.");
                            return new PickupDroppedItemTask(new ItemTarget(ItemHelper.BED), true);
                        }
                        if (this.anyBedsFound(this.mod)) {
                            this.setDebugState("Resetting sleep through night task.");
                            return new DoToClosestBlockTask(DestroyBlockTask::new, ItemHelper.itemsToBlocks(ItemHelper.BED));
                        }
                    }
                    this.setDebugState("Sleeping through night");
                    return this.sleepThroughNightTask;
                }
                if (!itemStorage.hasItem(ItemHelper.BED) && (this.mod.getBlockScanner().anyFound(blockPos -> WorldHelper.canBreak(this.mod, blockPos), ItemHelper.itemsToBlocks(ItemHelper.BED)) || BeatMinecraftTask.isTaskRunning(this.mod, this.getOneBedTask))) {
                    this.setDebugState("Getting one bed to sleep in at night.");
                    return this.getOneBedTask;
                }
            }
            boolean needsEyes = !this.endPortalOpened(this.mod, this.endPortalCenterLocation) && WorldHelper.getCurrentDimension(this.mod) != Dimension.END;
            int filledPortalFrames = this.getFilledPortalFrames(this.mod, this.endPortalCenterLocation);
            int eyesNeededMin = needsEyes ? BeatMinecraftTask.config.minimumEyes - filledPortalFrames : 0;
            int eyesNeeded = needsEyes ? BeatMinecraftTask.config.targetEyes - filledPortalFrames : 0;
            int eyes = itemStorage.getItemCount(class_1802.field_8449);
            if (eyes >= eyesNeededMin && (this.ranStrongholdLocator || !this.collectingEyes || eyes >= eyesNeeded)) {
                List<Slot> ironArmors;
                class_1792[] throwGearItems;
                this.collectingEyes = false;
                if (itemStorage.getItemCount(class_1802.field_8477) >= 3 && !itemStorage.hasItem(class_1802.field_8377, class_1802.field_8403)) {
                    return TaskCatalogue.getItemTask(class_1802.field_8377, 1);
                }
                if (itemStorage.getItemCount(class_1802.field_8620) >= 3 && !itemStorage.hasItem(class_1802.field_8377, class_1802.field_8403)) {
                    return TaskCatalogue.getItemTask(class_1802.field_8403, 1);
                }
                if (!itemStorage.hasItem(class_1802.field_8377, class_1802.field_8403, class_1802.field_8387)) {
                    return TaskCatalogue.getItemTask(class_1802.field_8387, 1);
                }
                if (!itemStorage.hasItem(class_1802.field_8377, class_1802.field_8403, class_1802.field_8387, class_1802.field_8647)) {
                    return TaskCatalogue.getItemTask(class_1802.field_8647, 1);
                }
                if (WorldHelper.getCurrentDimension(this.mod) == Dimension.OVERWORLD) {
                    Optional<class_2338> silverfish;
                    if (itemStorage.hasItem(class_1802.field_8377)) {
                        throwGearItems = new class_1792[]{class_1802.field_8528, class_1802.field_8387, class_1802.field_8371, class_1802.field_8403};
                        ironArmors = itemStorage.getSlotsWithItemPlayerInventory(true, COLLECT_IRON_ARMOR);
                        List<Slot> throwGears = itemStorage.getSlotsWithItemPlayerInventory(true, throwGearItems);
                        if (itemStorage.hasItem(class_1802.field_8884) || itemStorage.hasItem(class_1802.field_8814)) {
                            for (Slot throwGear : throwGears) {
                                if (Slot.isCursor(throwGear)) {
                                    if (!this.mod.getControllerExtras().isBreakingBlock()) {
                                        LookHelper.randomOrientation(this.controller);
                                    }
                                    this.mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, class_1713.field_7790);
                                    continue;
                                }
                                this.mod.getSlotHandler().clickSlot(throwGear, 0, class_1713.field_7790);
                            }
                            for (Slot ironArmor : ironArmors) {
                                if (Slot.isCursor(ironArmor)) {
                                    if (!this.mod.getControllerExtras().isBreakingBlock()) {
                                        LookHelper.randomOrientation(this.controller);
                                    }
                                    this.mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, class_1713.field_7790);
                                    continue;
                                }
                                this.mod.getSlotHandler().clickSlot(ironArmor, 0, class_1713.field_7790);
                            }
                        }
                    }
                    this.ranStrongholdLocator = true;
                    if (WorldHelper.getCurrentDimension(this.mod) == Dimension.OVERWORLD && this.needsBeds(this.mod)) {
                        this.setDebugState("Getting beds before stronghold search.");
                        if (!this.mod.getBaritone().getExploreProcess().isActive() && this.timer1.elapsed()) {
                            this.timer1.reset();
                        }
                        this.getBedTask = this.getBedTask(this.mod);
                        return this.getBedTask;
                    }
                    this.getBedTask = null;
                    if (!itemStorage.hasItem(class_1802.field_8705)) {
                        this.setDebugState("Getting water bucket.");
                        return TaskCatalogue.getItemTask(class_1802.field_8705, 1);
                    }
                    if (!itemStorage.hasItem(class_1802.field_8884)) {
                        this.setDebugState("Getting flint and steel.");
                        return TaskCatalogue.getItemTask(class_1802.field_8884, 1);
                    }
                    if (this.needsBuildingMaterials(this.mod)) {
                        this.setDebugState("Collecting building materials.");
                        return this.buildMaterialsTask;
                    }
                    if (!this.endPortalFound(this.mod, this.endPortalCenterLocation)) {
                        this.setDebugState("Locating End Portal...");
                        return locateStrongholdTask;
                    }
                    if (StorageHelper.miningRequirementMetInventory(this.controller, MiningRequirement.WOOD) && (silverfish = this.mod.getBlockScanner().getNearestBlock(blockPos -> WorldHelper.getSpawnerEntity(this.mod, blockPos) instanceof class_1614, class_2246.field_10260)).isPresent()) {
                        this.setDebugState("Breaking silverfish spawner.");
                        return new DestroyBlockTask(silverfish.get());
                    }
                    if (this.endPortalOpened(this.mod, this.endPortalCenterLocation)) {
                        openingEndPortal = false;
                        if (this.needsBuildingMaterials(this.mod)) {
                            this.setDebugState("Collecting building materials.");
                            return this.buildMaterialsTask;
                        }
                        if (BeatMinecraftTask.config.placeSpawnNearEndPortal && itemStorage.hasItem(ItemHelper.BED) && !this.spawnSetNearPortal(this.mod, this.endPortalCenterLocation)) {
                            this.setDebugState("Setting spawn near end portal");
                            return this.setSpawnNearPortalTask(this.mod);
                        }
                        this.setDebugState("Entering End");
                        this.enterindEndPortal = true;
                        if (!this.mod.getExtraBaritoneSettings().isCanWalkOnEndPortal()) {
                            this.mod.getExtraBaritoneSettings().canWalkOnEndPortal(true);
                        }
                        return new DoToClosestBlockTask(blockPos -> new GetToBlockTask(blockPos.method_10084()), class_2246.field_10027);
                    }
                    if (itemStorage.hasItem(class_1802.field_8281)) {
                        this.setDebugState("Opening End Portal");
                        openingEndPortal = true;
                        return new DoToClosestBlockTask(blockPos -> new InteractWithBlockTask(class_1802.field_8449, (class_2338)blockPos), blockPos -> !BeatMinecraftTask.isEndPortalFrameFilled(this.mod, blockPos), class_2246.field_10398);
                    }
                    if (!this.mod.getBlockScanner().anyFoundWithinDistance(10.0, class_2246.field_10540) && !this.mod.getEntityTracker().itemDropped(class_1802.field_8281)) {
                        if (this.repeated > 2 && !itemStorage.hasItem(class_1802.field_8705)) {
                            return new CollectBucketLiquidTask.CollectWaterBucketTask(1);
                        }
                        if (!this.waterPlacedTimer.elapsed()) {
                            this.setDebugState("" + this.waterPlacedTimer.getDuration());
                            return null;
                        }
                        if (!itemStorage.hasItem(class_1802.field_8705)) {
                            ++this.repeated;
                            this.waterPlacedTimer.reset();
                            return null;
                        }
                        this.repeated = 0;
                        return new PlaceObsidianBucketTask(this.mod.getBlockScanner().getNearestBlock(WorldHelper.toVec3d(this.endPortalCenterLocation), blockPos -> !blockPos.method_19771((class_2382)this.endPortalCenterLocation, 8.0), class_2246.field_10164).get());
                    }
                    if (!itemStorage.hasItem(class_1802.field_8705)) {
                        return new CollectBucketLiquidTask.CollectWaterBucketTask(1);
                    }
                    if (!this.waterPlacedTimer.elapsed()) {
                        this.setDebugState("waitin " + this.waterPlacedTimer.getDuration());
                        return null;
                    }
                    return TaskCatalogue.getItemTask(class_1802.field_8281, 1);
                }
                if (WorldHelper.getCurrentDimension(this.mod) != Dimension.NETHER) {
                    return null;
                }
                throwGearItems = new class_1792[]{class_1802.field_8528, class_1802.field_8387, class_1802.field_8371, class_1802.field_8403};
                ironArmors = itemStorage.getSlotsWithItemPlayerInventory(true, COLLECT_IRON_ARMOR);
                List<Slot> throwGears = itemStorage.getSlotsWithItemPlayerInventory(true, throwGearItems);
                if (itemStorage.hasItem(class_1802.field_8884) || itemStorage.hasItem(class_1802.field_8814)) {
                    for (Slot throwGearx : throwGears) {
                        if (Slot.isCursor(throwGearx)) {
                            if (!this.mod.getControllerExtras().isBreakingBlock()) {
                                LookHelper.randomOrientation(this.controller);
                            }
                            this.mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, class_1713.field_7790);
                            continue;
                        }
                        this.mod.getSlotHandler().clickSlot(throwGearx, 0, class_1713.field_7790);
                    }
                    for (Slot ironArmorx : ironArmors) {
                        if (Slot.isCursor(ironArmorx)) {
                            if (!this.mod.getControllerExtras().isBreakingBlock()) {
                                LookHelper.randomOrientation(this.controller);
                            }
                            this.mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, class_1713.field_7790);
                            continue;
                        }
                        this.mod.getSlotHandler().clickSlot(ironArmorx, 0, class_1713.field_7790);
                    }
                }
                this.setDebugState("Locating End Portal...");
                return locateStrongholdTask;
            }
            this.collectingEyes = true;
            return this.getEyesOfEnderTask(this.mod, eyesNeeded);
        }
        if (!this.mod.getWorld().method_8393(0, 0)) {
            this.setDebugState("Waiting for chunks to load");
            return null;
        }
        this.updateCachedEndItems(this.mod);
        if (!this.mod.getEntityTracker().itemDropped(ItemHelper.BED) || !this.needsBeds(this.mod) && WorldHelper.getCurrentDimension(this.mod) != Dimension.END) {
            if (!itemStorage.hasItem(class_1802.field_8403, class_1802.field_8377)) {
                if (this.mod.getEntityTracker().itemDropped(class_1802.field_8403)) {
                    return new PickupDroppedItemTask(class_1802.field_8403, 1);
                }
                if (this.mod.getEntityTracker().itemDropped(class_1802.field_8377)) {
                    return new PickupDroppedItemTask(class_1802.field_8377, 1);
                }
            }
            if (!itemStorage.hasItem(class_1802.field_8705) && this.mod.getEntityTracker().itemDropped(class_1802.field_8705)) {
                return new PickupDroppedItemTask(class_1802.field_8705, 1);
            }
            for (class_1792 armorCheck : COLLECT_EYE_ARMOR_END) {
                if (StorageHelper.isArmorEquipped(this.mod, armorCheck)) continue;
                if (itemStorage.hasItem(armorCheck)) {
                    this.setDebugState("Equipping armor.");
                    return new EquipArmorTask(armorCheck);
                }
                if (!this.mod.getEntityTracker().itemDropped(armorCheck)) continue;
                return new PickupDroppedItemTask(armorCheck, 1);
            }
            this.dragonBreathTracker.updateBreath(this.mod);
            for (class_2338 playerIn : WorldHelper.getBlocksTouchingPlayer(this.controller.getPlayer())) {
                if (!this.dragonBreathTracker.isTouchingDragonBreath(playerIn)) continue;
                this.setDebugState("ESCAPE dragons breath");
                this.escapingDragonsBreath = true;
                return this.dragonBreathTracker.getRunAwayTask();
            }
            this.escapingDragonsBreath = false;
            if (this.mod.getBlockScanner().anyFound(class_2246.field_10027)) {
                this.setDebugState("WOOHOO");
                this.dragonIsDead = true;
                this.enterindEndPortal = true;
                if (!this.mod.getExtraBaritoneSettings().isCanWalkOnEndPortal()) {
                    this.mod.getExtraBaritoneSettings().canWalkOnEndPortal(true);
                }
                return new DoToClosestBlockTask(blockPos -> new GetToBlockTask(blockPos.method_10084()), pos -> Math.abs(pos.method_10263()) + Math.abs(pos.method_10260()) <= 1, class_2246.field_10027);
            }
            if (!itemStorage.hasItem(ItemHelper.BED) && !this.mod.getBlockScanner().anyFound(ItemHelper.itemsToBlocks(ItemHelper.BED))) {
                this.setDebugState("No beds, regular strats.");
                return new KillEnderDragonTask();
            }
            this.setDebugState("Bed strats");
            return this.killDragonBedStratsTask;
        }
        return new PickupDroppedItemTask(new ItemTarget(ItemHelper.BED), true);
    }

    private Task setSpawnNearPortalTask(PlayerEngineController mod) {
        this.bedSpawnLocation = this.setBedSpawnTask.isSpawnSet() ? this.setBedSpawnTask.getBedSleptPos() : null;
        if (BeatMinecraftTask.isTaskRunning(mod, this.setBedSpawnTask)) {
            this.setDebugState("Setting spawnpoint now.");
            return this.setBedSpawnTask;
        }
        if (WorldHelper.inRangeXZ((class_1297)mod.getPlayer(), WorldHelper.toVec3d(this.endPortalCenterLocation), 8.0)) {
            return this.setBedSpawnTask;
        }
        this.setDebugState("Approaching portal (to set spawnpoint)");
        return new GetToXZTask(this.endPortalCenterLocation.method_10263(), this.endPortalCenterLocation.method_10260());
    }

    private Task getBlazeRodsTask(PlayerEngineController mod, int count) {
        EntityTracker entityTracker = mod.getEntityTracker();
        if (entityTracker.itemDropped(class_1802.field_8894)) {
            Debug.logInternal("Blaze Rod dropped, picking it up.");
            return new PickupDroppedItemTask(class_1802.field_8894, 1);
        }
        if (entityTracker.itemDropped(class_1802.field_8183)) {
            Debug.logInternal("Blaze Powder dropped, picking it up.");
            return new PickupDroppedItemTask(class_1802.field_8183, 1);
        }
        Debug.logInternal("No Blaze Rod or Blaze Powder dropped, collecting Blaze Rods.");
        return new CollectBlazeRodsTask(count);
    }

    private Task getEnderPearlTask(PlayerEngineController mod, int count) {
        Optional<class_1297> toKill;
        if (mod.getEntityTracker().itemDropped(class_1802.field_8634)) {
            return new PickupDroppedItemTask(class_1802.field_8634, 1);
        }
        if (BeatMinecraftTask.config.barterPearlsInsteadOfEndermanHunt) {
            return !StorageHelper.isArmorEquipped(mod, class_1802.field_8862) ? new EquipArmorTask(class_1802.field_8862) : new TradeWithPiglinsTask(32, class_1802.field_8634, count);
        }
        boolean endermanFound = mod.getEntityTracker().entityFound(class_1560.class);
        boolean pearlDropped = mod.getEntityTracker().itemDropped(class_1802.field_8634);
        if ((endermanFound || pearlDropped) && (toKill = mod.getEntityTracker().getClosestEntity(class_1560.class)).isPresent() && mod.getEntityTracker().isEntityReachable(toKill.get())) {
            return new KillEndermanTask(count);
        }
        this.setDebugState("Waiting for endermen to spawn... ");
        return null;
    }

    private int getTargetBeds(PlayerEngineController mod) {
        boolean needsToSetSpawn = BeatMinecraftTask.config.placeSpawnNearEndPortal && !this.spawnSetNearPortal(mod, this.endPortalCenterLocation) && !BeatMinecraftTask.isTaskRunning(mod, this.setBedSpawnTask);
        int bedsInEnd = Arrays.stream(ItemHelper.BED).mapToInt(bed -> this.cachedEndItemDrops.getOrDefault(bed, 0)).sum();
        int targetBeds = BeatMinecraftTask.config.requiredBeds + (needsToSetSpawn ? 1 : 0) - bedsInEnd;
        Debug.logInternal("needsToSetSpawn: " + needsToSetSpawn);
        Debug.logInternal("bedsInEnd: " + bedsInEnd);
        Debug.logInternal("targetBeds: " + targetBeds);
        return targetBeds;
    }

    private boolean needsBeds(PlayerEngineController mod) {
        int totalEndItems = 0;
        for (class_1792 bed : ItemHelper.BED) {
            totalEndItems += this.cachedEndItemDrops.getOrDefault(bed, 0).intValue();
        }
        int itemCount = mod.getItemStorage().getItemCount(ItemHelper.BED);
        int targetBeds = this.getTargetBeds(mod);
        Debug.logInternal("Total End Items: " + totalEndItems);
        Debug.logInternal("Item Count: " + itemCount);
        Debug.logInternal("Target Beds: " + targetBeds);
        boolean needsBeds = itemCount + totalEndItems < targetBeds;
        Debug.logInternal("Needs Beds: " + needsBeds);
        return needsBeds;
    }

    private Task getBedTask(PlayerEngineController mod) {
        int targetBeds = this.getTargetBeds(mod);
        if (!mod.getItemStorage().hasItem(class_1802.field_8868) && !this.anyBedsFound(mod)) {
            Debug.logInternal("Getting shears.");
            return TaskCatalogue.getItemTask(class_1802.field_8868, 1);
        }
        Debug.logInternal("Getting beds.");
        return TaskCatalogue.getItemTask("bed", targetBeds);
    }

    private boolean anyBedsFound(PlayerEngineController mod) {
        BlockScanner blockTracker = mod.getBlockScanner();
        EntityTracker entityTracker = mod.getEntityTracker();
        boolean bedsFoundInBlocks = blockTracker.anyFound(ItemHelper.itemsToBlocks(ItemHelper.BED));
        boolean bedsFoundInEntities = entityTracker.itemDropped(ItemHelper.BED);
        if (bedsFoundInBlocks) {
            Debug.logInternal("Beds found in blocks");
        }
        if (bedsFoundInEntities) {
            Debug.logInternal("Beds found in entities");
        }
        return bedsFoundInBlocks || bedsFoundInEntities;
    }

    private class_2338 doSimpleSearchForEndPortal(PlayerEngineController mod) {
        List<class_2338> frames = mod.getBlockScanner().getKnownLocations(class_2246.field_10398);
        if (frames.size() >= 12) {
            class_243 average = frames.stream().reduce(class_243.field_1353, (accum, bpos) -> accum.method_1031((double)((int)Math.round((double)bpos.method_10263() + 0.5)), (double)((int)Math.round((double)bpos.method_10264() + 0.5)), (double)((int)Math.round((double)bpos.method_10260() + 0.5))), class_243::method_1019).method_1021(1.0 / (double)frames.size());
            mod.log("Average Position: " + String.valueOf(average));
            return new class_2338(new class_2382((int)average.field_1352, (int)average.field_1351, (int)average.field_1350));
        }
        Debug.logInternal("Not enough frames");
        return null;
    }

    private int getFilledPortalFrames(PlayerEngineController mod, class_2338 endPortalCenter) {
        if (endPortalCenter == null) {
            return 0;
        }
        List<class_2338> frameBlocks = BeatMinecraftTask.getFrameBlocks(mod, endPortalCenter);
        if (frameBlocks.stream().allMatch(blockPos -> mod.getChunkTracker().isChunkLoaded((class_2338)blockPos))) {
            this.cachedFilledPortalFrames = frameBlocks.stream().mapToInt(blockPos -> {
                boolean isFilled = BeatMinecraftTask.isEndPortalFrameFilled(mod, blockPos);
                if (isFilled) {
                    Debug.logInternal("Portal frame at " + String.valueOf(blockPos) + " is filled.");
                } else {
                    Debug.logInternal("Portal frame at " + String.valueOf(blockPos) + " is not filled.");
                }
                return isFilled ? 1 : 0;
            }).sum();
        }
        return this.cachedFilledPortalFrames;
    }

    private boolean canBeLootablePortalChest(PlayerEngineController mod, class_2338 blockPos) {
        return mod.getWorld().method_8320(blockPos.method_10084()).method_26204() != class_2246.field_10382 && blockPos.method_10264() >= 50;
    }

    private Task getEyesOfEnderTask(PlayerEngineController mod, int targetEyes) {
        boolean needsEnderPearls;
        if (mod.getEntityTracker().itemDropped(class_1802.field_8449)) {
            this.setDebugState("Picking up Dropped Eyes");
            return new PickupDroppedItemTask(class_1802.field_8449, targetEyes);
        }
        int eyeCount = mod.getItemStorage().getItemCount(class_1802.field_8449);
        int blazePowderCount = mod.getItemStorage().getItemCount(class_1802.field_8183);
        int blazeRodCount = mod.getItemStorage().getItemCount(class_1802.field_8894);
        int blazeRodTarget = (int)Math.ceil((double)(targetEyes - eyeCount - blazePowderCount) / 2.0);
        int enderPearlTarget = targetEyes - eyeCount;
        boolean needsBlazeRods = blazeRodCount < blazeRodTarget;
        boolean needsBlazePowder = eyeCount + blazePowderCount < targetEyes;
        boolean bl = needsEnderPearls = mod.getItemStorage().getItemCount(class_1802.field_8634) < enderPearlTarget;
        if (needsBlazePowder && !needsBlazeRods) {
            this.setDebugState("Crafting blaze powder");
            return TaskCatalogue.getItemTask(class_1802.field_8183, targetEyes - eyeCount);
        }
        if (!needsBlazePowder && !needsEnderPearls) {
            this.setDebugState("Crafting Ender Eyes");
            return TaskCatalogue.getItemTask(class_1802.field_8449, targetEyes);
        }
        switch (WorldHelper.getCurrentDimension(mod)) {
            case OVERWORLD: {
                PriorityTask toGather = null;
                double maxPriority = 0.0;
                if (!this.gatherResources.isEmpty()) {
                    if (!this.forcedTaskTimer.elapsed() && BeatMinecraftTask.isTaskRunning(mod, this.lastTask) && this.lastGather != null && this.lastGather.calculatePriority(mod) > 0.0) {
                        return this.lastTask;
                    }
                    if (!this.changedTaskTimer.elapsed() && this.lastTask != null && !this.lastGather.bypassForceCooldown && BeatMinecraftTask.isTaskRunning(mod, this.lastTask)) {
                        return this.lastTask;
                    }
                    if (BeatMinecraftTask.isTaskRunning(mod, this.lastTask) && this.lastGather != null && this.lastGather.shouldForce()) {
                        return this.lastTask;
                    }
                    for (PriorityTask gatherResource : this.gatherResources) {
                        double priority = gatherResource.calculatePriority(mod);
                        if (!(priority > maxPriority)) continue;
                        maxPriority = priority;
                        toGather = gatherResource;
                    }
                }
                if (toGather != null) {
                    boolean sameTask = this.lastGather == toGather;
                    this.setDebugState("Priority: " + String.format(Locale.US, "%.2f", maxPriority) + ", " + String.valueOf(toGather));
                    if (!sameTask && this.prevLastGather == toGather && this.lastTask != null && this.lastGather.calculatePriority(mod) > 0.0 && BeatMinecraftTask.isTaskRunning(mod, this.lastTask)) {
                        mod.logWarning("might be stuck or switching too much, forcing current resource for a bit more");
                        this.changedTaskTimer.reset();
                        this.prevLastGather = null;
                        this.setDebugState("Priority: FORCED, " + String.valueOf(this.lastGather));
                        return this.lastTask;
                    }
                    if (sameTask && toGather.canCache()) {
                        return this.lastTask;
                    }
                    if (!sameTask) {
                        this.taskChanges.add(0, new TaskChange(this.lastGather, toGather, mod.getPlayer().method_24515()));
                    }
                    if (this.taskChanges.size() >= 3 && !sameTask) {
                        TaskChange t1 = this.taskChanges.get(0);
                        TaskChange t2 = this.taskChanges.get(1);
                        TaskChange t3 = this.taskChanges.get(2);
                        if (t1.original == t2.interrupt && t1.pos.method_19771((class_2382)t3.pos, 5.0) && t3.original == t1.interrupt) {
                            this.forcedTaskTimer.reset();
                            mod.logWarning("Probably stuck! Forcing timer...");
                            this.taskChanges.clear();
                            return this.lastTask;
                        }
                        if (this.taskChanges.size() > 3) {
                            this.taskChanges.remove(this.taskChanges.size() - 1);
                        }
                    }
                    this.prevLastGather = this.lastGather;
                    this.lastGather = toGather;
                    Task task = toGather.getTask(mod);
                    if (!sameTask) {
                        if (this.lastTask instanceof SmeltInFurnaceTask && !(task instanceof SmeltInFurnaceTask) && !mod.getItemStorage().hasItem(class_1802.field_8732)) {
                            this.pickupFurnace = true;
                            this.lastGather = null;
                            this.lastTask = null;
                            return null;
                        }
                        if (this.lastTask instanceof SmeltInSmokerTask && !(task instanceof SmeltInSmokerTask) && !mod.getItemStorage().hasItem(class_1802.field_16309)) {
                            this.pickupSmoker = true;
                            this.lastGather = null;
                            this.lastTask = null;
                            return null;
                        }
                        if (this.lastTask != null && task != null && !toGather.needCraftingOnStart(mod)) {
                            this.pickupCrafting = true;
                            this.lastGather = null;
                            this.lastTask = null;
                            return null;
                        }
                    }
                    this.lastTask = task;
                    this.changedTaskTimer.reset();
                    return task;
                }
                if (this.needsBuildingMaterials(mod)) {
                    this.setDebugState("Collecting building materials.");
                    return this.buildMaterialsTask;
                }
                this.setDebugState("Going to Nether");
                ItemStorageTracker itemStorageTracker1 = mod.getItemStorage();
                if (itemStorageTracker1.getItemCount(class_1802.field_8477) >= 3 && !itemStorageTracker1.hasItem(class_1802.field_8377, class_1802.field_8403)) {
                    return TaskCatalogue.getItemTask(class_1802.field_8377, 1);
                }
                if (itemStorageTracker1.getItemCount(class_1802.field_8620) >= 3 && !itemStorageTracker1.hasItem(class_1802.field_8377, class_1802.field_8403)) {
                    return TaskCatalogue.getItemTask(class_1802.field_8403, 1);
                }
                if (!itemStorageTracker1.hasItem(class_1802.field_8377, class_1802.field_8403, class_1802.field_8387)) {
                    return TaskCatalogue.getItemTask(class_1802.field_8387, 1);
                }
                if (!itemStorageTracker1.hasItem(class_1802.field_8377, class_1802.field_8403, class_1802.field_8387, class_1802.field_8647)) {
                    return TaskCatalogue.getItemTask(class_1802.field_8647, 1);
                }
                this.gatherResources.clear();
                if (!(this.lastTask instanceof DefaultGoToDimensionTask)) {
                    this.goToNetherTask = new DefaultGoToDimensionTask(Dimension.NETHER);
                }
                this.lastTask = this.goToNetherTask;
                return this.goToNetherTask;
            }
            case NETHER: {
                if (BeatMinecraftTask.isTaskRunning(mod, this.safeNetherPortalTask)) {
                    return this.safeNetherPortalTask;
                }
                if (mod.getPlayer().method_51848() != 0 && this.safeNetherPortalTask == null) {
                    this.safeNetherPortalTask = new SafeNetherPortalTask();
                    return this.safeNetherPortalTask;
                }
                mod.getInputControls().release(Input.MOVE_FORWARD);
                mod.getInputControls().release(Input.MOVE_LEFT);
                mod.getInputControls().release(Input.SNEAK);
                class_2338 pos = mod.getPlayer().method_23312();
                if (this.escaped || !mod.getWorld().method_8320(pos).method_26204().equals(class_2246.field_10114) || !mod.getWorld().method_8320(pos.method_10078()).method_26204().equals(class_2246.field_10540) && !mod.getWorld().method_8320(pos.method_10067()).method_26204().equals(class_2246.field_10540) && !mod.getWorld().method_8320(pos.method_10072()).method_26204().equals(class_2246.field_10540) && !mod.getWorld().method_8320(pos.method_10095()).method_26204().equals(class_2246.field_10540)) {
                    ItemStorageTracker itemStorage;
                    if (!this.escaped) {
                        this.escaped = true;
                        mod.getInputControls().release(Input.CLICK_LEFT);
                    }
                    if ((itemStorage = mod.getItemStorage()).getItemCount(class_1802.field_8477) >= 3 && !itemStorage.hasItem(class_1802.field_8377, class_1802.field_8403)) {
                        return TaskCatalogue.getItemTask(class_1802.field_8377, 1);
                    }
                    if (itemStorage.getItemCount(class_1802.field_8620) >= 3 && !itemStorage.hasItem(class_1802.field_8377, class_1802.field_8403)) {
                        return TaskCatalogue.getItemTask(class_1802.field_8403, 1);
                    }
                    if (!itemStorage.hasItem(class_1802.field_8377, class_1802.field_8403, class_1802.field_8387)) {
                        return TaskCatalogue.getItemTask(class_1802.field_8387, 1);
                    }
                    if (!itemStorage.hasItem(class_1802.field_8377, class_1802.field_8403, class_1802.field_8387, class_1802.field_8647)) {
                        return TaskCatalogue.getItemTask(class_1802.field_8647, 1);
                    }
                    if (mod.getItemStorage().getItemCount(class_1802.field_8894) * 2 + mod.getItemStorage().getItemCount(class_1802.field_8183) + mod.getItemStorage().getItemCount(class_1802.field_8449) >= 14) {
                        this.hasRods = true;
                    }
                    double rodDistance = mod.getBlockScanner().distanceToClosest(class_2246.field_10266);
                    double pearlDistance = mod.getBlockScanner().distanceToClosest(class_2246.field_23078, class_2246.field_23079, class_2246.field_22503, class_2246.field_22113);
                    if (pearlDistance == Double.POSITIVE_INFINITY && rodDistance == Double.POSITIVE_INFINITY) {
                        this.setDebugState("Neither fortress or warped forest found... wandering");
                        if (BeatMinecraftTask.isTaskRunning(mod, this.searchTask)) {
                            return this.searchTask;
                        }
                        this.searchTask = new SearchChunkForBlockTask(class_2246.field_23078, class_2246.field_23079, class_2246.field_22503, class_2246.field_22113, class_2246.field_10266);
                        return this.searchTask;
                    }
                    if ((!(rodDistance < pearlDistance) || this.hasRods || this.gettingPearls) && needsEnderPearls) {
                        if (!mod.getBlockScanner().anyFound(class_2246.field_23078, class_2246.field_23079, class_2246.field_22503, class_2246.field_22113)) {
                            return new TimeoutWanderTask();
                        }
                        if (!(this.gotToBiome || this.biomePos != null && WorldHelper.inRangeXZ((class_1297)mod.getPlayer(), this.biomePos, 30.0) && mod.getBaritone().getPathingBehavior().isSafeToCancel())) {
                            if (this.biomePos != null) {
                                this.setDebugState("Going to biome");
                                return new GetWithinRangeOfBlockTask(this.biomePos, 20);
                            }
                            this.gettingPearls = true;
                            this.setDebugState("Getting Ender Pearls");
                            Optional<class_2338> closestBlock = mod.getBlockScanner().getNearestBlock(class_2246.field_23078, class_2246.field_23079, class_2246.field_22503, class_2246.field_22113);
                            if (closestBlock.isPresent()) {
                                this.biomePos = closestBlock.get();
                            } else {
                                this.setDebugState("biome not found, wandering");
                            }
                            return new TimeoutWanderTask();
                        }
                        this.gotToBiome = true;
                        return this.getEnderPearlTask(mod, enderPearlTarget);
                    }
                    if (!this.gotToFortress) {
                        if (mod.getBlockScanner().anyFoundWithinDistance(5.0, class_2246.field_10266)) {
                            this.gotToFortress = true;
                        } else {
                            if (!mod.getBlockScanner().anyFound(class_2246.field_10266)) {
                                this.setDebugState("Searching for fortress");
                                return new TimeoutWanderTask();
                            }
                            if (WorldHelper.inRangeXZ(mod.getPlayer().method_19538(), WorldHelper.toVec3d(mod.getBlockScanner().getNearestBlock(class_2246.field_10266).get()), 2.0)) {
                                this.setDebugState("trying to get to fortress");
                                return new GetToBlockTask(mod.getBlockScanner().getNearestBlock(class_2246.field_10266).get());
                            }
                            this.setDebugState("Getting close to fortress");
                            if ((this.cachedFortressTask != null && !this.fortressTimer.elapsed() && mod.getPlayer().method_19538().method_1022(WorldHelper.toVec3d(this.cachedFortressTask.blockPos)) - 1.0 > (double)this.prevPos.method_19455((class_2382)this.cachedFortressTask.blockPos) / 2.0 || !mod.getBaritone().getPathingBehavior().isSafeToCancel()) && this.cachedFortressTask != null) {
                                mod.log(mod.getPlayer().method_19538().method_1022(WorldHelper.toVec3d(this.cachedFortressTask.blockPos)) + " : " + mod.getPlayer().method_19538().method_1022(WorldHelper.toVec3d(this.cachedFortressTask.blockPos)));
                                return this.cachedFortressTask;
                            }
                            if (this.resetFortressTask) {
                                this.resetFortressTask = false;
                                return null;
                            }
                            this.resetFortressTask = true;
                            this.fortressTimer.reset();
                            mod.log("new");
                            this.prevPos = mod.getPlayer().method_24515();
                            class_2338 p = mod.getBlockScanner().getNearestBlock(class_2246.field_10266).get();
                            int distance = (int)(mod.getPlayer().method_19538().method_1022(WorldHelper.toVec3d(p)) / 2.0);
                            if (this.cachedFortressTask != null) {
                                distance = Math.min(this.cachedFortressTask.range - 1, distance);
                            }
                            if (distance >= 0) {
                                this.cachedFortressTask = new GetWithinRangeOfBlockTask(p, distance);
                                return this.cachedFortressTask;
                            }
                            this.gotToFortress = true;
                        }
                    }
                    this.setDebugState("Getting Blaze Rods");
                    return this.getBlazeRodsTask(mod, blazeRodTarget);
                }
                LookHelper.lookAt(mod, pos);
                mod.getInputControls().hold(Input.CLICK_LEFT);
                return null;
            }
            case END: {
                throw new UnsupportedOperationException("You're in the end. Don't collect eyes here.");
            }
        }
        return null;
    }

    static {
        openingEndPortal = false;
        ConfigHelper.loadConfig("configs/beat_minecraft.json", BeatMinecraftConfig::new, BeatMinecraftConfig.class, newConfig -> {
            config = newConfig;
        });
    }

    private class DistanceOrePriorityCalculator
    extends DistanceItemPriorityCalculator {
        private final class_1792 oreItem;

        public DistanceOrePriorityCalculator(class_1792 oreItem, double multiplier, double unneededMultiplier, double unneededDistanceThreshold, int minCount, int maxCount) {
            super(multiplier, unneededMultiplier, unneededDistanceThreshold, minCount, maxCount);
            this.oreItem = oreItem;
        }

        @Override
        public void update(int count) {
            super.update(BeatMinecraftTask.getCountWithCraftedFromOre(BeatMinecraftTask.this.mod, this.oreItem));
        }
    }

    private record TaskChange(PriorityTask original, PriorityTask interrupt, class_2338 pos) {
    }
}

