/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.trackers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;

public class MiscBlockTracker {
    private final PlayerEngineController mod;
    private final Map<Dimension, class_2338> lastNetherPortalsUsed = new HashMap<Dimension, class_2338>();
    private Dimension lastDimension;
    private boolean newDimensionTriggered;

    public MiscBlockTracker(PlayerEngineController mod) {
        this.mod = mod;
    }

    public void tick() {
        if (WorldHelper.getCurrentDimension(this.mod) != this.lastDimension) {
            this.lastDimension = WorldHelper.getCurrentDimension(this.mod);
            this.newDimensionTriggered = true;
        }
        if (PlayerEngineController.inGame() && this.newDimensionTriggered) {
            for (class_2338 check : WorldHelper.scanRegion(this.mod.getPlayer().method_24515().method_10069(-1, -1, -1), this.mod.getPlayer().method_24515().method_10069(1, 1, 1))) {
                class_2248 currentBlock = this.mod.getWorld().method_8320(check).method_26204();
                if (currentBlock != class_2246.field_10316) continue;
                while (check.method_10264() > 0 && this.mod.getWorld().method_8320(check.method_10074()).method_26204() == class_2246.field_10316) {
                    check = check.method_10074();
                }
                class_2338 below = check.method_10074();
                if (!WorldHelper.isSolidBlock(this.mod, below)) break;
                this.lastNetherPortalsUsed.put(WorldHelper.getCurrentDimension(this.mod), check);
                this.newDimensionTriggered = false;
                break;
            }
        }
    }

    public void reset() {
        this.lastNetherPortalsUsed.clear();
    }

    public Optional<class_2338> getLastUsedNetherPortal(Dimension dimension) {
        if (this.lastNetherPortalsUsed.containsKey((Object)dimension)) {
            class_2338 portalPos = this.lastNetherPortalsUsed.get((Object)dimension);
            if (this.mod.getChunkTracker().isChunkLoaded(portalPos) && !this.mod.getBlockScanner().isBlockAtPosition(portalPos, class_2246.field_10316)) {
                this.lastNetherPortalsUsed.remove((Object)dimension);
                return Optional.empty();
            }
            return Optional.ofNullable(portalPos);
        }
        return Optional.empty();
    }
}

