/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.baritone;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.baritone.CachedProjectile;
import com.player2.playerengine.util.helpers.BaritoneHelper;
import com.player2.playerengine.util.helpers.ProjectileHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_243;

public class GoalDodgeProjectiles
implements Goal {
    private static final double Y_SCALE = (double)0.3f;
    private final PlayerEngineController mod;
    private final double distanceHorizontal;
    private final double distanceVertical;
    private final List<CachedProjectile> cachedProjectiles = new ArrayList<CachedProjectile>();

    public GoalDodgeProjectiles(PlayerEngineController mod, double distanceHorizontal, double distanceVertical) {
        this.mod = mod;
        this.distanceHorizontal = distanceHorizontal;
        this.distanceVertical = distanceVertical;
    }

    private static boolean isInvalidProjectile(CachedProjectile projectile) {
        return projectile == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInGoal(int x, int y, int z) {
        List<CachedProjectile> projectiles = this.getProjectiles();
        class_243 p = new class_243((double)x, (double)y, (double)z);
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            if (!projectiles.isEmpty()) {
                for (CachedProjectile projectile : projectiles) {
                    if (GoalDodgeProjectiles.isInvalidProjectile(projectile)) continue;
                    try {
                        class_243 hit;
                        if (projectile.needsToRecache()) {
                            projectile.setCacheHit(ProjectileHelper.calculateArrowClosestApproach(projectile, p));
                        }
                        if (!this.isHitCloseEnough(hit = projectile.getCachedHit(), p)) continue;
                        return false;
                    }
                    catch (Exception var11) {
                        Debug.logWarning("Weird exception caught while checking for goal: " + var11.getMessage());
                    }
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double heuristic(int x, int y, int z) {
        class_243 p = new class_243((double)x, (double)y, (double)z);
        double costFactor = 0.0;
        List<CachedProjectile> projectiles = this.getProjectiles();
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            if (!projectiles.isEmpty()) {
                for (CachedProjectile projectile : projectiles) {
                    if (GoalDodgeProjectiles.isInvalidProjectile(projectile)) continue;
                    if (projectile.needsToRecache()) {
                        projectile.setCacheHit(ProjectileHelper.calculateArrowClosestApproach(projectile, p));
                    }
                    class_243 hit = projectile.getCachedHit();
                    double arrowPenalty = ProjectileHelper.getFlatDistanceSqr(projectile.position.field_1352, projectile.position.field_1350, projectile.velocity.field_1352, projectile.velocity.field_1350, p.field_1352, p.field_1350);
                    if (!this.isHitCloseEnough(hit, p)) continue;
                    costFactor += arrowPenalty;
                }
            }
        }
        return -1.0 * costFactor;
    }

    private boolean isHitCloseEnough(class_243 hit, class_243 to) {
        class_243 delta = to.method_1020(hit);
        double horizontalSquared = delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350;
        double vertical = Math.abs(delta.field_1351);
        return horizontalSquared < this.distanceHorizontal * this.distanceHorizontal && vertical < this.distanceVertical;
    }

    private List<CachedProjectile> getProjectiles() {
        return this.mod.getEntityTracker().getProjectiles();
    }
}

