/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.command.helpers;

import com.player2.playerengine.automaton.api.command.argument.IArgConsumer;
import com.player2.playerengine.automaton.api.command.exception.CommandException;
import com.player2.playerengine.automaton.api.command.exception.CommandInvalidTypeException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;

public class Paginator<E> {
    private final class_2168 source;
    public final List<E> entries;
    public int pageSize = 8;
    public int page = 1;

    public Paginator(class_2168 source, List<E> entries) {
        this.source = source;
        this.entries = entries;
    }

    public Paginator<E> setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public int getMaxPage() {
        return (this.entries.size() - 1) / this.pageSize + 1;
    }

    public boolean validPage(int page) {
        return page > 0 && page <= this.getMaxPage();
    }

    public Paginator<E> skipPages(int pages) {
        this.page += pages;
        return this;
    }

    public void display(Function<E, class_2561> transform, String commandPrefix) {
        int offset;
        for (int i = offset = (this.page - 1) * this.pageSize; i < offset + this.pageSize; ++i) {
            if (i < this.entries.size()) {
                Object entry = this.entries.get(i);
                this.source.method_9226(() -> (class_2561)transform.apply(entry), false);
                continue;
            }
            this.source.method_9226(() -> class_2561.method_43470((String)"--").method_27692(class_124.field_1063), false);
        }
        boolean hasPrevPage = commandPrefix != null && this.validPage(this.page - 1);
        boolean hasNextPage = commandPrefix != null && this.validPage(this.page + 1);
        class_5250 prevPageComponent = class_2561.method_43470((String)"<<");
        if (hasPrevPage) {
            prevPageComponent.method_10862(prevPageComponent.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s %d", commandPrefix, this.page - 1))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to view previous page"))));
        } else {
            prevPageComponent.method_10862(prevPageComponent.method_10866().method_27706(class_124.field_1063));
        }
        class_5250 nextPageComponent = class_2561.method_43470((String)">>");
        if (hasNextPage) {
            nextPageComponent.method_10862(nextPageComponent.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s %d", commandPrefix, this.page + 1))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to view next page"))));
        } else {
            nextPageComponent.method_10862(nextPageComponent.method_10866().method_27706(class_124.field_1063));
        }
        this.source.method_9226(() -> {
            class_5250 pagerComponent = class_2561.method_43470((String)"");
            pagerComponent.method_10862(pagerComponent.method_10866().method_27706(class_124.field_1080));
            pagerComponent.method_10852((class_2561)prevPageComponent);
            pagerComponent.method_27693(" | ");
            pagerComponent.method_10852((class_2561)nextPageComponent);
            pagerComponent.method_27693(String.format(" %d/%d", this.page, this.getMaxPage()));
            return pagerComponent;
        }, false);
    }

    public static <T> void paginate(IArgConsumer consumer, Paginator<T> pagi, Runnable pre, Function<T, class_2561> transform, String commandPrefix) throws CommandException {
        int page = 1;
        consumer.requireMax(1);
        if (consumer.hasAny() && !pagi.validPage(page = consumer.getAs(Integer.class).intValue())) {
            throw new CommandInvalidTypeException(consumer.consumed(), String.format("a valid page (1-%d)", pagi.getMaxPage()), consumer.consumed().getValue());
        }
        pagi.skipPages(page - pagi.page);
        if (pre != null) {
            pre.run();
        }
        pagi.display(transform, commandPrefix);
    }

    public static <T> void paginate(IArgConsumer consumer, List<T> elems, Runnable pre, Function<T, class_2561> transform, String commandPrefix, class_2168 source) throws CommandException {
        Paginator.paginate(consumer, new Paginator<T>(source, elems), pre, transform, commandPrefix);
    }

    public static <T> void paginate(IArgConsumer consumer, T[] elems, Runnable pre, Function<T, class_2561> transform, String commandPrefix, class_2168 source) throws CommandException {
        Paginator.paginate(consumer, Arrays.asList(elems), pre, transform, commandPrefix, source);
    }

    public static <T> void paginate(IArgConsumer consumer, Paginator<T> pagi, Function<T, class_2561> transform, String commandPrefix) throws CommandException {
        Paginator.paginate(consumer, pagi, null, transform, commandPrefix);
    }

    public static <T> void paginate(IArgConsumer consumer, List<T> elems, Function<T, class_2561> transform, String commandPrefix, class_2168 source) throws CommandException {
        Paginator.paginate(consumer, new Paginator<T>(source, elems), null, transform, commandPrefix);
    }

    public static <T> void paginate(IArgConsumer consumer, T[] elems, Function<T, class_2561> transform, String commandPrefix, class_2168 source) throws CommandException {
        Paginator.paginate(consumer, Arrays.asList(elems), null, transform, commandPrefix, source);
    }

    public static <T> void paginate(IArgConsumer consumer, Paginator<T> pagi, Runnable pre, Function<T, class_2561> transform) throws CommandException {
        Paginator.paginate(consumer, pagi, pre, transform, null);
    }

    public static <T> void paginate(IArgConsumer consumer, List<T> elems, Runnable pre, Function<T, class_2561> transform, class_2168 source) throws CommandException {
        Paginator.paginate(consumer, new Paginator<T>(source, elems), pre, transform, null);
    }

    public static <T> void paginate(IArgConsumer consumer, T[] elems, Runnable pre, Function<T, class_2561> transform, class_2168 source) throws CommandException {
        Paginator.paginate(consumer, Arrays.asList(elems), pre, transform, null, source);
    }

    public static <T> void paginate(IArgConsumer consumer, Paginator<T> pagi, Function<T, class_2561> transform) throws CommandException {
        Paginator.paginate(consumer, pagi, null, transform, null);
    }

    public static <T> void paginate(IArgConsumer consumer, List<T> elems, Function<T, class_2561> transform, class_2168 source) throws CommandException {
        Paginator.paginate(consumer, new Paginator<T>(source, elems), null, transform, null);
    }

    public static <T> void paginate(IArgConsumer consumer, T[] elems, Function<T, class_2561> transform, class_2168 source) throws CommandException {
        Paginator.paginate(consumer, Arrays.asList(elems), null, transform, null, source);
    }
}

