/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.movement.movements;

import com.google.common.collect.ImmutableSet;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.pathing.movement.MovementStatus;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.pathing.movement.MovementState;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.automaton.utils.pathing.MutableMoveResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;

public class MovementDiagonal
extends Movement {
    private static final double SQRT_2 = Math.sqrt(2.0);

    public MovementDiagonal(IBaritone baritone, BetterBlockPos start, class_2350 dir1, class_2350 dir2, int dy) {
        this(baritone, start, start.offset(dir1), start.offset(dir2), dir2, dy);
    }

    private MovementDiagonal(IBaritone baritone, BetterBlockPos start, BetterBlockPos dir1, BetterBlockPos dir2, class_2350 drr2, int dy) {
        this(baritone, start, dir1.offset(drr2).up(dy), dir1, dir2);
    }

    private MovementDiagonal(IBaritone baritone, BetterBlockPos start, BetterBlockPos end, BetterBlockPos dir1, BetterBlockPos dir2) {
        super(baritone, start, end, MovementDiagonal.computeBlocksToBreak(baritone.getEntityContext().entity(), end, dir1, dir2));
    }

    @NotNull
    private static BetterBlockPos[] computeBlocksToBreak(class_1309 entity, BetterBlockPos end, BetterBlockPos dir1, BetterBlockPos dir2) {
        BetterBlockPos[] betterBlockPosArray;
        if (entity.method_18377(class_4050.field_18076).comp_2186() <= 1.0f) {
            BetterBlockPos[] betterBlockPosArray2 = new BetterBlockPos[3];
            betterBlockPosArray2[0] = dir1;
            betterBlockPosArray2[1] = dir2;
            betterBlockPosArray = betterBlockPosArray2;
            betterBlockPosArray2[2] = end;
        } else {
            BetterBlockPos[] betterBlockPosArray3 = new BetterBlockPos[6];
            betterBlockPosArray3[0] = dir1;
            betterBlockPosArray3[1] = dir1.up();
            betterBlockPosArray3[2] = dir2;
            betterBlockPosArray3[3] = dir2.up();
            betterBlockPosArray3[4] = end;
            betterBlockPosArray = betterBlockPosArray3;
            betterBlockPosArray3[5] = end.up();
        }
        return betterBlockPosArray;
    }

    @Override
    protected boolean safeToCancel(MovementState state) {
        class_1309 player = this.ctx.entity();
        double offset = 0.25;
        double x = player.method_23317();
        double y = player.method_23318() - 1.0;
        double z = player.method_23321();
        if (this.ctx.feetPos().equals((Object)this.src)) {
            return true;
        }
        if (MovementHelper.canWalkOn(this.ctx, new class_2338(this.src.x, this.src.y - 1, this.dest.z)) && MovementHelper.canWalkOn(this.ctx, new class_2338(this.dest.x, this.src.y - 1, this.src.z))) {
            return true;
        }
        return !this.ctx.feetPos().equals((Object)new BetterBlockPos(this.src.x, this.src.y, this.dest.z)) && !this.ctx.feetPos().equals((Object)new BetterBlockPos(this.dest.x, this.src.y, this.src.z)) ? true : MovementHelper.canWalkOn(this.ctx, new BetterBlockPos(x + offset, y, z + offset)) || MovementHelper.canWalkOn(this.ctx, new BetterBlockPos(x + offset, y, z - offset)) || MovementHelper.canWalkOn(this.ctx, new BetterBlockPos(x - offset, y, z + offset)) || MovementHelper.canWalkOn(this.ctx, new BetterBlockPos(x - offset, y, z - offset));
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementDiagonal.cost(context, this.src.x, this.src.y, this.src.z, this.dest.x, this.dest.z, result);
        return result.y != this.dest.y ? 1000000.0 : result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        BetterBlockPos diagA = new BetterBlockPos(this.src.x, this.src.y, this.dest.z);
        BetterBlockPos diagB = new BetterBlockPos(this.dest.x, this.src.y, this.src.z);
        if (this.dest.y < this.src.y) {
            return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest.up()), (Object)((Object)diagA), (Object)((Object)diagB), (Object)((Object)this.dest), (Object)((Object)diagA.down()), (Object[])new BetterBlockPos[]{diagB.down()});
        }
        return this.dest.y > this.src.y ? ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.src.up()), (Object)((Object)diagA), (Object)((Object)diagB), (Object)((Object)this.dest), (Object)((Object)diagA.up()), (Object[])new BetterBlockPos[]{diagB.up()}) : ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest), (Object)((Object)diagA), (Object)((Object)diagB));
    }

    public static void cost(CalculationContext context, int x, int y, int z, int destX, int destZ, MutableMoveResult res) {
        if (MovementHelper.canWalkThrough(context.bsi, destX, y + 1, destZ, context.baritone.settings()) && context.width <= 1 && context.height <= 2) {
            class_2248 fromDown;
            class_2680 destWalkOn;
            class_2680 destInto = context.get(destX, y, destZ);
            boolean ascend = false;
            boolean descend = false;
            if (!MovementHelper.canWalkThrough(context.bsi, destX, y, destZ, destInto, context.baritone.settings())) {
                ascend = true;
                if (!(context.allowDiagonalAscend && MovementHelper.canWalkThrough(context.bsi, x, y + 2, z, context.baritone.settings()) && MovementHelper.canWalkOn(context.bsi, destX, y, destZ, destInto, context.baritone.settings()) && MovementHelper.canWalkThrough(context.bsi, destX, y + 2, destZ, context.baritone.settings()))) {
                    return;
                }
                destWalkOn = destInto;
            } else {
                destWalkOn = context.get(destX, y - 1, destZ);
                if (!MovementHelper.canWalkOn(context.bsi, destX, y - 1, destZ, destWalkOn, context.baritone.settings())) {
                    descend = true;
                    if (!(context.allowDiagonalDescend && MovementHelper.canWalkOn(context.bsi, destX, y - 2, destZ, context.baritone.settings()) && MovementHelper.canWalkThrough(context.bsi, destX, y - 1, destZ, destWalkOn, context.baritone.settings()))) {
                        return;
                    }
                }
            }
            double multiplier = 4.63284688441047 / (double)destWalkOn.method_26204().method_23349() / 2.0;
            if (destWalkOn.method_27852(class_2246.field_10382)) {
                multiplier += context.walkOnWaterOnePenalty * SQRT_2;
            }
            if ((fromDown = context.get(x, y - 1, z).method_26204()) != class_2246.field_9983 && fromDown != class_2246.field_10597) {
                class_2680 cuttingOver2;
                multiplier += 4.63284688441047 / (double)fromDown.method_23349() / 2.0;
                class_2680 cuttingOver1 = context.get(x, y - 1, destZ);
                if (cuttingOver1.method_26204() != class_2246.field_10092 && !MovementHelper.isLava(cuttingOver1) && (cuttingOver2 = context.get(destX, y - 1, z)).method_26204() != class_2246.field_10092 && !MovementHelper.isLava(cuttingOver2)) {
                    boolean water = false;
                    class_2680 startState = context.get(x, y, z);
                    class_2248 startIn = startState.method_26204();
                    if (MovementHelper.isWater(startState) || MovementHelper.isWater(destInto)) {
                        if (ascend) {
                            return;
                        }
                        multiplier = context.waterWalkSpeed;
                        water = true;
                    }
                    boolean smol = context.height <= 1;
                    class_2680 diagonalA = context.get(x, y, destZ);
                    class_2680 diagonalB = context.get(destX, y, z);
                    if (ascend) {
                        boolean ATop = smol || MovementHelper.canWalkThrough(context.bsi, x, y + 2, destZ, context.baritone.settings());
                        boolean AMid = MovementHelper.canWalkThrough(context.bsi, x, y + 1, destZ, context.baritone.settings());
                        boolean ALow = MovementHelper.canWalkThrough(context.bsi, x, y, destZ, diagonalA, context.baritone.settings());
                        boolean BTop = smol || MovementHelper.canWalkThrough(context.bsi, destX, y + 2, z, context.baritone.settings());
                        boolean BMid = MovementHelper.canWalkThrough(context.bsi, destX, y + 1, z, context.baritone.settings());
                        boolean BLow = MovementHelper.canWalkThrough(context.bsi, destX, y, z, diagonalB, context.baritone.settings());
                        if (!((!ATop || !AMid || !ALow) && (!BTop || !BMid || !BLow) || MovementHelper.avoidWalkingInto(diagonalA) || MovementHelper.avoidWalkingInto(diagonalB) || ATop && AMid && MovementHelper.canWalkOn(context.bsi, x, y, destZ, diagonalA, context.baritone.settings()) || BTop && BMid && MovementHelper.canWalkOn(context.bsi, destX, y, z, diagonalB, context.baritone.settings()) || !ATop && AMid && ALow || !BTop && BMid && BLow)) {
                            res.cost = multiplier * SQRT_2 + JUMP_ONE_BLOCK_COST;
                            res.x = destX;
                            res.z = destZ;
                            res.y = y + 1;
                        }
                    } else {
                        double optionA = MovementHelper.getMiningDurationTicks(context, x, y, destZ, diagonalA, false);
                        double optionB = MovementHelper.getMiningDurationTicks(context, destX, y, z, diagonalB, false);
                        if (optionA == 0.0 || optionB == 0.0) {
                            class_2680 diagonalUpA = context.get(x, y + 1, destZ);
                            if (!smol && (optionA += MovementHelper.getMiningDurationTicks(context, x, y + 1, destZ, diagonalUpA, true)) != 0.0 && optionB != 0.0) {
                                return;
                            }
                            class_2680 diagonalUpB = context.get(destX, y + 1, z);
                            if (!(optionA == 0.0 && (MovementHelper.avoidWalkingInto(diagonalB) && diagonalB.method_26204() != class_2246.field_10382 || !smol && MovementHelper.avoidWalkingInto(diagonalUpB)))) {
                                if (!smol && optionA != 0.0 && (optionB += MovementHelper.getMiningDurationTicks(context, destX, y + 1, z, diagonalUpB, true)) != 0.0) {
                                    return;
                                }
                                if (!(optionB == 0.0 && (MovementHelper.avoidWalkingInto(diagonalA) && diagonalA.method_26204() != class_2246.field_10382 || !smol && MovementHelper.avoidWalkingInto(diagonalUpA)))) {
                                    double costPerBlock;
                                    class_2680 optionHeadBlock;
                                    if (optionA == 0.0 && optionB == 0.0) {
                                        if (context.canSprint && !water) {
                                            multiplier *= 0.7692444761225944;
                                        }
                                        optionHeadBlock = null;
                                    } else {
                                        multiplier *= SQRT_2 - 0.001;
                                        if (startIn == class_2246.field_9983 || startIn == class_2246.field_10597) {
                                            return;
                                        }
                                        optionHeadBlock = optionA != 0.0 ? diagonalUpA : diagonalUpB;
                                    }
                                    res.cost = multiplier * SQRT_2;
                                    if (optionHeadBlock == null) {
                                        costPerBlock = res.cost / 2.0;
                                    } else {
                                        costPerBlock = res.cost / 3.0;
                                        res.oxygenCost += context.oxygenCost(costPerBlock, optionHeadBlock);
                                    }
                                    res.oxygenCost += context.oxygenCost(costPerBlock, context.get(x, y + context.height - 1, z));
                                    if (descend) {
                                        res.cost += Math.max(FALL_N_BLOCKS_COST[1], 0.9265693768820937);
                                        res.oxygenCost += context.oxygenCost(costPerBlock, context.get(destX, y + context.height - 2, destZ));
                                        res.y = y - 1;
                                    } else {
                                        res.oxygenCost += context.oxygenCost(costPerBlock, context.get(destX, y + context.height - 1, destZ));
                                        res.y = y;
                                    }
                                    res.x = destX;
                                    res.z = destZ;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public MovementState updateState(MovementState state) {
        super.updateState(state);
        if (state.getStatus() != MovementStatus.RUNNING) {
            return state;
        }
        if (!(this.ctx.feetPos().equals((Object)this.dest) || MovementHelper.isWater(this.ctx, this.ctx.feetPos()) && this.ctx.feetPos().equals((Object)this.dest.down()))) {
            if (this.playerInValidPosition() || MovementHelper.isLiquid(this.ctx, this.src) && this.getValidPositions().contains((Object)this.ctx.feetPos().up())) {
                if (this.dest.y > this.src.y && this.ctx.entity().method_23318() < (double)this.src.y + 0.1 && this.ctx.entity().field_5976) {
                    state.setInput(Input.JUMP, true);
                }
                if (this.sprint()) {
                    state.setInput(Input.SPRINT, true);
                }
                MovementHelper.moveTowards(this.ctx, state, this.dest);
                return state;
            }
            return state.setStatus(MovementStatus.UNREACHABLE);
        }
        return state.setStatus(MovementStatus.SUCCESS);
    }

    private boolean sprint() {
        if (MovementHelper.isLiquid(this.ctx, this.ctx.feetPos()) && !this.baritone.settings().sprintInWater.get().booleanValue()) {
            return false;
        }
        for (int i = 0; i < Math.min(this.positionsToBreak.length, 4); ++i) {
            if (MovementHelper.canWalkThrough(this.ctx, this.positionsToBreak[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean prepared(MovementState state) {
        return true;
    }

    @Override
    public List<class_2338> toBreak(BlockStateInterface bsi) {
        if (this.toBreakCached != null) {
            return this.toBreakCached;
        }
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        for (int i = 4; i < Math.min(this.positionsToBreak.length, 6); ++i) {
            if (MovementHelper.canWalkThrough(bsi, this.positionsToBreak[i].x, this.positionsToBreak[i].y, this.positionsToBreak[i].z, this.ctx.baritone().settings())) continue;
            result.add(this.positionsToBreak[i]);
        }
        this.toBreakCached = result;
        return result;
    }

    @Override
    public List<class_2338> toWalkInto(BlockStateInterface bsi) {
        if (this.toWalkIntoCached == null) {
            this.toWalkIntoCached = new ArrayList();
        }
        ArrayList<BetterBlockPos> result = new ArrayList<BetterBlockPos>();
        for (int i = 0; i < Math.min(this.positionsToBreak.length, 4); ++i) {
            if (MovementHelper.canWalkThrough(bsi, this.positionsToBreak[i].x, this.positionsToBreak[i].y, this.positionsToBreak[i].z, this.ctx.baritone().settings())) continue;
            result.add(this.positionsToBreak[i]);
        }
        this.toWalkIntoCached = result;
        return this.toWalkIntoCached;
    }
}

