/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.chains;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.base.TaskChain;
import com.player2.playerengine.tasks.base.TaskRunner;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.slots.PlayerSlot;
import com.player2.playerengine.util.slots.Slot;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Optional;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2680;

public class PlayerInteractionFixChain
extends TaskChain {
    private final TimerGame stackHeldTimeout = new TimerGame(1.0);
    private final TimerGame generalDuctTapeSwapTimeout = new TimerGame(30.0);
    private final TimerGame shiftDepressTimeout = new TimerGame(10.0);
    private final TimerGame betterToolTimer = new TimerGame(0.0);
    private final TimerGame mouseMovingButScreenOpenTimeout = new TimerGame(1.0);
    private class_1799 lastHandStack = null;
    private Rotation lastLookRotation;

    public PlayerInteractionFixChain(TaskRunner runner) {
        super(runner);
    }

    @Override
    protected void onStop() {
    }

    @Override
    public void onInterrupt(TaskChain other) {
    }

    @Override
    protected void onTick() {
    }

    @Override
    public float getPriority() {
        if (!PlayerEngineController.inGame()) {
            return Float.NEGATIVE_INFINITY;
        }
        PlayerEngineController mod = this.controller;
        if (mod.getUserTaskChain().isActive() && this.betterToolTimer.elapsed()) {
            this.betterToolTimer.reset();
            if (mod.getControllerExtras().isBreakingBlock()) {
                class_2680 state = mod.getWorld().method_8320(mod.getControllerExtras().getBreakingBlockPos());
                Optional<Slot> bestToolSlot = StorageHelper.getBestToolSlot(mod, state);
                Slot currentEquipped = PlayerSlot.getEquipSlot(this.controller.getInventory());
                if (bestToolSlot.isPresent() && !bestToolSlot.get().equals(currentEquipped) && StorageHelper.getItemStackInSlot(currentEquipped).method_7909() != StorageHelper.getItemStackInSlot(bestToolSlot.get()).method_7909()) {
                    boolean isAllowedToManage;
                    boolean bl = isAllowedToManage = (!mod.getBaritone().getPathingBehavior().isPathing() || bestToolSlot.get().getInventorySlot() >= 9) && !mod.getFoodChain().isTryingToEat();
                    if (isAllowedToManage) {
                        Debug.logMessage("Found better tool in inventory, equipping.");
                        class_1799 bestToolItemStack = StorageHelper.getItemStackInSlot(bestToolSlot.get());
                        class_1792 bestToolItem = bestToolItemStack.method_7909();
                        mod.getSlotHandler().forceEquipItem(bestToolItem);
                    }
                }
            }
        }
        if (mod.getInputControls().isHeldDown(Input.SNEAK)) {
            if (this.shiftDepressTimeout.elapsed()) {
                mod.getInputControls().release(Input.SNEAK);
            }
        } else {
            this.shiftDepressTimeout.reset();
        }
        if (this.generalDuctTapeSwapTimeout.elapsed() && !mod.getControllerExtras().isBreakingBlock()) {
            Debug.logMessage("Refreshed inventory...");
            mod.getSlotHandler().refreshInventory();
            this.generalDuctTapeSwapTimeout.reset();
            return Float.NEGATIVE_INFINITY;
        }
        class_1799 currentStack = StorageHelper.getItemStackInCursorSlot(this.controller);
        if (currentStack == null || currentStack.method_7960()) {
            this.stackHeldTimeout.reset();
            this.lastHandStack = null;
        } else if (this.lastHandStack == null || !class_1799.method_7973((class_1799)currentStack, (class_1799)this.lastHandStack)) {
            this.stackHeldTimeout.reset();
            this.lastHandStack = currentStack.method_7972();
        }
        if (this.lastHandStack != null && this.stackHeldTimeout.elapsed()) {
            Optional<Slot> moveTo = mod.getItemStorage().getSlotThatCanFitInPlayerInventory(this.lastHandStack, false);
            if (moveTo.isPresent()) {
                mod.getSlotHandler().clickSlot(moveTo.get(), 0, class_1713.field_7790);
                return Float.NEGATIVE_INFINITY;
            }
            if (ItemHelper.canThrowAwayStack(mod, StorageHelper.getItemStackInCursorSlot(this.controller))) {
                mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, class_1713.field_7790);
                return Float.NEGATIVE_INFINITY;
            }
            Optional<Slot> garbage = StorageHelper.getGarbageSlot(mod);
            if (garbage.isPresent()) {
                mod.getSlotHandler().clickSlot(garbage.get(), 0, class_1713.field_7790);
                return Float.NEGATIVE_INFINITY;
            }
            mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, class_1713.field_7790);
            return Float.NEGATIVE_INFINITY;
        }
        return Float.NEGATIVE_INFINITY;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public String getName() {
        return "Hand Stack Fix Chain";
    }
}

