/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.commands.random;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.commands.BlockScanner;
import com.player2.playerengine.commands.base.Arg;
import com.player2.playerengine.commands.base.ArgParser;
import com.player2.playerengine.commands.base.Command;
import com.player2.playerengine.commands.base.CommandException;
import com.player2.playerengine.util.helpers.FuzzySearchHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;

public class ScanCommand
extends Command {
    public ScanCommand() throws CommandException {
        super("scan", "Locates nearest block", new Arg<String>(String.class, "block", "DIRT", 0));
    }

    @Override
    protected void call(PlayerEngineController mod, ArgParser parser) throws CommandException {
        String blockStr = parser.get(String.class);
        Field[] declaredFields = class_2246.class.getDeclaredFields();
        class_2248 block = null;
        ArrayList<String> allBlockNames = new ArrayList<String>();
        for (Field field : declaredFields) {
            field.setAccessible(true);
            try {
                String fieldName = field.getName();
                allBlockNames.add(fieldName.toLowerCase());
                if (fieldName.equalsIgnoreCase(blockStr)) {
                    block = (class_2248)field.get(class_2246.class);
                }
            }
            catch (IllegalAccessException var12) {
                throw new RuntimeException(var12);
            }
            field.setAccessible(false);
        }
        if (block == null) {
            String closest = FuzzySearchHelper.getClosestMatchMinecraftItems(blockStr, allBlockNames);
            mod.log("Block named: \"" + blockStr + "\" not a valid block. Perhaps the user meant \"" + closest + "\"?" + (blockStr.contains("log") ? " Can try 'log' as well" : ""));
            this.finish();
        } else {
            BlockScanner blockScanner = mod.getBlockScanner();
            Optional<class_2338> p = blockScanner.getNearestBlock(block, mod.getPlayer().method_19538());
            if (p.isPresent()) {
                mod.log("Closest " + blockStr + ": " + p.get().toString());
            } else {
                mod.log("No blocks of type " + blockStr + " found nearby.");
            }
            this.finish();
        }
    }
}

