/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.utils.Player2HTTPUtils;
import com.player2.playerengine.player2api.utils.Utils;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class CharacterUtils {
    public static Character DEFAULT_CHARACTER = new Character("AI agent", "AI", "Greetings", "You are a helpful AI Agent", "minecraft:textures/entity/player/wide/steve.png", new String[0]);

    public static Character parseFirstCharacter(Map<String, JsonElement> responseMap) {
        Character[] characters = CharacterUtils.parseCharacters(responseMap);
        return characters.length > 0 ? characters[0] : DEFAULT_CHARACTER;
    }

    public static Character[] parseCharacters(Map<String, JsonElement> responseMap) {
        try {
            if (!responseMap.containsKey("characters")) {
                throw new Exception("No characters found in API response.");
            }
            JsonArray charactersArray = responseMap.get("characters").getAsJsonArray();
            if (charactersArray.isEmpty()) {
                throw new Exception("Character list is empty.");
            }
            Character[] characters = new Character[charactersArray.size()];
            for (int i = 0; i < charactersArray.size(); ++i) {
                JsonObject firstCharacter = charactersArray.get(i).getAsJsonObject();
                String name = Utils.getStringJsonSafely(firstCharacter, "name");
                if (name == null) {
                    throw new Exception("Character is missing 'name'.");
                }
                String shortName = Utils.getStringJsonSafely(firstCharacter, "short_name");
                if (shortName == null) {
                    throw new Exception("Character is missing 'short_name'.");
                }
                String greeting = Utils.getStringJsonSafely(firstCharacter, "greeting");
                String description = Utils.getStringJsonSafely(firstCharacter, "description");
                String[] voiceIds = Utils.getStringArrayJsonSafely(firstCharacter, "voice_ids");
                JsonObject meta = firstCharacter.get("meta").getAsJsonObject();
                String skinURL = Utils.getStringJsonSafely(meta, "skin_url");
                characters[i] = new Character(name, shortName, greeting, description, skinURL, voiceIds);
            }
            return characters;
        }
        catch (Exception var12) {
            System.err.println("Warning, getSelectedCharacter failed, reverting to default. Error message: " + var12.getMessage());
            return new Character[0];
        }
    }

    public static Character[] requestCharacters(class_1657 player, String player2GameId) {
        try {
            Map<String, JsonElement> responseMap = Player2HTTPUtils.sendRequest(player, player2GameId, "/v1/selected_characters", false, null);
            return CharacterUtils.parseCharacters(responseMap);
        }
        catch (Exception var2) {
            return new Character[0];
        }
    }

    public static Character requestFirstCharacter(class_1657 player, String player2GameId) {
        try {
            Map<String, JsonElement> responseMap = Player2HTTPUtils.sendRequest(player, player2GameId, "/v1/selected_characters", false, null);
            return CharacterUtils.parseFirstCharacter(responseMap);
        }
        catch (Exception var2) {
            return DEFAULT_CHARACTER;
        }
    }

    public static Character readFromBuf(class_2540 buf) {
        String name = buf.method_19772();
        String shortName = buf.method_19772();
        String greetingInfo = buf.method_19772();
        String description = buf.method_19772();
        String skinURL = buf.method_19772();
        int arrSize = buf.readInt();
        String[] voiceIds = new String[arrSize];
        for (int i = 0; i < arrSize; ++i) {
            voiceIds[i] = buf.method_19772();
        }
        return new Character(name, shortName, greetingInfo, description, skinURL, voiceIds);
    }

    public static void writeToBuf(class_2540 buf, Character character) {
        buf.method_10814(character.name());
        buf.method_10814(character.shortName());
        buf.method_10814(character.greetingInfo());
        buf.method_10814(character.description());
        buf.method_10814(character.skinURL());
        buf.method_53002(character.voiceIds().length);
        for (String id : character.voiceIds()) {
            buf.method_10814(id);
        }
    }

    public static Character readFromNBT(class_2487 compound) {
        String name = compound.method_10558("name");
        String shortName = compound.method_10558("shortName");
        String greetingInfo = compound.method_10558("greetingInfo");
        String description = compound.method_10558("description");
        String skinURL = compound.method_10558("skinURL");
        class_2499 voiceIdsList = compound.method_10554("voiceIds", 8);
        String[] voiceIds = new String[voiceIdsList.size()];
        for (int i = 0; i < voiceIdsList.size(); ++i) {
            voiceIds[i] = voiceIdsList.method_10608(i);
        }
        return new Character(name, shortName, greetingInfo, description, skinURL, voiceIds);
    }

    public static void writeToNBT(class_2487 compound, Character character) {
        compound.method_10582("name", character.name());
        compound.method_10582("shortName", character.shortName());
        compound.method_10582("greetingInfo", character.greetingInfo());
        compound.method_10582("description", character.description());
        compound.method_10582("skinURL", character.skinURL());
        class_2499 voiceIds = new class_2499();
        for (String id : character.voiceIds()) {
            voiceIds.add((Object)class_2519.method_23256((String)id));
        }
        compound.method_10566("voiceIds", (class_2520)voiceIds);
    }
}

