/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.resources.CollectRecipeCataloguedResourcesTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.time.TimerGame;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;

public class CraftInInventoryTask
extends ResourceTask {
    private final RecipeTarget target;
    private final boolean collect;
    private final boolean ignoreUncataloguedSlots;
    private final TimerGame craftTimer = new TimerGame(2.0);
    private boolean isCrafting = false;

    public CraftInInventoryTask(RecipeTarget target, boolean collect, boolean ignoreUncataloguedSlots) {
        super(new ItemTarget(target.getOutputItem(), target.getTargetCount()));
        this.target = target;
        this.collect = collect;
        this.ignoreUncataloguedSlots = ignoreUncataloguedSlots;
        if (target.getRecipe().isBig()) {
            Debug.logError("CraftInInventoryTask was used for a 3x3 recipe. This is not supported. Use CraftInTableTask instead.");
        }
    }

    public CraftInInventoryTask(RecipeTarget target) {
        this(target, true, false);
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController controller) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController controller) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController controller) {
        int targetCount = this.target.getTargetCount();
        class_1792 outputItem = this.target.getOutputItem();
        if (controller.getItemStorage().getItemCount(outputItem) >= targetCount) {
            return null;
        }
        if (this.collect && !StorageHelper.hasRecipeMaterialsOrTarget(controller, this.target)) {
            this.setDebugState("Collecting ingredients for " + outputItem.method_7848().getString());
            return new CollectRecipeCataloguedResourcesTask(this.ignoreUncataloguedSlots, this.target);
        }
        this.setDebugState("Crafting " + outputItem.method_7848().getString());
        if (!this.isCrafting) {
            this.craftTimer.reset();
            this.isCrafting = true;
        }
        if (!this.craftTimer.elapsed()) {
            return null;
        }
        int craftsNeeded = (int)Math.ceil((double)(targetCount - controller.getItemStorage().getItemCount(outputItem)) / (double)this.target.getRecipe().outputCount());
        if (craftsNeeded <= 0) {
            return null;
        }
        LivingEntityInventory inventory = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
        for (int i = 0; i < craftsNeeded; ++i) {
            if (!StorageHelper.hasRecipeMaterialsOrTarget(controller, new RecipeTarget(this.target.getOutputItem(), this.target.getRecipe().outputCount(), this.target.getRecipe()))) {
                Debug.logWarning("Failed to craft " + outputItem.method_7848().getString() + ", not enough ingredients even though we passed the initial check.");
                break;
            }
            for (ItemTarget ingredient : this.target.getRecipe().getSlots()) {
                if (ingredient == null || ingredient.isEmpty()) continue;
                inventory.remove(stack -> ingredient.matches(stack.method_7909()), ingredient.getTargetCount(), inventory);
            }
            class_1799 result = new class_1799((class_1935)this.target.getOutputItem(), this.target.getRecipe().outputCount());
            inventory.insertStack(result);
            controller.getItemStorage().registerSlotAction();
        }
        controller.getEntity().method_6104(class_1268.field_5808);
        return null;
    }

    @Override
    protected void onResourceStop(PlayerEngineController controller, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (other instanceof CraftInInventoryTask) {
            CraftInInventoryTask task = (CraftInInventoryTask)other;
            bl = task.target.equals(this.target);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Craft in inventory: " + this.target.getOutputItem().method_7848().getString();
    }

    public RecipeTarget getRecipeTarget() {
        return this.target;
    }
}

