/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.goals.GoalNear;
import com.player2.playerengine.automaton.api.pathing.goals.GoalTwoBlocks;
import com.player2.playerengine.automaton.api.process.ICustomGoalProcess;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.SafeRandomShimmyTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.baritone.GoalAnd;
import com.player2.playerengine.util.baritone.GoalBlockSide;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import com.player2.playerengine.util.slots.Slot;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2356;
import net.minecraft.class_2382;

public class InteractWithBlockTask
extends Task {
    private final MovementProgressChecker moveChecker = new MovementProgressChecker();
    private final MovementProgressChecker stuckCheck = new MovementProgressChecker();
    private final ItemTarget toUse;
    private final class_2350 direction;
    private final class_2338 target;
    private final boolean walkInto;
    private final class_2382 interactOffset;
    private final Input interactInput;
    private final boolean shiftClick;
    private final TimerGame clickTimer = new TimerGame(5.0);
    private final TimeoutWanderTask wanderTask = new TimeoutWanderTask(5.0f, true);
    class_2248[] annoyingBlocks = new class_2248[]{class_2246.field_10597, class_2246.field_22117, class_2246.field_28675, class_2246.field_28676, class_2246.field_23078, class_2246.field_23079, class_2246.field_22124, class_2246.field_9983, class_2246.field_28682, class_2246.field_28683, class_2246.field_28684, class_2246.field_10214, class_2246.field_10219, class_2246.field_16999};
    private Task unstuckTask = null;
    private ClickResponse cachedClickStatus = ClickResponse.CANT_REACH;
    private int waitingForClickTicks = 0;

    public InteractWithBlockTask(ItemTarget toUse, class_2350 direction, class_2338 target, Input interactInput, boolean walkInto, class_2382 interactOffset, boolean shiftClick) {
        this.toUse = toUse;
        this.direction = direction;
        this.target = target;
        this.interactInput = interactInput;
        this.walkInto = walkInto;
        this.interactOffset = interactOffset;
        this.shiftClick = shiftClick;
    }

    public InteractWithBlockTask(ItemTarget toUse, class_2350 direction, class_2338 target, Input interactInput, boolean walkInto, boolean shiftClick) {
        this(toUse, direction, target, interactInput, walkInto, class_2382.field_11176, shiftClick);
    }

    public InteractWithBlockTask(ItemTarget toUse, class_2350 direction, class_2338 target, boolean walkInto) {
        this(toUse, direction, target, Input.CLICK_RIGHT, walkInto, true);
    }

    public InteractWithBlockTask(ItemTarget toUse, class_2338 target, boolean walkInto, class_2382 interactOffset) {
        this(toUse, null, target, Input.CLICK_RIGHT, walkInto, interactOffset, true);
    }

    public InteractWithBlockTask(ItemTarget toUse, class_2338 target, boolean walkInto) {
        this(toUse, target, walkInto, class_2382.field_11176);
    }

    public InteractWithBlockTask(ItemTarget toUse, class_2338 target) {
        this(toUse, target, false);
    }

    public InteractWithBlockTask(class_1792 toUse, class_2350 direction, class_2338 target, Input interactInput, boolean walkInto, class_2382 interactOffset, boolean shiftClick) {
        this(new ItemTarget(toUse, 1), direction, target, interactInput, walkInto, interactOffset, shiftClick);
    }

    public InteractWithBlockTask(class_1792 toUse, class_2350 direction, class_2338 target, Input interactInput, boolean walkInto, boolean shiftClick) {
        this(new ItemTarget(toUse, 1), direction, target, interactInput, walkInto, shiftClick);
    }

    public InteractWithBlockTask(class_1792 toUse, class_2350 direction, class_2338 target, boolean walkInto) {
        this(new ItemTarget(toUse, 1), direction, target, walkInto);
    }

    public InteractWithBlockTask(class_1792 toUse, class_2350 direction, class_2338 target) {
        this(new ItemTarget(toUse, 1), direction, target, Input.CLICK_RIGHT, false, false);
    }

    public InteractWithBlockTask(class_1792 toUse, class_2338 target, boolean walkInto, class_2382 interactOffset) {
        this(new ItemTarget(toUse, 1), target, walkInto, interactOffset);
    }

    public InteractWithBlockTask(class_1792 toUse, class_2350 direction, class_2338 target, class_2382 interactOffset) {
        this(new ItemTarget(toUse, 1), direction, target, Input.CLICK_RIGHT, false, interactOffset, false);
    }

    public InteractWithBlockTask(class_1792 toUse, class_2338 target, class_2382 interactOffset) {
        this(new ItemTarget(toUse, 1), null, target, Input.CLICK_RIGHT, false, interactOffset, false);
    }

    public InteractWithBlockTask(class_1792 toUse, class_2338 target, boolean walkInto) {
        this(new ItemTarget(toUse, 1), target, walkInto);
    }

    public InteractWithBlockTask(class_1792 toUse, class_2338 target) {
        this(new ItemTarget(toUse, 1), target);
    }

    public InteractWithBlockTask(class_2338 target, boolean shiftClick) {
        this(ItemTarget.EMPTY, null, target, Input.CLICK_RIGHT, false, shiftClick);
    }

    public InteractWithBlockTask(class_2338 target) {
        this(ItemTarget.EMPTY, null, target, Input.CLICK_RIGHT, false, false);
    }

    private static class_2338[] generateSides(class_2338 pos) {
        return new class_2338[]{pos.method_10069(1, 0, 0), pos.method_10069(-1, 0, 0), pos.method_10069(0, 0, 1), pos.method_10069(0, 0, -1), pos.method_10069(1, 0, -1), pos.method_10069(1, 0, 1), pos.method_10069(-1, 0, -1), pos.method_10069(-1, 0, 1)};
    }

    private static Goal createGoalForInteract(class_2338 target, int reachDistance, class_2350 interactSide, class_2382 interactOffset, boolean walkInto) {
        boolean sideMatters;
        boolean bl = sideMatters = interactSide != null;
        if (sideMatters) {
            class_2382 offs = interactSide.method_10163();
            if (offs.method_10264() == -1) {
                offs = offs.method_23228();
            }
            target = target.method_10081(offs);
        }
        if (walkInto) {
            return new GoalTwoBlocks(target);
        }
        if (sideMatters) {
            GoalBlockSide goalBlockSide = new GoalBlockSide(target, interactSide, 1.0);
            return new GoalAnd(goalBlockSide, new GoalNear(target.method_10081(interactOffset), reachDistance));
        }
        return new GoalTwoBlocks(target.method_10084());
    }

    private boolean isAnnoying(PlayerEngineController mod, class_2338 pos) {
        class_2248[] arrayOfBlock;
        int i;
        int b;
        if (this.annoyingBlocks != null && (b = 0) < (i = (arrayOfBlock = this.annoyingBlocks).length)) {
            class_2248 AnnoyingBlocks = arrayOfBlock[b];
            return mod.getWorld().method_8320(pos).method_26204() == AnnoyingBlocks || mod.getWorld().method_8320(pos).method_26204() instanceof class_2323 || mod.getWorld().method_8320(pos).method_26204() instanceof class_2354 || mod.getWorld().method_8320(pos).method_26204() instanceof class_2349 || mod.getWorld().method_8320(pos).method_26204() instanceof class_2356;
        }
        return false;
    }

    private class_2338 stuckInBlock(PlayerEngineController mod) {
        class_2338[] toCheckHigh;
        class_2338[] toCheck;
        class_2338 p = mod.getPlayer().method_24515();
        if (this.isAnnoying(mod, p)) {
            return p;
        }
        if (this.isAnnoying(mod, p.method_10084())) {
            return p.method_10084();
        }
        for (class_2338 check : toCheck = InteractWithBlockTask.generateSides(p)) {
            if (!this.isAnnoying(mod, check)) continue;
            return check;
        }
        for (class_2338 checkx : toCheckHigh = InteractWithBlockTask.generateSides(p.method_10084())) {
            if (!this.isAnnoying(mod, checkx)) continue;
            return checkx;
        }
        return null;
    }

    private Task getFenceUnstuckTask() {
        return new SafeRandomShimmyTask();
    }

    @Override
    protected void onStart() {
        this.controller.getBaritone().getPathingBehavior().forceCancel();
        this.moveChecker.reset();
        this.stuckCheck.reset();
        this.wanderTask.resetWander();
        this.clickTimer.reset();
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.moveChecker.reset();
        }
        if (WorldHelper.isInNetherPortal(this.controller)) {
            if (!mod.getBaritone().getPathingBehavior().isPathing()) {
                this.setDebugState("Getting out from nether portal");
                mod.getInputControls().hold(Input.SNEAK);
                mod.getInputControls().hold(Input.MOVE_FORWARD);
                return null;
            }
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().release(Input.MOVE_BACK);
            mod.getInputControls().release(Input.MOVE_FORWARD);
        } else if (mod.getBaritone().getPathingBehavior().isPathing()) {
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().release(Input.MOVE_BACK);
            mod.getInputControls().release(Input.MOVE_FORWARD);
        }
        if (this.unstuckTask != null && this.unstuckTask.isActive() && !this.unstuckTask.isFinished() && this.stuckInBlock(mod) != null) {
            this.setDebugState("Getting unstuck from block.");
            this.stuckCheck.reset();
            mod.getBaritone().getCustomGoalProcess().onLostControl();
            mod.getBaritone().getExploreProcess().onLostControl();
            return this.unstuckTask;
        }
        if (!this.moveChecker.check(mod) || !this.stuckCheck.check(mod)) {
            class_2338 blockStuck = this.stuckInBlock(mod);
            if (blockStuck != null) {
                this.unstuckTask = this.getFenceUnstuckTask();
                return this.unstuckTask;
            }
            this.stuckCheck.reset();
        }
        this.cachedClickStatus = ClickResponse.CANT_REACH;
        if (!ItemTarget.nullOrEmpty(this.toUse) && !StorageHelper.itemTargetsMet(mod, this.toUse)) {
            this.moveChecker.reset();
            this.clickTimer.reset();
            return TaskCatalogue.getItemTask(this.toUse);
        }
        if (this.wanderTask.isActive() && !this.wanderTask.isFinished()) {
            this.moveChecker.reset();
            this.clickTimer.reset();
            return this.wanderTask;
        }
        if (!this.moveChecker.check(mod)) {
            Debug.logMessage("Failed, blacklisting and wandering.");
            mod.getBlockScanner().requestBlockUnreachable(this.target);
            return this.wanderTask;
        }
        int reachDistance = 0;
        Goal moveGoal = InteractWithBlockTask.createGoalForInteract(this.target, reachDistance, this.direction, this.interactOffset, this.walkInto);
        ICustomGoalProcess customGoalProcess = mod.getBaritone().getCustomGoalProcess();
        this.cachedClickStatus = this.rightClick(mod);
        switch (Objects.requireNonNull(this.cachedClickStatus).ordinal()) {
            case 0: {
                this.setDebugState("Getting to our goal");
                if (!customGoalProcess.isActive()) {
                    customGoalProcess.setGoalAndPath(moveGoal);
                }
                this.clickTimer.reset();
                break;
            }
            case 1: {
                this.setDebugState("Waiting for click");
                if (customGoalProcess.isActive()) {
                    customGoalProcess.onLostControl();
                }
                this.clickTimer.reset();
                ++this.waitingForClickTicks;
                if (this.waitingForClickTicks % 25 == 0 && this.shiftClick) {
                    mod.getInputControls().hold(Input.SNEAK);
                    mod.log("trying to press shift");
                }
                if (this.waitingForClickTicks <= 200) break;
                mod.log("trying to wander");
                this.waitingForClickTicks = 0;
                return this.wanderTask;
            }
            case 2: {
                this.setDebugState("Clicking.");
                if (customGoalProcess.isActive()) {
                    customGoalProcess.onLostControl();
                }
                if (!this.clickTimer.elapsed()) break;
                this.clickTimer.reset();
                return this.wanderTask;
            }
        }
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
        PlayerEngineController mod = this.controller;
        mod.getBaritone().getPathingBehavior().forceCancel();
        mod.getInputControls().release(Input.SNEAK);
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    protected boolean isEqual(Task other) {
        if (other instanceof InteractWithBlockTask) {
            InteractWithBlockTask task = (InteractWithBlockTask)other;
            if (task.direction == null != (this.direction == null)) {
                return false;
            }
            if (task.direction != null && !task.direction.equals((Object)this.direction)) {
                return false;
            }
            if (task.toUse == null != (this.toUse == null)) {
                return false;
            }
            if (task.toUse != null && !task.toUse.equals(this.toUse)) {
                return false;
            }
            if (!task.target.equals((Object)this.target)) {
                return false;
            }
            return !task.interactInput.equals((Object)this.interactInput) ? false : task.walkInto == this.walkInto;
        }
        return false;
    }

    @Override
    protected String toDebugString() {
        return "Interact using " + String.valueOf(this.toUse) + " at " + String.valueOf(this.target) + " dir " + String.valueOf(this.direction);
    }

    public ClickResponse getClickStatus() {
        return this.cachedClickStatus;
    }

    private ClickResponse rightClick(PlayerEngineController mod) {
        if (!(mod.getExtraBaritoneSettings().isInteractionPaused() || mod.getFoodChain().needsToEat() || mod.getPlayer().method_6039())) {
            class_1799 cursorStack = StorageHelper.getItemStackInCursorSlot(this.controller);
            if (!cursorStack.method_7960()) {
                Optional<Slot> moveTo = mod.getItemStorage().getSlotThatCanFitInPlayerInventory(cursorStack, false);
                if (moveTo.isPresent()) {
                    mod.getSlotHandler().clickSlot(moveTo.get(), 0, class_1713.field_7790);
                    return ClickResponse.WAIT_FOR_CLICK;
                }
                if (ItemHelper.canThrowAwayStack(mod, cursorStack)) {
                    mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, class_1713.field_7790);
                    return ClickResponse.WAIT_FOR_CLICK;
                }
                Optional<Slot> garbage = StorageHelper.getGarbageSlot(mod);
                if (garbage.isPresent()) {
                    mod.getSlotHandler().clickSlot(garbage.get(), 0, class_1713.field_7790);
                    return ClickResponse.WAIT_FOR_CLICK;
                }
                mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, class_1713.field_7790);
                return ClickResponse.WAIT_FOR_CLICK;
            }
            Optional<Rotation> reachable = this.getCurrentReach();
            if (reachable.isPresent()) {
                if (LookHelper.isLookingAt(mod, this.target)) {
                    if (this.toUse != null) {
                        mod.getSlotHandler().forceEquipItem(this.toUse, false);
                    } else {
                        mod.getSlotHandler().forceDeequipRightClickableItem();
                    }
                    mod.getInputControls().tryPress(this.interactInput);
                    if (mod.getInputControls().isHeldDown(this.interactInput)) {
                        if (this.shiftClick) {
                            mod.getInputControls().hold(Input.SNEAK);
                        }
                        return ClickResponse.CLICK_ATTEMPTED;
                    }
                } else {
                    LookHelper.lookAt(this.controller, reachable.get());
                }
                return ClickResponse.WAIT_FOR_CLICK;
            }
            if (this.shiftClick) {
                mod.getInputControls().release(Input.SNEAK);
            }
            return ClickResponse.CANT_REACH;
        }
        return ClickResponse.WAIT_FOR_CLICK;
    }

    public Optional<Rotation> getCurrentReach() {
        return LookHelper.getReach(this.controller, this.target, this.direction);
    }

    public static enum ClickResponse {
        CANT_REACH,
        WAIT_FOR_CLICK,
        CLICK_ATTEMPTED;

    }
}

