/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.container;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.mixins.MixinAbstractFurnaceBlockEntity;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PlaceBlockNearbyTask;
import com.player2.playerengine.tasks.movement.GetCloseToBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.resources.CollectFuelTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.SmeltTarget;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2609;

public class SmeltInFurnaceTask
extends ResourceTask {
    private final SmeltTarget[] targets;
    private final TimerGame smeltTimer = new TimerGame(10.0);
    private class_2338 furnacePos = null;
    private boolean isSmelting = false;

    public SmeltInFurnaceTask(SmeltTarget ... targets) {
        super(SmeltInFurnaceTask.extractItemTargets(targets));
        this.targets = targets;
    }

    public SmeltInFurnaceTask(SmeltTarget target) {
        this(new SmeltTarget[]{target});
    }

    private static ItemTarget[] extractItemTargets(SmeltTarget[] recipeTargets) {
        ArrayList<ItemTarget> result = new ArrayList<ItemTarget>(recipeTargets.length);
        for (SmeltTarget target : recipeTargets) {
            result.add(target.getItem());
        }
        return (ItemTarget[])result.toArray(ItemTarget[]::new);
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController controller) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController controller) {
        controller.getBehaviour().push();
        controller.getBehaviour().addProtectedItems(class_1802.field_8732);
        for (SmeltTarget target : this.targets) {
            controller.getBehaviour().addProtectedItems(target.getMaterial().getMatches());
        }
    }

    @Override
    protected Task onResourceTick(PlayerEngineController controller) {
        boolean allDone = Arrays.stream(this.targets).allMatch(target -> controller.getItemStorage().getItemCount(target.getItem()) >= target.getItem().getTargetCount());
        if (allDone) {
            this.setDebugState("Done smelting.");
            return null;
        }
        SmeltTarget currentTarget = null;
        for (SmeltTarget target2 : this.targets) {
            if (controller.getItemStorage().getItemCount(target2.getItem()) >= target2.getItem().getTargetCount()) continue;
            currentTarget = target2;
            break;
        }
        if (currentTarget == null) {
            Debug.logWarning("Smelting task is running, but all targets are met. This should not happen.");
            return null;
        }
        this.smeltTimer.setInterval(10 * currentTarget.getItem().getTargetCount());
        int fuelNeeded = (int)Math.ceil((double)currentTarget.getItem().getTargetCount() / 8.0);
        if (!this.isSmelting) {
            if (controller.getItemStorage().getItemCount(currentTarget.getMaterial()) < currentTarget.getMaterial().getTargetCount()) {
                this.setDebugState("Collecting materials for smelting: " + String.valueOf(currentTarget.getMaterial()));
                return TaskCatalogue.getItemTask(currentTarget.getMaterial());
            }
            if (StorageHelper.calculateInventoryFuelCount(controller) < (double)fuelNeeded) {
                this.setDebugState("Collecting fuel.");
                return new CollectFuelTask(fuelNeeded);
            }
        }
        if (this.furnacePos == null || !controller.getWorld().method_8320(this.furnacePos).method_27852(class_2246.field_10181)) {
            Optional<Object> nearestFurnace = controller.getBlockScanner().getNearestBlock(class_2246.field_10181);
            if (nearestFurnace.isPresent() && !nearestFurnace.get().method_19771(new class_2382((int)controller.getEntity().method_19538().field_1352, (int)controller.getEntity().method_19538().field_1351, (int)controller.getEntity().method_19538().field_1350), 100.0)) {
                nearestFurnace = Optional.empty();
            }
            if (!nearestFurnace.isPresent()) {
                if (controller.getItemStorage().hasItem(class_1802.field_8732)) {
                    this.setDebugState("Placing furnace.");
                    return new PlaceBlockNearbyTask(class_2246.field_10181);
                }
                this.setDebugState("Obtaining furnace.");
                return TaskCatalogue.getItemTask(class_1802.field_8732, 1);
            }
            this.furnacePos = nearestFurnace.get();
        }
        if (!this.furnacePos.method_19771(new class_2382((int)controller.getEntity().method_19538().field_1352, (int)controller.getEntity().method_19538().field_1351, (int)controller.getEntity().method_19538().field_1350), 4.5)) {
            this.setDebugState("Going to furnace.");
            return new GetCloseToBlockTask(this.furnacePos);
        }
        class_2586 class_25862 = controller.getWorld().method_8321(this.furnacePos);
        if (class_25862 instanceof class_2609) {
            class_2609 furnace = (class_2609)class_25862;
            class_1799 outputStack = furnace.method_5438(2);
            if (!outputStack.method_7960()) {
                this.setDebugState("Taking smelted items.");
                LivingEntityInventory playerInv = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
                if (!playerInv.insertStack(outputStack)) {
                    this.setDebugState("Inventory is full, cannot take smelted items.");
                    return null;
                }
                furnace.method_5447(2, class_1799.field_8037);
                furnace.method_5431();
            }
            if (this.isSmelting) {
                this.setDebugState("Waiting for items to smelt...");
                if (this.smeltTimer.elapsed()) {
                    this.isSmelting = false;
                }
                return null;
            }
            class_1799 materialSlot = furnace.method_5438(0);
            class_1799 fuelSlot = furnace.method_5438(1);
            LivingEntityInventory playerInv = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
            if (((MixinAbstractFurnaceBlockEntity)furnace).getPropertyDelegate().method_17390(0) <= 1 && fuelSlot.method_7960()) {
                this.setDebugState("Adding fuel.");
                class_1792 fuelItem = controller.getModSettings().getSupportedFuelItems()[0];
                int fuelSlotIndex = playerInv.getSlotWithStack(new class_1799((class_1935)fuelItem));
                if (fuelSlotIndex != -1) {
                    furnace.method_5447(1, playerInv.method_5434(fuelSlotIndex, fuelNeeded));
                    furnace.method_5431();
                }
            }
            if (materialSlot.method_7960()) {
                this.setDebugState("Adding material.");
                class_1792 materialItem = currentTarget.getMaterial().getMatches()[0];
                int materialSlotIndex = playerInv.getSlotWithStack(new class_1799((class_1935)materialItem));
                if (materialSlotIndex != -1) {
                    furnace.method_5447(0, playerInv.method_5434(materialSlotIndex, currentTarget.getMaterial().getTargetCount()));
                    this.isSmelting = true;
                    this.smeltTimer.reset();
                    furnace.method_5431();
                    return null;
                }
            }
            this.isSmelting = true;
            this.smeltTimer.reset();
            this.setDebugState("Waiting for furnace...");
            return null;
        }
        Debug.logWarning("Block at furnace position is not a furnace BE. Resetting.");
        this.furnacePos = null;
        return new TimeoutWanderTask(1.0f);
    }

    @Override
    protected void onResourceStop(PlayerEngineController controller, Task interruptTask) {
        controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (other instanceof SmeltInFurnaceTask) {
            SmeltInFurnaceTask task = (SmeltInFurnaceTask)other;
            bl = Arrays.equals(task.targets, this.targets);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Smelting in Furnace";
    }
}

