/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.container;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PlaceBlockNearbyTask;
import com.player2.playerengine.tasks.misc.EquipArmorTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.squashed.CataloguedResourceTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.StorageHelper;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class UpgradeInSmithingTableTask
extends ResourceTask {
    private final ItemTarget tool;
    private final ItemTarget template;
    private final ItemTarget material;
    private final ItemTarget output;
    private class_2338 tablePos = null;

    public UpgradeInSmithingTableTask(ItemTarget tool, ItemTarget material, ItemTarget output) {
        super(output);
        this.tool = new ItemTarget(tool, output.getTargetCount());
        this.material = new ItemTarget(material, output.getTargetCount());
        this.template = new ItemTarget(class_1802.field_41946, output.getTargetCount());
        this.output = output;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController controller) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController controller) {
        controller.getBehaviour().addProtectedItems(this.tool.getMatches());
        controller.getBehaviour().addProtectedItems(this.material.getMatches());
        controller.getBehaviour().addProtectedItems(this.template.getMatches());
        controller.getBehaviour().addProtectedItems(class_1802.field_16308);
    }

    @Override
    protected Task onResourceTick(PlayerEngineController controller) {
        int desiredOutputCount = this.output.getTargetCount();
        int currentOutputCount = controller.getItemStorage().getItemCount(this.output);
        if (currentOutputCount >= desiredOutputCount) {
            return null;
        }
        int needed = desiredOutputCount - currentOutputCount;
        if (controller.getItemStorage().getItemCount(this.tool) < needed || controller.getItemStorage().getItemCount(this.material) < needed || controller.getItemStorage().getItemCount(this.template) < needed) {
            this.setDebugState("Getting materials for upgrade");
            return new CataloguedResourceTask(new ItemTarget(this.tool, needed), new ItemTarget(this.material, needed), new ItemTarget(this.template, needed));
        }
        if (StorageHelper.isArmorEquipped(controller, this.tool.getMatches())) {
            this.setDebugState("Unequipping armor before upgrading.");
            return new EquipArmorTask(new ItemTarget[0]);
        }
        if (this.tablePos == null || !controller.getWorld().method_8320(this.tablePos).method_27852(class_2246.field_16329)) {
            Optional<class_2338> nearestTable = controller.getBlockScanner().getNearestBlock(class_2246.field_16329);
            if (!nearestTable.isPresent()) {
                if (controller.getItemStorage().hasItem(class_1802.field_16308)) {
                    this.setDebugState("Placing smithing table.");
                    return new PlaceBlockNearbyTask(class_2246.field_16329);
                }
                this.setDebugState("Obtaining smithing table.");
                return TaskCatalogue.getItemTask(class_1802.field_16308, 1);
            }
            this.tablePos = nearestTable.get();
        }
        if (!this.tablePos.method_19771(new class_2382((int)controller.getEntity().method_19538().field_1352, (int)controller.getEntity().method_19538().field_1351, (int)controller.getEntity().method_19538().field_1350), 4.5)) {
            this.setDebugState("Going to smithing table.");
            return new GetToBlockTask(this.tablePos);
        }
        this.setDebugState("Upgrading item...");
        LivingEntityInventory inventory = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
        inventory.remove(stack -> this.template.matches(stack.method_7909()), 1, inventory);
        inventory.remove(stack -> this.tool.matches(stack.method_7909()), 1, inventory);
        inventory.remove(stack -> this.material.matches(stack.method_7909()), 1, inventory);
        inventory.insertStack(new class_1799((class_1935)this.output.getMatches()[0], 1));
        controller.getItemStorage().registerSlotAction();
        return null;
    }

    @Override
    protected void onResourceStop(PlayerEngineController controller, Task interruptTask) {
        controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (!(other instanceof UpgradeInSmithingTableTask)) {
            bl = false;
        } else {
            UpgradeInSmithingTableTask task = (UpgradeInSmithingTableTask)other;
            bl = task.tool.equals(this.tool) && task.output.equals(this.output) && task.material.equals(this.material);
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Upgrading in Smithing Table";
    }

    public ItemTarget getMaterials() {
        return this.material;
    }

    public ItemTarget getTools() {
        return this.tool;
    }

    public ItemTarget getTemplate() {
        return this.template;
    }
}

