/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.entity;

import com.player2.playerengine.BotBehaviour;
import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.FollowPlayerTask;
import com.player2.playerengine.tasks.movement.RunAwayFromPositionTask;
import com.player2.playerengine.tasks.squashed.CataloguedResourceTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.slots.Slot;
import com.player2.playerengine.util.time.TimerGame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2374;
import net.minecraft.class_243;

public class GiveItemToPlayerTask
extends Task {
    private final String playerName;
    private final ItemTarget[] targets;
    private final CataloguedResourceTask resourceTask;
    private final List<ItemTarget> throwTarget = new ArrayList<ItemTarget>();
    private boolean droppingItems;
    private Task throwTask;
    private TimerGame throwTimeout = new TimerGame(0.4);

    public GiveItemToPlayerTask(String player, ItemTarget ... targets) {
        this.playerName = player;
        this.targets = targets;
        this.resourceTask = TaskCatalogue.getSquashedItemTask(targets);
    }

    @Override
    protected void onStart() {
        this.droppingItems = false;
        this.throwTarget.clear();
        BotBehaviour botBehaviour = this.controller.getBehaviour();
        botBehaviour.push();
        botBehaviour.addProtectedItems(ItemTarget.getMatches(this.targets));
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (this.throwTask != null && this.throwTask.isActive() && !this.throwTask.isFinished()) {
            this.setDebugState("Throwing items");
            return this.throwTask;
        }
        Optional<class_243> lastPos = mod.getEntityTracker().getPlayerMostRecentPosition(this.playerName);
        if (lastPos.isEmpty()) {
            String nearbyUsernames = String.join((CharSequence)",", mod.getEntityTracker().getAllLoadedPlayerUsernames());
            this.fail("No user in render distance found with username \"" + this.playerName + "\". Maybe this was a typo or there is a user with a similar name around? Nearby users: [" + nearbyUsernames + "].");
            return null;
        }
        class_243 targetPos = lastPos.get().method_1031(0.0, (double)0.2f, 0.0);
        if (this.droppingItems) {
            this.setDebugState("Throwing items");
            if (!this.throwTimeout.elapsed()) {
                return null;
            }
            this.throwTimeout.reset();
            LookHelper.lookAt(mod, targetPos);
            for (int i = 0; i < this.throwTarget.size(); ++i) {
                Optional has;
                ItemTarget target = this.throwTarget.get(i);
                int neededToThrow = target.getTargetCount();
                if (target.getTargetCount() <= 0 || !(has = mod.getItemStorage().getSlotsWithItemPlayerInventory(false, target.getMatches()).stream().findFirst()).isPresent()) continue;
                Slot slot = (Slot)has.get();
                class_1799 stack = StorageHelper.getItemStackInSlot(slot);
                int amountToThrow = Math.min(neededToThrow, stack.method_7947());
                mod.getSlotHandler().forceEquipSlot(mod, slot);
                mod.getPlayer().method_5699(mod.getPlayer().method_6047(), (float)amountToThrow).method_6982(40);
                mod.getInventory().method_5447(mod.getInventory().selectedSlot, class_1799.field_8037);
                this.throwTarget.set(i, new ItemTarget(target, neededToThrow - amountToThrow));
                return null;
            }
            this.throwTimeout.forceElapse();
            if (!targetPos.method_24802((class_2374)mod.getPlayer().method_19538(), 4.0)) {
                mod.log("Finished giving items.");
                this.stop();
                return null;
            }
            return new RunAwayFromPositionTask(6.0, WorldHelper.toBlockPos(targetPos));
        }
        if (!StorageHelper.itemTargetsMet(mod, this.targets)) {
            this.setDebugState("Collecting resources...");
            return this.resourceTask;
        }
        if (targetPos.method_24802((class_2374)mod.getPlayer().method_19538(), 4.0)) {
            if (!mod.getEntityTracker().isPlayerLoaded(this.playerName)) {
                String nearbyUsernames = String.join((CharSequence)",", mod.getEntityTracker().getAllLoadedPlayerUsernames());
                this.fail("Failed to get to player \"" + this.playerName + "\". We moved to where we last saw them but now have no idea where they are. Nearby players: [" + nearbyUsernames + "]");
                return null;
            }
            class_1657 p = mod.getEntityTracker().getPlayerEntity(this.playerName).get();
            if ((p.method_24515().method_10264() <= mod.getPlayer().method_24515().method_10264() || p.method_19538().method_1022(mod.getPlayer().method_19538()) <= 0.5) && LookHelper.seesPlayer((class_1297)p, (class_1297)mod.getPlayer(), 6.0)) {
                this.droppingItems = true;
                this.throwTarget.addAll(Arrays.asList(this.targets));
                this.throwTimeout.reset();
            }
        }
        this.setDebugState("Going to player...");
        return new FollowPlayerTask(this.playerName, 0.5);
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        if (other instanceof GiveItemToPlayerTask) {
            GiveItemToPlayerTask task = (GiveItemToPlayerTask)other;
            return !task.playerName.equals(this.playerName) ? false : Arrays.equals(task.targets, this.targets);
        }
        return false;
    }

    @Override
    protected String toDebugString() {
        return "Giving items to " + this.playerName;
    }
}

