/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.misc;

import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.container.LootContainerTask;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class LootDesertTempleTask
extends Task {
    public final class_2382[] CHEST_POSITIONS_RELATIVE = new class_2382[]{new class_2382(2, 0, 0), new class_2382(-2, 0, 0), new class_2382(0, 0, 2), new class_2382(0, 0, -2)};
    private final class_2338 temple;
    private final List<class_1792> wanted;
    private Task lootTask;
    private short looted = 0;

    public LootDesertTempleTask(class_2338 temple, List<class_1792> wanted) {
        this.temple = temple;
        this.wanted = wanted;
    }

    @Override
    protected void onStart() {
        this.controller.getBaritoneSettings().blocksToAvoid.get().add(class_2246.field_10158);
    }

    @Override
    protected Task onTick() {
        if (this.lootTask != null) {
            if (!this.lootTask.isFinished()) {
                this.setDebugState("Looting a desert temple chest");
                return this.lootTask;
            }
            this.looted = (short)(this.looted + 1);
        }
        if (this.controller.getWorld().method_8320(this.temple).method_26204() == class_2246.field_10158) {
            this.setDebugState("Breaking pressure plate");
            return new DestroyBlockTask(this.temple);
        }
        if (this.looted < 4) {
            this.setDebugState("Looting a desert temple chest");
            this.lootTask = new LootContainerTask(this.temple.method_10081(this.CHEST_POSITIONS_RELATIVE[this.looted]), this.wanted);
            return this.lootTask;
        }
        this.setDebugState("Why is this still running? Report this");
        return null;
    }

    @Override
    protected void onStop(Task task) {
        this.controller.getBaritoneSettings().blocksToAvoid.get().remove(class_2246.field_10158);
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof LootDesertTempleTask && ((LootDesertTempleTask)other).getTemplePos() == this.temple;
    }

    @Override
    public boolean isFinished() {
        return this.looted == 4;
    }

    @Override
    protected String toDebugString() {
        return "Looting Desert Temple";
    }

    public class_2338 getTemplePos() {
        return this.temple;
    }
}

