/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.AbstractDoToClosestObjectTask;
import com.player2.playerengine.tasks.base.ITaskRequiresGrounded;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToEntityTask;
import com.player2.playerengine.tasks.movement.SafeRandomShimmyTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.resources.SatisfyMiningRequirementTask;
import com.player2.playerengine.tasks.slot.EnsureFreeInventorySlotTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.helpers.StlHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2356;
import net.minecraft.class_243;

public class PickupDroppedItemTask
extends AbstractDoToClosestObjectTask<class_1542>
implements ITaskRequiresGrounded {
    private static final Task getPickaxeFirstTask = new SatisfyMiningRequirementTask(MiningRequirement.STONE);
    private static boolean isGettingPickaxeFirstFlag = false;
    private final TimeoutWanderTask wanderTask = new TimeoutWanderTask(5.0f, true);
    private final MovementProgressChecker stuckCheck = new MovementProgressChecker();
    private final MovementProgressChecker progressChecker = new MovementProgressChecker();
    private final ItemTarget[] itemTargets;
    private final Set<class_1542> blacklist = new HashSet<class_1542>();
    private final boolean freeInventoryIfFull;
    class_2248[] annoyingBlocks = new class_2248[]{class_2246.field_10597, class_2246.field_22117, class_2246.field_28675, class_2246.field_28676, class_2246.field_23078, class_2246.field_23079, class_2246.field_22124, class_2246.field_9983, class_2246.field_28682, class_2246.field_28683, class_2246.field_28684, class_2246.field_10214, class_2246.field_10219};
    private Task unstuckTask = null;
    private PlayerEngineController mod;
    private boolean collectingPickaxeForThisResource = false;
    private class_1542 currentDrop = null;

    public PickupDroppedItemTask(ItemTarget[] itemTargets, boolean freeInventoryIfFull) {
        this.itemTargets = itemTargets;
        this.freeInventoryIfFull = freeInventoryIfFull;
    }

    public PickupDroppedItemTask(ItemTarget target, boolean freeInventoryIfFull) {
        this(new ItemTarget[]{target}, freeInventoryIfFull);
    }

    public PickupDroppedItemTask(class_1792 item, int targetCount, boolean freeInventoryIfFull) {
        this(new ItemTarget(item, targetCount), freeInventoryIfFull);
    }

    public PickupDroppedItemTask(class_1792 item, int targetCount) {
        this(item, targetCount, true);
    }

    private static class_2338[] generateSides(class_2338 pos) {
        return new class_2338[]{pos.method_10069(1, 0, 0), pos.method_10069(-1, 0, 0), pos.method_10069(0, 0, 1), pos.method_10069(0, 0, -1), pos.method_10069(1, 0, -1), pos.method_10069(1, 0, 1), pos.method_10069(-1, 0, -1), pos.method_10069(-1, 0, 1)};
    }

    public static boolean isIsGettingPickaxeFirst(PlayerEngineController mod) {
        return isGettingPickaxeFirstFlag && mod.getModSettings().shouldCollectPickaxeFirst();
    }

    private boolean isAnnoying(PlayerEngineController mod, class_2338 pos) {
        class_2248[] var3;
        int var4;
        int var5;
        if (this.annoyingBlocks != null && (var5 = 0) < (var4 = (var3 = this.annoyingBlocks).length)) {
            class_2248 AnnoyingBlocks = var3[var5];
            return mod.getWorld().method_8320(pos).method_26204() == AnnoyingBlocks || mod.getWorld().method_8320(pos).method_26204() instanceof class_2323 || mod.getWorld().method_8320(pos).method_26204() instanceof class_2354 || mod.getWorld().method_8320(pos).method_26204() instanceof class_2349 || mod.getWorld().method_8320(pos).method_26204() instanceof class_2356;
        }
        return false;
    }

    private class_2338 stuckInBlock(PlayerEngineController mod) {
        class_2338[] toCheckHigh;
        class_2338[] toCheck;
        class_2338 p = mod.getPlayer().method_24515();
        if (this.isAnnoying(mod, p)) {
            return p;
        }
        if (this.isAnnoying(mod, p.method_10084())) {
            return p.method_10084();
        }
        for (class_2338 check : toCheck = PickupDroppedItemTask.generateSides(p)) {
            if (!this.isAnnoying(mod, check)) continue;
            return check;
        }
        for (class_2338 checkx : toCheckHigh = PickupDroppedItemTask.generateSides(p.method_10084())) {
            if (!this.isAnnoying(mod, checkx)) continue;
            return checkx;
        }
        return null;
    }

    private Task getFenceUnstuckTask() {
        return new SafeRandomShimmyTask();
    }

    public boolean isCollectingPickaxeForThis() {
        return this.collectingPickaxeForThisResource;
    }

    @Override
    protected void onStart() {
        this.wanderTask.reset();
        this.progressChecker.reset();
        this.stuckCheck.reset();
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected Task onTick() {
        if (this.wanderTask.isActive() && !this.wanderTask.isFinished()) {
            this.setDebugState("Wandering.");
            return this.wanderTask;
        }
        PlayerEngineController mod = this.controller;
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.progressChecker.reset();
        }
        if (this.unstuckTask != null && this.unstuckTask.isActive() && !this.unstuckTask.isFinished() && this.stuckInBlock(mod) != null) {
            this.setDebugState("Getting unstuck from block.");
            this.stuckCheck.reset();
            mod.getBaritone().getCustomGoalProcess().onLostControl();
            mod.getBaritone().getExploreProcess().onLostControl();
            return this.unstuckTask;
        }
        if (!this.progressChecker.check(mod) || !this.stuckCheck.check(mod)) {
            class_2338 blockStuck = this.stuckInBlock(mod);
            if (blockStuck != null) {
                this.unstuckTask = this.getFenceUnstuckTask();
                return this.unstuckTask;
            }
            this.stuckCheck.reset();
        }
        this.mod = mod;
        if (PickupDroppedItemTask.isIsGettingPickaxeFirst(mod) && this.collectingPickaxeForThisResource && !StorageHelper.miningRequirementMetInventory(this.controller, MiningRequirement.STONE)) {
            this.progressChecker.reset();
            this.setDebugState("Collecting pickaxe first");
            return getPickaxeFirstTask;
        }
        if (StorageHelper.miningRequirementMetInventory(this.controller, MiningRequirement.STONE)) {
            isGettingPickaxeFirstFlag = false;
        }
        this.collectingPickaxeForThisResource = false;
        if (!this.progressChecker.check(mod)) {
            mod.getBaritone().getPathingBehavior().forceCancel();
            if (this.currentDrop != null && !this.currentDrop.method_6983().method_7960()) {
                if (!isGettingPickaxeFirstFlag && mod.getModSettings().shouldCollectPickaxeFirst() && !StorageHelper.miningRequirementMetInventory(this.controller, MiningRequirement.STONE)) {
                    Debug.logMessage("Failed to pick up drop, will try to collect a stone pickaxe first and try again!");
                    this.collectingPickaxeForThisResource = true;
                    isGettingPickaxeFirstFlag = true;
                    return getPickaxeFirstTask;
                }
                Debug.logMessage(StlHelper.toString(this.blacklist, element -> element == null ? "(null)" : element.method_6983().method_7909().method_7876()));
                Debug.logMessage("Failed to pick up drop, suggesting it's unreachable.");
                this.blacklist.add(this.currentDrop);
                mod.getEntityTracker().requestEntityUnreachable((class_1297)this.currentDrop);
                return this.wanderTask;
            }
        }
        return super.onTick();
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof PickupDroppedItemTask)) {
            bl = false;
        } else {
            PickupDroppedItemTask task = (PickupDroppedItemTask)other;
            bl = Arrays.equals(task.itemTargets, this.itemTargets) && task.freeInventoryIfFull == this.freeInventoryIfFull;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        StringBuilder result = new StringBuilder();
        result.append("Pickup Dropped Items: [");
        int c = 0;
        for (ItemTarget target : this.itemTargets) {
            result.append(target.toString());
            if (++c == this.itemTargets.length) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    @Override
    protected class_243 getPos(PlayerEngineController mod, class_1542 obj) {
        if (!obj.method_24828() && !obj.method_5799()) {
            class_2338 p = obj.method_24515();
            return !WorldHelper.isSolidBlock(this.controller, p.method_10087(3)) ? obj.method_19538().method_1023(0.0, 2.0, 0.0) : obj.method_19538().method_1023(0.0, 1.0, 0.0);
        }
        return obj.method_19538();
    }

    @Override
    protected Optional<class_1542> getClosestTo(PlayerEngineController mod, class_243 pos) {
        return mod.getEntityTracker().getClosestItemDrop(pos, this.itemTargets);
    }

    @Override
    protected class_243 getOriginPos(PlayerEngineController mod) {
        return mod.getPlayer().method_19538();
    }

    @Override
    protected Task getGoalTask(class_1542 itemEntity) {
        boolean touching;
        if (!itemEntity.equals((Object)this.currentDrop)) {
            this.currentDrop = itemEntity;
            this.progressChecker.reset();
            if (isGettingPickaxeFirstFlag && this.collectingPickaxeForThisResource) {
                Debug.logMessage("New goal, no longer collecting a pickaxe.");
                this.collectingPickaxeForThisResource = false;
                isGettingPickaxeFirstFlag = false;
            }
        }
        return (touching = this.mod.getEntityTracker().isCollidingWithPlayer((class_1297)itemEntity)) && this.freeInventoryIfFull && this.mod.getItemStorage().getSlotsThatCanFitInPlayerInventory(itemEntity.method_6983(), false).isEmpty() ? new EnsureFreeInventorySlotTask() : new GetToEntityTask((class_1297)itemEntity);
    }

    @Override
    protected boolean isValid(PlayerEngineController mod, class_1542 obj) {
        return obj.method_5805() && !this.blacklist.contains(obj);
    }
}

